/*
 * Decompiled with CFR 0.152.
 */
package org.voegl.analogkey4j.plugins;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.hid4java.HidDevice;
import org.voegl.analogkey4j.event.AnalogKeyState;
import org.voegl.analogkey4j.event.AnalogKeyboardListenerList;
import org.voegl.analogkey4j.parser.HidParser;

public abstract class AnalogKeyboardDevice {
    protected final HidDevice device;
    private final AnalogKeyboardListenerList listeners;
    private static final int HID_MESSAGE_SIZE = 48;
    private Thread readThread;
    private final HidParser parser;
    private boolean readDone = true;

    public AnalogKeyboardDevice(HidDevice device, HidParser parser, AnalogKeyboardListenerList listeners) {
        this.device = device;
        this.parser = parser;
        this.listeners = listeners;
    }

    private synchronized Runnable getReadRunnable() {
        return () -> {
            this.readDone = false;
            block4: while (!this.readDone) {
                byte[] data = new byte[48];
                int val = this.device.read(data, 1000);
                switch (val) {
                    case -1: {
                        this.listeners.fireKeyboardError(this, this.device.getLastErrorMessage());
                        continue block4;
                    }
                    case 0: {
                        continue block4;
                    }
                }
                Set<AnalogKeyState> keyStates = this.parser.parse(data, val);
                this.listeners.fireKeyPressed(this, keyStates);
            }
            this.device.close();
            this.listeners.fireKeyboardClosed(this);
        };
    }

    public boolean isClosed() {
        return this.readThread == null || !this.readThread.isAlive();
    }

    public void open() {
        if (!this.isClosed()) {
            throw new IllegalStateException("Device is already open.");
        }
        this.device.open();
        this.device.setNonBlocking(true);
        this.readThread = new Thread(this.getReadRunnable());
        this.readThread.setDaemon(true);
        this.readThread.setName("analog keyboard reader");
        this.readThread.start();
        this.listeners.fireKeyboardOpened(this);
    }

    public void close() {
        if (this.isClosed()) {
            throw new IllegalStateException("Device is not open.");
        }
        this.readDone = true;
    }

    public int getVendorId() {
        return this.device.getVendorId();
    }

    public int getProductId() {
        return this.device.getProductId();
    }

    public int getUsagePage() {
        return this.device.getUsagePage();
    }

    public String getSerialNumber() {
        return this.device.getSerialNumber();
    }

    public abstract boolean isResponsible();

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalogKeyboardDevice that = (AnalogKeyboardDevice)o;
        return Objects.equals(this.device, that.device);
    }

    public int hashCode() {
        return Objects.hashCode(this.device);
    }

    @Generated
    public HidDevice getDevice() {
        return this.device;
    }

    @Generated
    public boolean isReadDone() {
        return this.readDone;
    }
}

