package net.verotek.libanalog.mixin;

import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.verotek.libanalog.api.AnalogKeyStates;
import net.verotek.libanalog.interfaces.mixin.IAnalogKeybinding;
import net.verotek.libanalog.interfaces.mixin.IAnalogKeyboard;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Implements(@Interface(iface = IAnalogKeybinding.class, prefix = "libanalog$"))
@Mixin(class_304.class)
public abstract class AnalogKeybinding implements IAnalogKeybinding {

  @Shadow
  private boolean pressed;
  @Shadow
  /*? if >=1.21.9 {*/ protected /*?} else {*/ /*private *//*?}*/ class_3675.class_306 boundKey;

  @Unique
  private boolean isAnalog() {
    IAnalogKeyboard analogKeyboard = (IAnalogKeyboard) class_310.method_1551().field_1774;
    return analogKeyboard.usesAnalog() && this.boundKey.method_1442() == class_3675.class_307.field_1668;
  }

  /**
   * @author lvoegl
   * @reason Computes isPressed based on analog value.
   */
  @Overwrite
  public boolean isPressed() {
    if (!isAnalog()) {
      return pressed;
    }
    return AnalogKeyStates.isPressed(this.boundKey);
  }

  @Intrinsic
  public float libanalog$pressedAmount() {
    if (!isAnalog()) {
      return pressed ? 1.0f : 0.0f;
    }
    return AnalogKeyStates.get(this.boundKey);
  }
}
