package net.verotek.libanalog.api;

import net.minecraft.class_3675;
import net.verotek.libanalog.LibAnalog;

import java.util.concurrent.ConcurrentHashMap;

public final class AnalogKeyStates {

  private static final ConcurrentHashMap<class_3675.class_306, FloatHolder> AMOUNTS = new ConcurrentHashMap<>(64);

  private AnalogKeyStates() {
  }

  public static void set(class_3675.class_306 key, float amount) {
    FloatHolder h = AMOUNTS.get(key);
    if (h == null) {
      h = AMOUNTS.computeIfAbsent(key, k -> new FloatHolder());
    }
    h.value = amount;
  }

  public static float get(class_3675.class_306 key) {
    FloatHolder h = AMOUNTS.get(key);
    return h != null ? h.value : 0.0f;
  }

  public static boolean isPressed(class_3675.class_306 key) {
    float amount = get(key);
    return amount >= LibAnalog.ACTUATION_POINT;
  }

  private static final class FloatHolder {
    volatile float value;
  }
}
