/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.player;

import java.util.Objects;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.server.TriviaHandler;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class AttributeUtils {
    public static final double DEFAULT_PLAYER_JUMP_HEIGHT = (double)0.42f;
    public static final double DEFAULT_PLAYER_SAFE_FALL_HEIGHT = 3.0;
    public static final double DEFAULT_PLAYER_MOVEMENT_SPEED = (double)0.1f;
    public static final double DEFAULT_PLAYER_STEP_HEIGHT = 0.6;

    public static void resetAttributesOnPlayerJoin(class_3222 player) {
        AttributeUtils.resetMaxPlayerHealthIfNecessary(player);
        if (!TriviaHandler.cursedMoonJumpPlayers.contains(player.method_5667())) {
            AttributeUtils.resetPlayerJumpHeight(player);
        }
        if (!SuperpowersWildcard.hasActivatedPower(player, Superpowers.WIND_CHARGE)) {
            AttributeUtils.resetSafeFallHeight(player);
        }
        AttributeUtils.resetMovementSpeed(player);
        AttributeUtils.resetStepHeight(player);
    }

    public static void resetMaxPlayerHealthIfNecessary(class_3222 player) {
        if (Main.modDisabled()) {
            AttributeUtils.resetMaxPlayerHealth(player);
            return;
        }
        if (Main.currentSeason.getSeason() == Seasons.SECRET_LIFE) {
            return;
        }
        double currentMaxHealth = AttributeUtils.getMaxPlayerHealth(player);
        if (currentMaxHealth == 13.0 && TriviaHandler.cursedHeartPlayers.contains(player.method_5667())) {
            return;
        }
        if (currentMaxHealth == 8.0 && Necromancy.isRessurectedPlayer(player)) {
            return;
        }
        AttributeUtils.resetMaxPlayerHealth(player);
    }

    public static void resetMaxPlayerHealth(class_3222 player) {
        double health = ((Integer)Main.seasonConfig.MAX_PLAYER_HEALTH.get(Main.seasonConfig)).intValue();
        AttributeUtils.setMaxPlayerHealth(player, health);
    }

    public static void resetPlayerJumpHeight(class_3222 player) {
        AttributeUtils.setPlayerJumpHeight(player, 0.42f);
    }

    public static void resetSafeFallHeight(class_3222 player) {
        AttributeUtils.setSafeFallHeight(player, 3.0);
    }

    public static void resetMovementSpeed(class_3222 player) {
        AttributeUtils.setMovementSpeed(player, 0.1f);
    }

    public static void resetStepHeight(class_3222 player) {
        AttributeUtils.setStepHeight(player, 0.6);
    }

    public static void setMaxPlayerHealth(class_3222 player, double value) {
        Objects.requireNonNull(player.method_5996(class_5134.field_23716)).method_6192(value);
    }

    public static void setPlayerJumpHeight(class_3222 player, double value) {
        Objects.requireNonNull(player.method_5996(class_5134.field_23728)).method_6192(value);
    }

    public static void setSafeFallHeight(class_3222 player, double value) {
        Objects.requireNonNull(player.method_5996(class_5134.field_49079)).method_6192(value);
    }

    public static void setScale(class_3222 player, double value) {
        Objects.requireNonNull(player.method_5996(class_5134.field_47760)).method_6192(value);
    }

    public static void setJumpStrength(class_3222 player, double value) {
        Objects.requireNonNull(player.method_5996(class_5134.field_23728)).method_6192(value);
    }

    public static void setMovementSpeed(class_3222 player, double value) {
        if (player == null) {
            return;
        }
        Objects.requireNonNull(player.method_5996(class_5134.field_23719)).method_6192(value);
    }

    public static void setStepHeight(class_3222 player, double value) {
        if (player == null) {
            return;
        }
        Objects.requireNonNull(player.method_5996(class_5134.field_47761)).method_6192(value);
    }

    public static double getMaxPlayerHealth(class_3222 player) {
        return player.method_45326(class_5134.field_23716);
    }

    public static double getMovementSpeed(class_3222 player) {
        return player.method_45326(class_5134.field_23719);
    }

    public static double getPlayerSize(class_3222 player) {
        return player.method_45326(class_5134.field_47760);
    }
}

