/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.extra;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.StringListPopupConfigEntry;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class StringListConfigEntry
extends StringListPopupConfigEntry<String> {
    private List<String> allowedValues;

    public StringListConfigEntry(String fieldName, String displayName, String description, String value, String defaultValue, List<String> allowedValues) {
        super(fieldName, displayName, description, value, defaultValue);
        this.allowedValues = allowedValues;
    }

    @Override
    protected void reloadEntries(List<String> items) {
        if (this.entries != null) {
            this.entries.clear();
        }
        ArrayList<String> newList = new ArrayList<String>();
        boolean errors = false;
        for (String entry : items) {
            if (entry.isEmpty()) continue;
            if (this.allowedValues != null && !this.allowedValues.contains(entry.toLowerCase())) {
                this.setError(TextUtils.formatString("Invalid entry: '{}'", entry));
                errors = true;
                continue;
            }
            newList.add(entry.toLowerCase());
        }
        this.entries = newList;
        if (!errors) {
            this.clearError();
        }
    }

    @Override
    protected void renderListEntry(class_332 context, String entry, int x, int y, int mouseX, int mouseY, float tickDelta) {
    }

    @Override
    public boolean shouldShowPopup() {
        return false;
    }

    @Override
    public boolean hasCustomErrors() {
        return true;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.STRING_LIST;
    }
}

