/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.aprilfools.simplelife;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.aprilfools.simplelife.SimpleLifeConfig;
import net.mat0u5.lifeseries.seasons.season.thirdlife.ThirdLife;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_7477;
import net.minecraft.class_9168;
import net.minecraft.class_9306;
import net.minecraft.server.MinecraftServer;

public class SimpleLife
extends ThirdLife {
    private Random rnd = new Random();
    private int checkCooldown = 0;

    @Override
    public Seasons getSeason() {
        return Seasons.SIMPLE_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        return new SimpleLifeConfig();
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        --this.checkCooldown;
        if (this.checkCooldown <= 0) {
            this.checkCooldown = 1200;
            class_3218 world = server.method_30002();
            if (world == null) {
                return;
            }
            int traderCount = 0;
            for (class_1297 entity : world.method_27909()) {
                if (!(entity instanceof class_3989)) continue;
                ++traderCount;
            }
            if (traderCount == 0) {
                this.checkCooldown = 1200;
            }
            if (traderCount == 1) {
                this.checkCooldown = 3600;
            }
            if (traderCount >= 2) {
                this.checkCooldown = 200;
            }
            if (traderCount >= 3) {
                return;
            }
            for (int i = 0; i < 5 && !this.trySpawnTrader(world); ++i) {
            }
        }
    }

    public boolean trySpawnTrader(class_3218 world) {
        class_3989 wanderingTraderEntity;
        class_3222 playerEntity = world.method_18779();
        if (playerEntity == null) {
            return true;
        }
        class_2338 blockPos = playerEntity.method_24515();
        class_4153 pointOfInterestStorage = world.method_19494();
        Optional optional = pointOfInterestStorage.method_19127(poiType -> poiType.method_40225(class_7477.field_39292), pos -> true, blockPos, 64, class_4153.class_4155.field_18489);
        class_2338 blockPos2 = optional.orElse(blockPos);
        class_2338 blockPos3 = this.getNearbySpawnPos((class_4538)world, blockPos2, 64);
        if (blockPos3 != null && this.doesNotSuffocateAt((class_1922)world, blockPos3) && (wanderingTraderEntity = (class_3989)class_1299.field_17713.method_47821(world, blockPos3, class_3730.field_16467)) != null) {
            for (int j = 0; j < 2; ++j) {
                this.spawnLlama(world, wanderingTraderEntity, 4);
            }
            wanderingTraderEntity.method_18013(12000);
            class_1916 offers = wanderingTraderEntity.method_8264();
            offers.clear();
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 5), Optional.empty(), class_1802.field_8620.method_7854(), 0, 999999, 0, 0.0f, 0));
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 40), Optional.empty(), class_1802.field_8705.method_7854(), 0, 999999, 0, 0.0f, 0));
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 40), Optional.empty(), class_1802.field_8187.method_7854(), 0, 999999, 0, 0.0f, 0));
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 1), Optional.empty(), class_1802.field_8858.method_7854(), 0, 999999, 0, 0.0f, 0));
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 1), Optional.empty(), class_1802.field_8110.method_7854(), 0, 999999, 0, 0.0f, 0));
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 5), Optional.empty(), class_1802.field_8695.method_7854(), 0, 999999, 0, 0.0f, 0));
            offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 1), Optional.empty(), class_1802.field_8725.method_7854(), 0, 999999, 0, 0.0f, 0));
            int rand = this.rnd.nextInt(2);
            if (rand == 0) {
                offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 32), Optional.empty(), class_1802.field_17535.method_7854(), 0, 999999, 0, 0.0f, 0));
            }
            if (rand == 1) {
                offers.add((Object)new class_1914(new class_9306((class_1935)class_1802.field_8831, 32), Optional.empty(), class_1802.field_17536.method_7854(), 0, 999999, 0, 0.0f, 0));
            }
            wanderingTraderEntity.method_8261(offers);
            return true;
        }
        return false;
    }

    private void spawnLlama(class_3218 world, class_3989 wanderingTrader, int range) {
        class_3986 traderLlamaEntity;
        class_2338 blockPos = this.getNearbySpawnPos((class_4538)world, wanderingTrader.method_24515(), range);
        if (blockPos != null && (traderLlamaEntity = (class_3986)class_1299.field_17714.method_47821(world, blockPos, class_3730.field_16467)) != null) {
            traderLlamaEntity.method_60964((class_1297)wanderingTrader, true);
        }
    }

    private class_2338 getNearbySpawnPos(class_4538 world, class_2338 pos, int range) {
        class_2338 blockPos = null;
        class_9168 spawnLocation = class_1317.method_6159((class_1299)class_1299.field_17713);
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.method_10263() + this.rnd.nextInt(range * 2) - range;
            class_2338 blockPos2 = new class_2338(j, l = world.method_8624(class_2902.class_2903.field_13202, j, k = pos.method_10260() + this.rnd.nextInt(range * 2) - range), k);
            if (!spawnLocation.isSpawnPositionOk(world, blockPos2, class_1299.field_17713)) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    private boolean doesNotSuffocateAt(class_1922 world, class_2338 pos) {
        class_2338 blockPos;
        Iterator var3 = class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(1, 2, 1)).iterator();
        do {
            if (var3.hasNext()) continue;
            return true;
        } while (world.method_8320(blockPos = (class_2338)var3.next()).method_26220(world, blockPos).method_1110());
        return false;
    }
}

