/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class UpdateChecker {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    public static boolean majorUpdateAvailable = false;
    public static boolean updateAvailable = false;
    public static String majorVersionName;
    public static String versionName;
    public static String versionDescription;
    public static String changelogLink;
    public static int version;
    public static final boolean TEST_UPDATE_FAKE = false;
    public static final boolean TEST_UPDATE_LAST = false;

    public static void checkForMajorUpdates() {
        executor.submit(() -> {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URI("https://api.github.com/repos/Mat0u5/LifeSeries/releases/latest").toURL().openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() == 200) {
                    int updateVersionNumber;
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    String name = json.get("tag_name").getAsString();
                    int currentVersionNumber = VersionControl.getModVersionInt("1.4.1");
                    if (currentVersionNumber >= (updateVersionNumber = VersionControl.getModVersionInt(name))) {
                    } else {
                        Main.LOGGER.info("New major version found: " + name);
                        updateAvailable = true;
                        majorUpdateAvailable = true;
                        versionName = name;
                        majorVersionName = name;
                        version = updateVersionNumber;
                        versionDescription = UpdateChecker.formatDescription(json.get("body").getAsString());
                    }
                } else {
                    Main.LOGGER.error("Failed to fetch update info: " + connection.getResponseCode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Main.LOGGER.error("Error while checking for updates: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                UpdateChecker.checkForMinorUpdates();
            }
        });
    }

    public static void checkForMinorUpdates() {
        executor.submit(() -> {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URI("https://api.github.com/repos/Mat0u5/LifeSeries/releases").toURL().openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() == 200) {
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonArray jsonList = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                    for (JsonElement jsonElement : jsonList.asList()) {
                        JsonObject json = jsonElement.getAsJsonObject();
                        String name = json.get("tag_name").getAsString();
                        boolean draft = json.get("draft").getAsBoolean();
                        boolean prerelease = json.get("prerelease").getAsBoolean();
                        if (draft || prerelease) continue;
                        try {
                            int currentVersionNumber = VersionControl.getModVersionInt("1.4.1");
                            int updateVersionNumber = VersionControl.getModVersionInt(name);
                            if (version >= updateVersionNumber || currentVersionNumber >= updateVersionNumber) continue;
                            Main.LOGGER.info("New minor version found: " + name);
                            updateAvailable = true;
                            versionName = name;
                            version = updateVersionNumber;
                            if (!majorUpdateAvailable) {
                                majorVersionName = versionName;
                            }
                            if (majorUpdateAvailable) continue;
                            versionDescription = UpdateChecker.formatDescription(json.get("body").getAsString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Main.LOGGER.error(TextUtils.formatString("Error while parsing version number for update: {} - {}", name, e.getMessage()));
                        }
                    }
                } else {
                    Main.LOGGER.error("Failed to fetch update info: " + connection.getResponseCode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Main.LOGGER.error("Error while checking for updates: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public static String getChangelogLink() {
        if (changelogLink != null) {
            return changelogLink;
        }
        if (majorVersionName != null) {
            return "https://github.com/Mat0u5/LifeSeries/blob/main/docs/changelogs/" + majorVersionName + ".md";
        }
        return "https://github.com/Mat0u5/LifeSeries/blob/main/docs/changelogs/" + versionName + ".md";
    }

    public static String formatDescription(String rawDesctiption) {
        if (rawDesctiption.contains("~~")) {
            String[] split = rawDesctiption.split("~~");
            String newDesctiption = split[0];
            if (!newDesctiption.isEmpty()) {
                rawDesctiption = newDesctiption;
            }
            if (split.length >= 2) {
                for (int i = 1; i < split.length; ++i) {
                    try {
                        String line = split[i].trim();
                        if (line.startsWith("changelogLink=")) {
                            changelogLink = line.replace("changelogLink=", "");
                        }
                        if (line.startsWith("versionName=")) {
                            versionName = line.replace("versionName=", "");
                        }
                        if (line.startsWith("majorVersionName=")) {
                            majorVersionName = line.replace("majorVersionName=", "");
                        }
                        if (line.startsWith("versionDescription=")) {
                            rawDesctiption = line.replace("versionDescription=", "");
                        }
                        if (!line.startsWith("version=")) continue;
                        version = Integer.parseInt(line.replace("version=", ""));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return rawDesctiption;
    }

    public static void onPlayerJoin(class_3222 player) {
        if (!updateAvailable || versionName == null) {
            return;
        }
        if (!VersionControl.isDevVersion()) {
            class_5250 discordText = TextUtils.format("\u00a77Click {}\u00a77 to join the mod development discord if you have any questions, issues, requests, or if you just want to hang out :)\"", TextUtils.openURLText("https://discord.gg/QWJxfb4zQZ"));
            class_5250 updateText = TextUtils.formatLoosely("A new version of the Life Series Mod is available ({}) \u00a7nserver-side\u00a7f. \n", versionName).method_27694(style -> style.method_10949(TextUtils.showTextHoverEvent((class_2561)TextUtils.formatLoosely("\u00a77\u00a7nUpdate Description:\u00a7r\n\n{}", versionDescription)))).method_10852(TextUtils.clickableText("Click to download on Modrinth", TextUtils.openURLClickEvent("https://modrinth.com/mod/life-series")));
            if (PermissionManager.isAdmin(player)) {
                player.method_64398((class_2561)updateText);
                player.method_64398((class_2561)discordText);
            }
        } else {
            class_5250 updateText = class_2561.method_43470((String)"\u00a7c[Life Series] You are playing on a developer version, there are probably some bugs, and it's possible that some features don't work.\n").method_10852(TextUtils.clickableText("Download full releases on Modrinth", TextUtils.openURLClickEvent("https://modrinth.com/mod/life-series")));
            player.method_64398((class_2561)updateText);
        }
    }

    public static void shutdownExecutor() {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        changelogLink = null;
    }
}

