/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.world;

import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1642;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class WorldUtils {
    public static int findTopSafeY(class_1937 world, class_243 pos) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339(pos.method_10216(), (double)world.method_31605(), pos.method_10215());
        while (mutablePos.method_10264() >= world.method_31607()) {
            if (WorldUtils.isSafeSpot(world, mutablePos)) {
                return mutablePos.method_10264();
            }
            mutablePos.method_10100(0, -1, 0);
        }
        return (int)pos.method_10214();
    }

    public static boolean isSafeSpot(class_1937 world, class_2338.class_2339 pos) {
        boolean isSolidBlockBelow = world.method_8320(pos.method_10074()).method_26168((class_1922)world, pos.method_10074(), (class_1297)new class_1642(world));
        boolean isNonCollisionAbove = world.method_8320((class_2338)pos).method_26220((class_1922)world, (class_2338)pos).method_1110() && world.method_8320(pos.method_10084()).method_26220((class_1922)world, pos.method_10084()).method_1110();
        return isSolidBlockBelow && isNonCollisionAbove;
    }

    public static void summonHarmlessLightning(class_3222 player) {
        WorldUtils.summonHarmlessLightning(PlayerUtils.getServerWorld(player), WorldUtils.getEntityPos((class_1297)player));
    }

    public static void summonHarmlessLightning(class_3218 world, class_243 pos) {
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
        lightning.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        lightning.method_29498(true);
        world.method_8649((class_1297)lightning);
    }

    public static class_2338 getCloseBlockPos(class_3218 world, class_2338 targetPos, double distanceFromTarget, int height, boolean bottomSupport) {
        for (int attempts = 0; attempts < 20; ++attempts) {
            class_243 offset = new class_243(world.field_9229.method_43058() * 2.0 - 1.0, 0.0, world.field_9229.method_43058() * 2.0 - 1.0).method_1029().method_1021(distanceFromTarget);
            class_2338 pos = targetPos.method_10069((int)offset.method_10216(), 0, (int)offset.method_10215());
            class_2338 validPos = WorldUtils.findNearestAirBlock(pos, (class_1937)world, height, bottomSupport);
            if (validPos == null) continue;
            return validPos;
        }
        return targetPos;
    }

    private static class_2338 findNearestAirBlock(class_2338 pos, class_1937 world, int height, boolean bottomSupport) {
        for (int yOffset = 5; yOffset >= -5; --yOffset) {
            class_2338 bottomPos;
            class_2338 newPos = pos.method_10086(yOffset);
            if (bottomSupport && !world.method_8320(bottomPos = newPos.method_10074()).method_26206((class_1922)world, bottomPos, class_2350.field_11036)) continue;
            boolean allAir = true;
            for (int i = 0; i < height; ++i) {
                class_2338 airTest = newPos.method_10086(i);
                if (world.method_8320(airTest).method_26215()) continue;
                allAir = false;
            }
            if (!allAir) continue;
            return newPos;
        }
        return null;
    }

    public static class_1937 getEntityWorld(class_1297 entity) {
        return entity.method_37908();
    }

    public static class_243 getEntityPos(class_1297 entity) {
        return entity.method_19538();
    }
}

