/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.TriviaHandler;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLifeConfig;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Hunger;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.MobSwap;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.ToggleableSuperpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.AnimalDisguise;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.CreakingPower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Flight;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Invisibility;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.PlayerDisguise;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.SuperPunch;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Superspeed;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.TripleJump;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.WindCharge;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_7260;
import net.minecraft.class_8111;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class WildLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /wildcard, /superpower, /snail";
    public static final String COMMANDS_TEXT = "/claimkill, /lives, /snail";
    public static boolean KILLING_DARK_GREENS_GAINS_LIVES = true;
    public static boolean BROADCAST_LIFE_GAIN = true;

    @Override
    public Seasons getSeason() {
        return Seasons.WILD_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        Snails.loadConfig();
        return new WildLifeConfig();
    }

    @Override
    public String getAdminCommands() {
        return COMMANDS_ADMIN_TEXT;
    }

    @Override
    public String getNonAdminCommands() {
        return COMMANDS_TEXT;
    }

    @Override
    public void initialize() {
        super.initialize();
        Snails.loadConfig();
        Snails.loadSnailNames();
        TriviaHandler.initializeItemSpawner();
    }

    @Override
    public void onPlayerJoin(class_3222 player) {
        super.onPlayerJoin(player);
        WildcardManager.onPlayerJoin(player);
    }

    @Override
    public void onPlayerFinishJoining(class_3222 player) {
        super.onPlayerFinishJoining(player);
        WildcardManager.onPlayerFinishJoining(player);
    }

    @Override
    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim, boolean allowSelfDefense) {
        if (Necromancy.isRessurectedPlayer(victim) || Necromancy.isRessurectedPlayer(attacker)) {
            return true;
        }
        if (attacker.ls$isOnSpecificLives(2, false) && victim.ls$isOnAtLeastLives(3, false)) {
            return true;
        }
        return super.isAllowedToAttack(attacker, victim, allowSelfDefense);
    }

    @Override
    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        boolean wasAllowedToAttack = this.isAllowedToAttack(killer, victim, false);
        boolean wasBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        super.onPlayerKilledByPlayer(victim, killer);
        if (victim.ls$isOnAtLeastLives(4, false) && wasAllowedToAttack && !wasBoogeyCure) {
            ConfigManager configManager;
            if (Necromancy.isRessurectedPlayer(killer) && (configManager = Main.seasonConfig) instanceof WildLifeConfig) {
                WildLifeConfig config = (WildLifeConfig)configManager;
                if (WildLifeConfig.WILDCARD_SUPERPOWERS_ZOMBIES_REVIVE_BY_KILLING_DARK_GREEN.get(config).booleanValue()) {
                    int lives;
                    Integer currentLives = killer.ls$getLives();
                    if (currentLives == null) {
                        currentLives = 0;
                    }
                    if ((lives = currentLives + 1) <= 0) {
                        ScoreboardUtils.setScore(class_9015.method_55422((String)killer.method_5820()), "Lives", lives);
                    } else {
                        this.broadcastLifeGain(killer);
                        killer.ls$addLife();
                    }
                }
            } else if (KILLING_DARK_GREENS_GAINS_LIVES) {
                this.broadcastLifeGain(killer);
                killer.ls$addLife();
            }
        }
    }

    @Override
    public void onClaimKill(class_3222 killer, class_3222 victim) {
        super.onClaimKill(killer, victim);
        if (victim.ls$isOnAtLeastLives(4, false) && KILLING_DARK_GREENS_GAINS_LIVES) {
            this.broadcastLifeGain(killer);
            killer.ls$addLife();
        }
    }

    public void broadcastLifeGain(class_3222 player) {
        if (BROADCAST_LIFE_GAIN) {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 gained a life for killing a \u00a72dark green\u00a77 player.", player));
        }
    }

    @Override
    public void tickSessionOn(MinecraftServer server) {
        super.tickSessionOn(server);
        WildcardManager.tickSessionOn();
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        WildcardManager.tick();
    }

    @Override
    public boolean sessionStart() {
        super.sessionStart();
        WildcardManager.onSessionStart();
        return true;
    }

    @Override
    public void addSessionActions() {
        super.addSessionActions();
        WildcardManager.addSessionActions();
    }

    @Override
    public void sessionEnd() {
        WildcardManager.onSessionEnd();
        super.sessionEnd();
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof WildLifeConfig)) {
            return;
        }
        WildLifeConfig config = (WildLifeConfig)configManager;
        Hunger.SWITCH_DELAY = 20 * WildLifeConfig.WILDCARD_HUNGER_RANDOMIZE_INTERVAL.get(config);
        Hunger.HUNGER_EFFECT_LEVEL = WildLifeConfig.WILDCARD_HUNGER_EFFECT_LEVEL.get(config);
        Hunger.NUTRITION_CHANCE = WildLifeConfig.WILDCARD_HUNGER_NUTRITION_CHANCE.get(config);
        Hunger.SATURATION_CHANCE = WildLifeConfig.WILDCARD_HUNGER_SATURATION_CHANCE.get(config);
        Hunger.EFFECT_CHANCE = WildLifeConfig.WILDCARD_HUNGER_EFFECT_CHANCE.get(config);
        Hunger.AVG_EFFECT_DURATION = WildLifeConfig.WILDCARD_HUNGER_AVG_EFFECT_DURATION.get(config);
        Hunger.SOUND_CHANCE = WildLifeConfig.WILDCARD_HUNGER_SOUND_CHANCE.get(config);
        SizeShifting.MIN_SIZE = WildLifeConfig.WILDCARD_SIZESHIFTING_MIN_SIZE.get(config);
        SizeShifting.MAX_SIZE = WildLifeConfig.WILDCARD_SIZESHIFTING_MAX_SIZE.get(config);
        SizeShifting.SIZE_CHANGE_MULTIPLIER = WildLifeConfig.WILDCARD_SIZESHIFTING_SIZE_CHANGE_MULTIPLIER.get(config);
        SizeShifting.FIX_SIZECHANGING_BUGS = WildLifeConfig.WILDCARD_SIZESHIFTING_FIX_BUGS.get(config);
        Snail.GLOBAL_SPEED_MULTIPLIER = WildLifeConfig.WILDCARD_SNAILS_SPEED_MULTIPLIER.get(config);
        Snail.SHOULD_DROWN_PLAYER = WildLifeConfig.WILDCARD_SNAILS_DROWN_PLAYERS.get(config);
        Snail.ALLOW_POTION_EFFECTS = WildLifeConfig.WILDCARD_SNAILS_EFFECTS.get(config);
        TimeDilation.MIN_TICK_RATE = (float)(20.0 * WildLifeConfig.WILDCARD_TIMEDILATION_MIN_SPEED.get(config));
        TimeDilation.MAX_TICK_RATE = (float)(20.0 * WildLifeConfig.WILDCARD_TIMEDILATION_MAX_SPEED.get(config));
        TimeDilation.MIN_PLAYER_MSPT = (float)(50.0 / WildLifeConfig.WILDCARD_TIMEDILATION_PLAYER_MAX_SPEED.get(config));
        MobSwap.MAX_DELAY = 20 * WildLifeConfig.WILDCARD_MOBSWAP_START_SPAWN_DELAY.get(config);
        MobSwap.MIN_DELAY = 20 * WildLifeConfig.WILDCARD_MOBSWAP_END_SPAWN_DELAY.get(config);
        MobSwap.SPAWN_MOBS = WildLifeConfig.WILDCARD_MOBSWAP_SPAWN_MOBS.get(config);
        MobSwap.BOSS_CHANCE_MULTIPLIER = WildLifeConfig.WILDCARD_MOBSWAP_BOSS_CHANCE_MULTIPLIER.get(config);
        TriviaBot.CAN_START_RIDING = WildLifeConfig.WILDCARD_TRIVIA_BOTS_CAN_ENTER_BOATS.get(config);
        TriviaWildcard.TRIVIA_BOTS_PER_PLAYER = WildLifeConfig.WILDCARD_TRIVIA_BOTS_PER_PLAYER.get(config);
        TriviaBot.EASY_TIME = WildLifeConfig.WILDCARD_TRIVIA_SECONDS_EASY.get(config);
        TriviaBot.NORMAL_TIME = WildLifeConfig.WILDCARD_TRIVIA_SECONDS_NORMAL.get(config);
        TriviaBot.HARD_TIME = WildLifeConfig.WILDCARD_TRIVIA_SECONDS_HARD.get(config);
        WindCharge.MAX_MACE_DAMAGE = WildLifeConfig.WILDCARD_SUPERPOWERS_WINDCHARGE_MAX_MACE_DAMAGE.get(config);
        Superspeed.STEP_UP = WildLifeConfig.WILDCARD_SUPERPOWERS_SUPERSPEED_STEP.get(config);
        WildcardManager.ACTIVATE_WILDCARD_MINUTE = WildLifeConfig.ACTIVATE_WILDCARD_MINUTE.get(config);
        KILLING_DARK_GREENS_GAINS_LIVES = WildLifeConfig.KILLING_DARK_GREENS_GAINS_LIVES.get(config);
        BROADCAST_LIFE_GAIN = WildLifeConfig.BROADCAST_LIFE_GAIN.get(config);
        SuperpowersWildcard.WILDCARD_SUPERPOWERS_DISABLE_INTRO_THEME = WildLifeConfig.WILDCARD_SUPERPOWERS_DISABLE_INTRO_THEME.get(config);
        SuperpowersWildcard.setBlacklist(WildLifeConfig.WILDCARD_SUPERPOWERS_POWER_BLACKLIST.get(config));
        Callback.setBlacklist(WildLifeConfig.WILDCARD_CALLBACK_WILDCARDS_BLACKLIST.get(config));
        Callback.TURN_OFF = WildLifeConfig.WILDCARD_CALLBACK_TURN_OFF.get(config);
        Callback.NERFED_WILDCARDS = WildLifeConfig.WILDCARD_CALLBACK_NERFED_WILDCARDS.get(config);
        AnimalDisguise.SHOW_ARMOR = WildLifeConfig.WILDCARD_SUPERPOWERS_ANIMALDISGUISE_ARMOR.get(config);
        AnimalDisguise.SHOW_HANDS = WildLifeConfig.WILDCARD_SUPERPOWERS_ANIMALDISGUISE_HANDS.get(config);
        Snails.loadConfig();
        Snails.loadSnailNames();
        Snails.reloadSnailNames();
        Snails.reloadSnailSkins();
        TriviaWildcard.reload();
    }

    @Override
    public void modifyEntityDrops(class_1309 entity, class_1282 damageSource) {
        super.modifyEntityDrops(entity, damageSource);
        if (damageSource.method_5526() instanceof class_1657 && (entity instanceof class_7260 || entity instanceof class_1528 || entity instanceof class_1510)) {
            entity.method_5775(class_1802.field_8288.method_7854());
        }
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.CREAKING) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof CreakingPower) {
            CreakingPower creakingPower = (CreakingPower)superpower;
            creakingPower.deactivate();
            this.reloadPlayerTeam(player);
        }
        super.onPlayerDeath(player, source);
        TriviaHandler.cursedGigantificationPlayers.remove(player.method_5667());
        TriviaHandler.cursedHeartPlayers.remove(player.method_5667());
        AttributeUtils.resetMaxPlayerHealthIfNecessary(player);
        TriviaHandler.cursedMoonJumpPlayers.remove(player.method_5667());
        AttributeUtils.resetPlayerJumpHeight(player);
        Superpower power = SuperpowersWildcard.getSuperpowerInstance(player);
        if (power != null) {
            power.deactivate();
        }
    }

    @Override
    public void onPlayerDisconnect(class_3222 player) {
        super.onPlayerDisconnect(player);
        Superpower power = SuperpowersWildcard.getSuperpowerInstance(player);
        if (power != null) {
            power.deactivate();
        }
    }

    @Override
    public String getTeamForPlayer(class_3222 player) {
        String team = super.getTeamForPlayer(player);
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.CREAKING)) {
            return "creaking_" + player.method_5820();
        }
        return team;
    }

    @Override
    public void onPlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfo ci) {
        ToggleableSuperpower power;
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.PLAYER_DISGUISE) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof PlayerDisguise) {
            power = (PlayerDisguise)superpower;
            ((PlayerDisguise)power).onTakeDamage();
        }
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.ANIMAL_DISGUISE) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof AnimalDisguise) {
            power = (AnimalDisguise)superpower;
            ((AnimalDisguise)power).onTakeDamage();
        }
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.INVISIBILITY) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Invisibility) {
            power = (Invisibility)superpower;
            ((Invisibility)power).onTakeDamage();
        }
    }

    @Override
    public void onPrePlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42355) || source.method_49708(class_8111.field_42346)) {
            Superpower power;
            Superpower superpower;
            if (SuperpowersWildcard.hasActivePower(player, Superpowers.FLIGHT) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Flight) {
                power = (Flight)superpower;
                if (power.isLaunchedUp) {
                    if (!source.method_49708(class_8111.field_42346)) {
                        power.isLaunchedUp = false;
                    }
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.TRIPLE_JUMP) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof TripleJump) {
                power = (TripleJump)superpower;
                if (((TripleJump)power).isInAir) {
                    ((TripleJump)power).isInAir = false;
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.SUPER_PUNCH) && player.method_5765() && player.method_5854() instanceof class_3222) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Override
    public void onRightClickEntity(class_3222 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.SUPER_PUNCH) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof SuperPunch) {
            SuperPunch power = (SuperPunch)superpower;
            power.tryRideEntity(entity);
        }
    }

    @Override
    public void onAttackEntity(class_3222 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        Superpower superpower;
        if (SuperpowersWildcard.hasActivatedPower(player, Superpowers.INVISIBILITY) && (superpower = SuperpowersWildcard.getSuperpowerInstance(player)) instanceof Invisibility) {
            Invisibility power = (Invisibility)superpower;
            power.onAttack();
        }
    }

    @Override
    public void onUpdatedInventory(class_3222 player) {
        super.onUpdatedInventory(player);
        Hunger.updateInventory(player);
    }
}

