/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.interfaces.IPopup;
import net.mat0u5.lifeseries.gui.config.entries.interfaces.ITextFieldAddonPopup;
import net.mat0u5.lifeseries.gui.config.entries.main.StringConfigEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;

@Environment(value=EnvType.CLIENT)
public abstract class StringListPopupConfigEntry<T>
extends StringConfigEntry
implements ITextFieldAddonPopup {
    private final int MAX_LINE_ENTRIES;
    private final int ENTRY_SIZE;
    private final int ENTRY_PADDING;
    protected List<T> entries = null;
    private String lastEntryStr = "";

    public StringListPopupConfigEntry(String fieldName, String displayName, String description, String value, String defaultValue) {
        this(fieldName, displayName, description, value, defaultValue, 10, 16, 2);
    }

    public StringListPopupConfigEntry(String fieldName, String displayName, String description, String value, String defaultValue, int maxLineEntries, int entrySize, int entryPadding) {
        super(fieldName, displayName, description, value, defaultValue);
        this.MAX_LINE_ENTRIES = maxLineEntries;
        this.ENTRY_SIZE = entrySize;
        this.ENTRY_PADDING = entryPadding;
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.renderEntry(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
        this.renderPopup(context, mouseX, mouseY, tickDelta);
    }

    @Override
    protected void onTextChanged(String text) {
        super.onTextChanged(text);
        this.reloadEntriesRaw(text);
    }

    protected void reloadEntriesRaw(String text) {
        if (this.lastEntryStr != null && this.lastEntryStr.equalsIgnoreCase(text)) {
            return;
        }
        String raw = text;
        raw = raw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "");
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(raw.split(",")));
        this.reloadEntries(items);
        this.lastEntryStr = text;
    }

    @Override
    public class_342 getTextField() {
        return this.textField;
    }

    @Override
    public class_327 getTextRenderer() {
        return this.textRenderer;
    }

    @Override
    public class_2561 getPopupText() {
        if (this.entries == null || this.entries.isEmpty()) {
            return class_2561.method_43470((String)"Empty").method_27692(class_124.field_1080);
        }
        return class_2561.method_43473();
    }

    @Override
    public boolean shouldShowPopup() {
        if (this.textField == null) {
            return false;
        }
        if (this.isFocused()) {
            return true;
        }
        if (this.isHovered) {
            ConfigEntry entry = this.screen.getFocusedEntry();
            if (!(entry instanceof IPopup)) {
                return true;
            }
            IPopup popup = (IPopup)((Object)entry);
            if (popup == this) {
                return true;
            }
            return !popup.shouldShowPopup();
        }
        return false;
    }

    @Override
    public int getPopupWidth() {
        if (this.entries == null || this.entries.isEmpty()) {
            return ITextFieldAddonPopup.super.getPopupWidth();
        }
        return Math.min(this.entries.size(), this.MAX_LINE_ENTRIES) * (this.ENTRY_SIZE + this.ENTRY_PADDING) + this.ENTRY_PADDING;
    }

    @Override
    public int getPopupHeight() {
        if (this.entries == null || this.entries.isEmpty()) {
            return ITextFieldAddonPopup.super.getPopupHeight();
        }
        return (Math.max(this.entries.size() - 1, 0) / this.MAX_LINE_ENTRIES + 1) * (this.ENTRY_SIZE + this.ENTRY_PADDING) + this.ENTRY_PADDING;
    }

    @Override
    public void renderContent(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta) {
        if (this.entries == null || this.entries.isEmpty()) {
            ITextFieldAddonPopup.super.renderContent(context, x, y, width, height, mouseX, mouseY, tickDelta);
            return;
        }
        int startingItemX = x + this.ENTRY_PADDING;
        int startingItemY = y + this.ENTRY_PADDING;
        int itemX = startingItemX;
        int itemY = startingItemY;
        int currentLine = 0;
        for (T entry : this.entries) {
            if (currentLine >= this.MAX_LINE_ENTRIES) {
                itemX = startingItemX;
                itemY += this.ENTRY_SIZE + this.ENTRY_PADDING;
                currentLine = 0;
            }
            this.renderListEntry(context, entry, itemX, itemY, mouseX, mouseY, tickDelta);
            itemX += this.ENTRY_SIZE + this.ENTRY_PADDING;
            ++currentLine;
        }
    }

    protected abstract void reloadEntries(List<String> var1);

    protected abstract void renderListEntry(class_332 var1, T var2, int var3, int var4, int var5, int var6, float var7);
}

