/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class SizeShifting
extends Wildcard {
    public static double MIN_SIZE_HARD = 0.06;
    public static double MAX_SIZE_HARD = 16.0;
    public static double MIN_SIZE = 0.25;
    public static double MAX_SIZE = 3.0;
    public static double MIN_SIZE_NERFED = 0.6;
    public static double MAX_SIZE_NERFED = 1.5;
    public static double SIZE_CHANGE_MULTIPLIER = 1.0;
    public static double SIZE_CHANGE_STEP = 0.0015;
    public static boolean FIX_SIZECHANGING_BUGS = false;

    @Override
    public Wildcards getType() {
        return Wildcards.SIZE_SHIFTING;
    }

    @Override
    public void tick() {
        for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
            if (TriviaBot.cursedGigantificationPlayers.contains(player.method_5667()) || player.method_7325() || !player.method_5715()) continue;
            SizeShifting.addPlayerSize(player, -SIZE_CHANGE_STEP * SIZE_CHANGE_MULTIPLIER);
        }
    }

    public static void onHoldingJump(class_3222 player) {
        if (TriviaBot.cursedGigantificationPlayers.contains(player.method_5667())) {
            return;
        }
        if (player.method_7325()) {
            return;
        }
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        SizeShifting.addPlayerSize(player, SIZE_CHANGE_STEP * SIZE_CHANGE_MULTIPLIER);
    }

    public static double getPlayerSize(class_3222 player) {
        return AttributeUtils.getPlayerSize(player);
    }

    public static void addPlayerSize(class_3222 player, double amount) {
        SizeShifting.setPlayerSize(player, SizeShifting.getPlayerSize(player) + amount);
    }

    public static void setPlayerSize(class_3222 player, double size) {
        if (size < MIN_SIZE_HARD) {
            size = MIN_SIZE_HARD;
        }
        if (size > MAX_SIZE_HARD) {
            size = MAX_SIZE_HARD;
        }
        if (size < MIN_SIZE) {
            size = MIN_SIZE;
        }
        if (size > MAX_SIZE) {
            size = MAX_SIZE;
        }
        if (WildcardManager.isActiveWildcard(Wildcards.CALLBACK)) {
            if (size < MIN_SIZE_NERFED) {
                size = MIN_SIZE_NERFED;
            }
            if (size > MAX_SIZE_NERFED) {
                size = MAX_SIZE_NERFED;
            }
        }
        if (MorphManager.getOrCreateComponent((class_1657)player).isMorphed()) {
            return;
        }
        AttributeUtils.setScale(player, size);
    }

    public static void setPlayerSizeUnchecked(class_3222 player, double size) {
        AttributeUtils.setScale(player, size);
    }

    public static void resetSizesTick(boolean isActive) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            boolean isDeadSpectator;
            boolean isWatcher = WatcherManager.isWatcher((class_1657)player);
            boolean bl = isDeadSpectator = player.method_7325() && Main.livesManager.isDead(player);
            if (isActive && !isDeadSpectator && !isWatcher) continue;
            double size = SizeShifting.getPlayerSize(player);
            if (TriviaBot.cursedGigantificationPlayers.contains(player.method_5667()) && !isWatcher && !isDeadSpectator || size == 1.0) continue;
            if (size < 0.98) {
                SizeShifting.addPlayerSize(player, 0.01);
                continue;
            }
            if (size > 1.02) {
                SizeShifting.addPlayerSize(player, -0.01);
                continue;
            }
            SizeShifting.setPlayerSize(player, 1.0);
        }
    }
}

