/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.secretsociety;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.secretsociety.SocietyMember;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class SecretSociety {
    public boolean SOCIETY_ENABLED = false;
    public double START_TIME = 5.0;
    public int MEMBER_COUNT = 3;
    public List<String> FORCE_MEMBERS = new ArrayList<String>();
    public List<String> IGNORE_MEMBERS = new ArrayList<String>();
    public List<String> POSSIBLE_WORDS = new ArrayList<String>(List.of("Hammer", "Magnet", "Throne", "Gravity", "Puzzle", "Spiral", "Pivot", "Flare"));
    public int KILL_COUNT = 2;
    public int PUNISHMENT_LIVES = -2;
    public boolean SOUND_ONLY_MEMBERS = false;
    public static final int INITIATE_MESSAGE_DELAYS = 300;
    public List<SocietyMember> members = new ArrayList<SocietyMember>();
    public boolean societyStarted = false;
    public boolean societyEnded = false;
    public long ticks = 0L;
    public String secretWord = "";
    public Random rnd = new Random();

    public void onReload() {
        this.SOCIETY_ENABLED = (Boolean)Main.seasonConfig.SECRET_SOCIETY.get(Main.seasonConfig);
        if (!this.SOCIETY_ENABLED) {
            this.onDisabledSociety();
        }
        this.MEMBER_COUNT = (Integer)Main.seasonConfig.SECRET_SOCIETY_MEMBER_AMOUNT.get(Main.seasonConfig);
        this.START_TIME = (Double)Main.seasonConfig.SECRET_SOCIETY_START_TIME.get(Main.seasonConfig);
        this.KILL_COUNT = (Integer)Main.seasonConfig.SECRET_SOCIETY_KILLS_REQUIRED.get(Main.seasonConfig);
        this.PUNISHMENT_LIVES = (Integer)Main.seasonConfig.SECRET_SOCIETY_PUNISHMENT_LIVES.get(Main.seasonConfig);
        this.SOUND_ONLY_MEMBERS = (Boolean)Main.seasonConfig.SECRET_SOCIETY_SOUND_ONLY_MEMBERS.get(Main.seasonConfig);
        this.FORCE_MEMBERS.clear();
        this.IGNORE_MEMBERS.clear();
        this.POSSIBLE_WORDS.clear();
        for (String name : ((String)Main.seasonConfig.SECRET_SOCIETY_FORCE.get(Main.seasonConfig)).replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim().split(",")) {
            if (name.isEmpty()) continue;
            this.FORCE_MEMBERS.add(name.toLowerCase());
        }
        for (String name : ((String)Main.seasonConfig.SECRET_SOCIETY_IGNORE.get(Main.seasonConfig)).replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim().split(",")) {
            if (name.isEmpty()) continue;
            this.IGNORE_MEMBERS.add(name.toLowerCase());
        }
        for (String name : ((String)Main.seasonConfig.SECRET_SOCIETY_WORDS.get(Main.seasonConfig)).replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim().split(",")) {
            if (name.isEmpty()) continue;
            this.POSSIBLE_WORDS.add(name);
        }
    }

    public void addSessionActions() {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        Main.currentSession.addSessionAction(new SessionAction(OtherUtils.minutesToTicks(this.START_TIME), TextUtils.formatString("\u00a77Begin Secret Society \u00a7f[{}]", OtherUtils.formatTime(OtherUtils.minutesToTicks(this.START_TIME))), "Begin Secret Society"){

            @Override
            public void trigger() {
                if (!SecretSociety.this.SOCIETY_ENABLED) {
                    return;
                }
                SecretSociety.this.startSociety(null);
            }
        });
    }

    public void startSociety(String word) {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        if (Main.server == null) {
            return;
        }
        if (word == null && !this.POSSIBLE_WORDS.isEmpty()) {
            word = this.POSSIBLE_WORDS.get(this.rnd.nextInt(this.POSSIBLE_WORDS.size()));
        }
        if (word != null) {
            this.secretWord = word;
        }
        this.societyStarted = true;
        this.societyEnded = false;
        SessionTranscript.societyStarted();
        this.ticks = 0L;
        this.resetMembers();
        this.chooseMembers(PlayerUtils.getAllFunctioningPlayers());
    }

    public void forceEndSociety() {
        this.resetMembers();
        this.societyStarted = false;
        this.societyEnded = true;
    }

    @Nullable
    public SocietyMember getMember(class_3222 player) {
        for (SocietyMember member : this.members) {
            if (member.uuid != player.method_5667()) continue;
            return member;
        }
        return null;
    }

    public boolean isMember(class_3222 player) {
        SocietyMember member = this.getMember(player);
        return member != null;
    }

    public void chooseMembers(List<class_3222> allowedPlayers) {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        Collections.shuffle(allowedPlayers);
        List<class_3222> memberPlayers = this.getRandomMembers(allowedPlayers);
        ArrayList<class_3222> nonMemberPlayers = new ArrayList<class_3222>();
        for (class_3222 player : allowedPlayers) {
            if (memberPlayers.contains(player)) continue;
            nonMemberPlayers.add(player);
        }
        memberPlayers.forEach(this::addMember);
        SessionTranscript.societyMembersChosen(memberPlayers);
        if (!this.SOUND_ONLY_MEMBERS) {
            PlayerUtils.playSoundToPlayers(nonMemberPlayers, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_task")));
        }
        PlayerUtils.playSoundToPlayers(memberPlayers, class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_task")));
        PlayerUtils.sendTitleToPlayers(memberPlayers, class_2561.method_30163((String)"\u00a7cThe Society calls"), 0, 30, 0);
        TaskScheduler.scheduleTask(15, () -> PlayerUtils.sendTitleToPlayers(memberPlayers, class_2561.method_30163((String)"\u00a7cThe Society calls."), 0, 30, 0));
        TaskScheduler.scheduleTask(30, () -> PlayerUtils.sendTitleToPlayers(memberPlayers, class_2561.method_30163((String)"\u00a7cThe Society calls.."), 0, 30, 0));
        TaskScheduler.scheduleTask(45, () -> PlayerUtils.sendTitleToPlayers(memberPlayers, class_2561.method_30163((String)"\u00a7cThe Society calls..."), 0, 45, 30));
        TaskScheduler.scheduleTask(115, () -> PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7cTake yourself somewhere quiet"), 20, 60, 20));
    }

    public List<class_3222> getRandomMembers(List<class_3222> allowedPlayers) {
        ArrayList<class_3222> memberPlayers = new ArrayList<class_3222>();
        int remainingMembers = this.MEMBER_COUNT;
        for (class_3222 player : allowedPlayers) {
            if (this.IGNORE_MEMBERS.contains(player.method_5820().toLowerCase()) || !this.FORCE_MEMBERS.contains(player.method_5820().toLowerCase())) continue;
            memberPlayers.add(player);
            --remainingMembers;
        }
        for (class_3222 player : allowedPlayers) {
            if (remainingMembers <= 0) break;
            if (this.IGNORE_MEMBERS.contains(player.method_5820().toLowerCase()) || this.FORCE_MEMBERS.contains(player.method_5820().toLowerCase()) || memberPlayers.contains(player)) continue;
            memberPlayers.add(player);
            --remainingMembers;
        }
        return memberPlayers;
    }

    public void tick() {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        if (!this.societyStarted) {
            return;
        }
        if (this.societyEnded) {
            return;
        }
        ++this.ticks;
        if (this.ticks < 250L) {
            return;
        }
        if (this.ticks % 300L == 0L) {
            for (SocietyMember member : this.members) {
                class_3222 player;
                if (member.initiated || (player = member.getPlayer()) == null) continue;
                player.method_43496(class_2561.method_30163((String)"\u00a77When you are alone, type \"/initiate\""));
            }
        }
    }

    public void initiateMember(class_3222 player) {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        SocietyMember member = this.getMember(player);
        if (member == null) {
            return;
        }
        if (member.initiated) {
            return;
        }
        member.initiated = true;
        this.afterInitiate(player);
        SessionTranscript.societyMemberInitiated(player);
    }

    public void afterInitiate(class_3222 player) {
        PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)class_2960.method_60654((String)"secretlife_task")), 1.0f, 1.0f);
        int currentTime = 20;
        TaskScheduler.scheduleTask(currentTime, () -> player.method_7353(class_2561.method_30163((String)"\u00a77You have been chosen to be part of the \u00a7csecret society\u00a77."), false));
        currentTime += 50;
        int otherMembers = this.members.size() - 1;
        if (otherMembers >= 1) {
            TaskScheduler.scheduleTask(currentTime, () -> player.method_7353((class_2561)TextUtils.formatLoosely("\u00a77There {} \u00a7c{}\u00a77 other {}. Find them.", TextUtils.pluralize("is", "are", otherMembers), otherMembers, TextUtils.pluralize("member", otherMembers)), false));
            TaskScheduler.scheduleTask(currentTime += 80, () -> player.method_7353((class_2561)TextUtils.formatLoosely("\u00a77Together, secretly kill \u00a7c{}\u00a77 other {} by \u00a7cnon-pvp\u00a77 means.", this.KILL_COUNT, TextUtils.pluralize("player", this.KILL_COUNT)), false));
            TaskScheduler.scheduleTask(currentTime += 100, () -> player.method_7353(class_2561.method_30163((String)"\u00a77Find the other members with the secret word:"), false));
            TaskScheduler.scheduleTask(currentTime += 80, () -> player.method_7353(class_2561.method_30163((String)("\u00a7d\"" + this.secretWord + "\"")), false));
        } else {
            TaskScheduler.scheduleTask(currentTime, () -> player.method_7353(class_2561.method_30163((String)"\u00a77You are alone."), false));
            TaskScheduler.scheduleTask(currentTime += 80, () -> player.method_7353((class_2561)TextUtils.formatLoosely("\u00a77Secretly kill \u00a7c{}\u00a77 other {} by \u00a7cnon-pvp\u00a77 means.", this.KILL_COUNT, TextUtils.pluralize("player", this.KILL_COUNT)), false));
        }
        TaskScheduler.scheduleTask(currentTime += 80, () -> player.method_7353(class_2561.method_30163((String)"\u00a77Type \"/society success\" when you complete your goal."), false));
        TaskScheduler.scheduleTask(currentTime += 80, () -> player.method_7353(class_2561.method_30163((String)"\u00a77Don't tell anyone else about the society."), false));
        TaskScheduler.scheduleTask(currentTime += 70, () -> player.method_7353(class_2561.method_30163((String)"\u00a77If you fail..."), false));
        TaskScheduler.scheduleTask(currentTime += 70, () -> player.method_7353(this.getPunishmentText(), false));
    }

    public class_2561 getPunishmentText() {
        return TextUtils.formatLoosely("\u00a77Type \"/society fail\", and you all lose \u00a7c{} {}\u00a77.", Math.abs(this.PUNISHMENT_LIVES), TextUtils.pluralize("life", "lives", this.PUNISHMENT_LIVES));
    }

    public void removeMember(class_3222 player) {
        this.members.removeIf(member -> member.uuid == player.method_5667());
    }

    public void addMember(class_3222 player) {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        this.members.add(new SocietyMember(player));
    }

    public void addMemberManually(class_3222 player) {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        player.method_43496(class_2561.method_30163((String)"\u00a7c [NOTICE] You are now a Secret Society member!"));
        this.sendMessageToMembers(class_2561.method_30163((String)"A player has been added to the Secret Society."));
        this.addMember(player);
    }

    public void removeMemberManually(class_3222 player) {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        player.method_43496(class_2561.method_30163((String)"\u00a7c [NOTICE] You are no longer a Secret Society member!"));
        this.removeMember(player);
        this.sendMessageToMembers(class_2561.method_30163((String)"A player has been removed from the Secret Society."));
    }

    public void sendMessageToMembers(class_2561 message) {
        for (class_3222 player : this.getMembers()) {
            player.method_43496(message);
        }
    }

    public void resetMembers() {
        for (class_3222 player : this.getMembers()) {
            player.method_43496(class_2561.method_30163((String)"\u00a7c [NOTICE] You are no longer a Secret Society member!"));
        }
        this.members.clear();
    }

    public List<class_3222> getMembers() {
        ArrayList<class_3222> memberPlayers = new ArrayList<class_3222>();
        for (SocietyMember member : this.members) {
            class_3222 player = member.getPlayer();
            if (player == null) continue;
            memberPlayers.add(player);
        }
        return memberPlayers;
    }

    public void onDisabledSociety() {
        this.forceEndSociety();
    }

    public void sessionEnd() {
        if (!this.SOCIETY_ENABLED) {
            return;
        }
        if (this.societyStarted && !this.societyEnded) {
            TaskScheduler.scheduleTask(40, () -> {
                PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a7c The Secret Society has not been ended by any Member!"));
                PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a7c Run \"/society members list\" to see the Members."));
            });
        }
    }

    public void endSociety() {
        this.societyStarted = false;
        this.societyEnded = true;
        SessionTranscript.societyEnded();
        if (this.SOUND_ONLY_MEMBERS) {
            PlayerUtils.playSoundToPlayers(this.getMembers(), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_task")));
        } else {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_task")));
        }
    }

    public void endSuccess() {
        this.endSociety();
        List<class_3222> memberPlayers = this.getMembers();
        PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7aThe Society is pleased"), 20, 30, 20);
        TaskScheduler.scheduleTask(75, () -> PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7aYou will not be punished"), 20, 30, 20));
        TaskScheduler.scheduleTask(150, () -> PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7cYou are still sworn to secrecy"), 20, 30, 20));
    }

    public void endFail() {
        this.endSociety();
        List<class_3222> memberPlayers = this.getMembers();
        PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7cThe Society is displeased"), 20, 30, 20);
        TaskScheduler.scheduleTask(75, () -> PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7cYou will be punished"), 20, 30, 20));
        TaskScheduler.scheduleTask(110, () -> {
            for (class_3222 member : memberPlayers) {
                this.punishPlayer(member);
            }
        });
        TaskScheduler.scheduleTask(150, () -> PlayerUtils.sendTitleWithSubtitleToPlayers(memberPlayers, (class_2561)class_2561.method_43473(), class_2561.method_30163((String)"\u00a7cYou are still sworn to secrecy"), 20, 30, 20));
    }

    public void punishPlayer(class_3222 member) {
        PlayerUtils.damage(member, member.method_48923().method_48802((class_1657)member), 0.001f);
        int punishmentLives = Math.abs(this.PUNISHMENT_LIVES);
        Integer currentLives = Main.livesManager.getPlayerLives(member);
        if (currentLives != null) {
            punishmentLives = Math.min(Math.abs(currentLives - 1), punishmentLives);
        }
        Main.livesManager.addToPlayerLives(member, -punishmentLives);
    }
}

