/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.config.ClientConfigNetwork;
import net.mat0u5.lifeseries.gui.config.ConfigListWidget;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.GroupConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.TextConfigEntry;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends class_437 {
    private static int HEADER_HEIGHT_SMALL = 55;
    private static int HEADER_HEIGHT_LARGE = 75;
    private static final int HEADER_TITLE_Y = 10;
    private static final int HEADER_CATEGORY_GAP = 5;
    private static final int HEADER_CATEGORY_Y = 24;
    private static final int HEADER_CATEGORY_MIN_WIDTH = 130;
    private static final int HEADER_CATEGORY_HEIGHT = 20;
    private static final int HEADER_CATEGORY_NAME_OFFSET_Y = 6;
    private static final int SEARCH_BAR_WIDTH = 550;
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int SEARCH_BAR_Y_OFFSET = -6;
    private static final int FOOTER_HEIGHT = 30;
    private static final int FOOTER_BUTTON_GAP = 4;
    private static final int FOOTER_BUTTON_WIDTH = 145;
    private static final int FOOTER_BUTTON_HEIGHT = 20;
    private static final int RESETALL_BUTTON_WIDTH = 75;
    private static final int RESETALL_BUTTON_HEIGHT = 20;
    private final class_437 parent;
    private final Map<String, List<ConfigEntry>> categories;
    private final List<String> categoryNames;
    private ConfigEntry focusedEntry;
    public ConfigListWidget listWidget;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_4185 resetAllButton;
    private class_342 searchField;
    private int selectedCategory = 0;
    private boolean hasChanges = false;
    private String currentSearchQuery = "";

    public ConfigScreen(class_437 parent, class_2561 title, Map<String, List<ConfigEntry>> categories) {
        super(title);
        this.parent = parent;
        this.categories = categories;
        this.categoryNames = Lists.newArrayList(categories.keySet());
        this.initializeConfigEntries();
    }

    private void initializeConfigEntries() {
        for (List<ConfigEntry> entries : this.categories.values()) {
            for (ConfigEntry entry : entries) {
                entry.setScreen(this);
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        int headerHeight = this.categoryNames.size() > 1 ? HEADER_HEIGHT_LARGE : HEADER_HEIGHT_SMALL;
        int searchBarY = headerHeight - 20 + -6;
        int listTop = headerHeight;
        int searchBarWidth = Math.min(550, this.field_22789 - 40);
        this.searchField = new class_342(this.field_22793, (this.field_22789 - searchBarWidth) / 2, searchBarY, searchBarWidth, 20, class_2561.method_30163((String)"\u00a77Search config..."));
        this.searchField.method_47404(class_2561.method_30163((String)"\u00a77Search config..."));
        this.searchField.method_1852(this.currentSearchQuery);
        this.searchField.method_1863(this::onSearchChanged);
        this.method_25429((class_364)this.searchField);
        this.listWidget = new ConfigListWidget(this.field_22787, this.field_22789, this.field_22790 - listTop - 30, listTop, 20);
        this.listWidget.setScreen(this);
        this.method_25429((class_364)this.listWidget);
        this.method_37063((class_364)this.listWidget);
        this.refreshList();
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Save & Quit"), button -> this.save()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 20 - 4, 145, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Discard Changes"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 145 - 4, this.field_22790 - 20 - 4, 145, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.resetAllButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Reset All"), button -> this.resetAll()).method_46434(this.field_22789 - 75 - 10, this.field_22790 - 20 - 4, 75, 20).method_46431();
        this.method_37063((class_364)this.resetAllButton);
        this.updateButtonStates();
    }

    private void resetAll() {
        for (ConfigEntry entry : this.getAllEntries(this.categories.get(this.categoryNames.get(this.selectedCategory)))) {
            entry.resetToDefault();
            entry.markChanged();
        }
    }

    private boolean canResetAll() {
        for (ConfigEntry entry : this.getAllEntries(this.categories.get(this.categoryNames.get(this.selectedCategory)))) {
            if (!entry.canReset() || !entry.hasResetButton()) continue;
            return true;
        }
        return false;
    }

    private void onSearchChanged(String query) {
        this.currentSearchQuery = query;
        this.refreshList();
    }

    private boolean matchesSearch(ConfigEntry entry, String query) {
        if (entry instanceof TextConfigEntry) {
            return false;
        }
        if (query.isEmpty()) {
            return true;
        }
        String lowerQuery = query.toLowerCase();
        if (entry.getDisplayName().getString().toLowerCase().contains(lowerQuery)) {
            return true;
        }
        if (entry.getFieldName().toLowerCase().contains(lowerQuery)) {
            return true;
        }
        String description = entry.getDescription();
        return description != null && !description.isEmpty() && description.toLowerCase().contains(lowerQuery);
    }

    private List<ConfigEntry> getFilteredEntries(List<ConfigEntry> entries, String searchQuery) {
        if (searchQuery.isEmpty()) {
            return entries;
        }
        ArrayList<ConfigEntry> filteredEntries = new ArrayList<ConfigEntry>();
        for (ConfigEntry entry : entries) {
            if (!this.matchesSearch(entry, searchQuery)) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    private void refreshList() {
        String categoryName;
        List<ConfigEntry> entries;
        this.listWidget.clearAllEntries();
        if (this.selectedCategory < this.categoryNames.size() && (entries = this.categories.get(categoryName = this.categoryNames.get(this.selectedCategory))) != null) {
            String searchQuery = this.currentSearchQuery.trim();
            if (searchQuery.isEmpty()) {
                for (ConfigEntry entry : entries) {
                    this.listWidget.addEntry(entry);
                }
            } else {
                for (ConfigEntry entry : this.getFilteredEntries(this.getAllEntries(entries), searchQuery)) {
                    this.listWidget.addEntry(entry);
                }
            }
        }
        this.updateButtonStates();
    }

    public void onEntryValueChanged() {
        this.updateButtonStates();
    }

    public List<ConfigEntry> getAllEntries() {
        ArrayList<ConfigEntry> allSurfaceEntries = new ArrayList<ConfigEntry>();
        for (List<ConfigEntry> entries : this.categories.values()) {
            allSurfaceEntries.addAll(entries);
        }
        return this.getAllEntries(allSurfaceEntries);
    }

    public List<ConfigEntry> getAllEntries(List<ConfigEntry> currentEntries) {
        ArrayList<ConfigEntry> allEntries = new ArrayList<ConfigEntry>();
        for (ConfigEntry entry : currentEntries) {
            if (entry instanceof GroupConfigEntry) {
                GroupConfigEntry groupEntry = (GroupConfigEntry)entry;
                allEntries.addAll(this.getAllEntries(groupEntry.getChildEntries()));
                allEntries.addAll(this.getAllEntries(List.of(groupEntry.getMainEntry())));
                continue;
            }
            allEntries.add(entry);
        }
        return allEntries;
    }

    private void updateButtonStates() {
        this.hasChanges = false;
        for (ConfigEntry entry : this.getAllEntries()) {
            if (!entry.modified()) continue;
            this.hasChanges = true;
            break;
        }
        if (this.saveButton != null) {
            boolean bl = this.saveButton.field_22763 = this.hasChanges && !this.hasErrors();
        }
        if (this.resetAllButton != null) {
            this.resetAllButton.field_22763 = this.canResetAll();
        }
    }

    private boolean hasErrors() {
        for (ConfigEntry entry : this.getAllEntries()) {
            if (!entry.hasError()) continue;
            return true;
        }
        return false;
    }

    private void save() {
        ArrayList<ConfigEntry> allSurfaceEntriesClient = new ArrayList<ConfigEntry>();
        ArrayList<ConfigEntry> allSurfaceEntriesServer = new ArrayList<ConfigEntry>();
        for (Map.Entry<String, List<ConfigEntry>> category : this.categories.entrySet()) {
            if (category.getKey().equals("Server")) {
                allSurfaceEntriesServer.addAll((Collection<ConfigEntry>)category.getValue());
                continue;
            }
            if (!category.getKey().equals("Client")) continue;
            allSurfaceEntriesClient.addAll((Collection<ConfigEntry>)category.getValue());
        }
        for (ConfigEntry entry : this.getAllEntries(allSurfaceEntriesServer)) {
            if (!entry.modified() || entry instanceof GroupConfigEntry) continue;
            NetworkHandlerClient.sendConfigUpdate(entry.getValueType().toString(), entry.getFieldName(), List.of(entry.getValueAsString()));
        }
        for (ConfigEntry entry : this.getAllEntries(allSurfaceEntriesClient)) {
            if (!entry.modified() || entry instanceof GroupConfigEntry) continue;
            ClientConfigNetwork.onConfigSave(entry);
        }
        MainClient.reloadConfig();
        this.field_22787.method_1507(this.parent);
    }

    public void method_25419() {
        if (this.hasChanges) {
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    this.field_22787.method_1507(this.parent);
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, class_2561.method_30163((String)"Changes Not Saved"), class_2561.method_30163((String)"Are you sure you want to quit editing the config? Changes will not be saved!"), class_2561.method_30163((String)"Quit & Discard Changes"), class_2561.method_30163((String)"Cancel")));
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, TextColors.WHITE);
        if (this.categoryNames.size() > 1) {
            this.renderCategoryTabs(context, mouseX, mouseY);
        }
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        if (this.hasErrors()) {
            context.method_27535(this.field_22793, class_2561.method_30163((String)"Errors"), 10, 10, TextColors.LIGHT_RED);
        }
    }

    private void renderCategoryTabs(class_332 context, int mouseX, int mouseY) {
        int tabWidth = Math.min(130, this.field_22789 / this.categoryNames.size());
        int startX = (this.field_22789 - (tabWidth + 5) * this.categoryNames.size()) / 2;
        for (int i = 0; i < this.categoryNames.size(); ++i) {
            boolean isHovered;
            int tabX = startX + i * (tabWidth + 5);
            int tabY = 24;
            int tabHeight = 20;
            boolean isSelected = i == this.selectedCategory;
            boolean bl = isHovered = mouseX >= tabX && mouseX < tabX + tabWidth && mouseY >= tabY && mouseY < tabY + tabHeight;
            int color = isSelected ? TextColors.WHITE_A128 : (isHovered ? TextColors.WHITE_A64 : TextColors.WHITE_A32);
            context.method_25294(tabX, tabY, tabX + tabWidth, tabY + tabHeight, color);
            String categoryName = this.categoryNames.get(i);
            int textColor = isSelected ? TextColors.WHITE : TextColors.PASTEL_WHITE;
            context.method_25300(this.field_22793, categoryName, tabX + tabWidth / 2, tabY + 6, textColor);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean leftClick;
        int mouseX = (int)click.comp_4798();
        int mouseY = (int)click.comp_4799();
        boolean bl = leftClick = click.method_74245() == 0;
        if (this.searchField.method_25402(click, doubled)) {
            this.focusSearch();
            return true;
        }
        this.searchField.method_25365(false);
        if (this.categoryNames.size() > 1 && leftClick) {
            int tabWidth = Math.min(130, this.field_22789 / this.categoryNames.size());
            int startX = (this.field_22789 - (tabWidth + 5) * this.categoryNames.size()) / 2;
            for (int i = 0; i < this.categoryNames.size(); ++i) {
                int tabX = startX + i * (tabWidth + 5);
                int tabY = 24;
                int tabHeight = 20;
                if (mouseX < tabX || mouseX >= tabX + tabWidth || mouseY < tabY || mouseY >= tabY + tabHeight) continue;
                this.selectedCategory = i;
                this.refreshList();
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25404(class_11908 keyInput) {
        int keyCode = keyInput.method_74228();
        int modifiers = keyInput.comp_4797();
        if (this.searchField.method_25370() && this.searchField.method_25404(keyInput)) {
            return true;
        }
        if (keyCode == 70 && (modifiers & 2) != 0) {
            this.focusSearch();
            return true;
        }
        return super.method_25404(keyInput);
    }

    public boolean method_25400(class_11905 charInput) {
        if (this.searchField.method_25370() && this.searchField.method_25400(charInput)) {
            return true;
        }
        return super.method_25400(charInput);
    }

    public void focusSearch() {
        if (this.focusedEntry != null) {
            this.focusedEntry.setFocused(false);
            this.focusedEntry = null;
        }
        this.searchField.method_25365(true);
    }

    public class_327 getTextRenderer() {
        return this.field_22793;
    }

    public ConfigEntry getFocusedEntry() {
        return this.focusedEntry;
    }

    public void setFocusedEntry(ConfigEntry entry) {
        if (entry instanceof GroupConfigEntry) {
            return;
        }
        if (this.focusedEntry == entry) {
            return;
        }
        this.searchField.method_25365(false);
        if (this.focusedEntry != null) {
            this.focusedEntry.setFocused(false);
        }
        this.focusedEntry = entry;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        private final class_437 parent;
        private final class_2561 title;
        private final Map<String, List<ConfigEntry>> categories = Maps.newLinkedHashMap();

        public Builder(class_437 parent, class_2561 title) {
            this.parent = parent;
            this.title = title;
        }

        public CategoryBuilder addCategory(String name) {
            this.categories.put(name, Lists.newArrayList());
            return new CategoryBuilder(this, name);
        }

        public ConfigScreen build() {
            return new ConfigScreen(this.parent, this.title, this.categories);
        }

        @Environment(value=EnvType.CLIENT)
        public static class CategoryBuilder {
            private final Builder parent;
            private final String categoryName;

            public CategoryBuilder(Builder parent, String categoryName) {
                this.parent = parent;
                this.categoryName = categoryName;
            }

            public CategoryBuilder addEntry(ConfigEntry entry) {
                this.parent.categories.get(this.categoryName).add(entry);
                return this;
            }

            public Builder endCategory() {
                return this.parent;
            }
        }
    }
}

