/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.other;

import java.util.Random;

public class WeightedRandomizer {
    private Random random;

    public WeightedRandomizer() {
        this.random = new Random();
    }

    public WeightedRandomizer(long seed) {
        this.random = new Random(seed);
    }

    public int getWeightedRandom(int minValue, int maxValue, int biasLevel, int maxBiasLevel, double biasStrength) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue cannot be greater than maxValue");
        }
        if (biasLevel < 1 || biasLevel > maxBiasLevel) {
            throw new IllegalArgumentException("biasLevel must be between 1 and " + maxBiasLevel);
        }
        if (biasStrength <= 0.0) {
            throw new IllegalArgumentException("biasStrength must be positive");
        }
        int range = maxValue - minValue + 1;
        double[] weights = new double[range];
        double normalizedBias = (double)(biasLevel - 1) / (double)(maxBiasLevel - 1);
        double targetCenter = normalizedBias * (double)(range - 1);
        for (int i = 0; i < range; ++i) {
            double distance = Math.abs((double)i - targetCenter);
            weights[i] = Math.exp(-distance * (biasStrength / 10.0)) + 0.05;
        }
        int selectedIndex = this.weightedRandomSelect(weights);
        return minValue + selectedIndex;
    }

    public int getWeightedRandom(int minValue, int maxValue, int biasLevel, int maxBiasLevel) {
        return this.getWeightedRandom(minValue, maxValue, biasLevel, maxBiasLevel, 1.0);
    }

    private int weightedRandomSelect(double[] weights) {
        double totalWeight = 0.0;
        for (double weight : weights) {
            totalWeight += weight;
        }
        double randomValue = this.random.nextDouble() * totalWeight;
        double currentWeight = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            if (!(randomValue <= (currentWeight += weights[i]))) continue;
            return i;
        }
        return weights.length - 1;
    }

    public void testDistribution(int min, int max, int minBias, int maxBias, double strength) {
        for (int bias = minBias; bias <= maxBias; ++bias) {
            System.out.printf("\nBias Level %d (targeting %s):\n", bias, bias == minBias ? "low values" : (bias == maxBias ? "high values" : "middle values"));
            int[] counts = new int[max - min + 1];
            for (int i = 0; i < 500000; ++i) {
                int result = this.getWeightedRandom(min, max, bias, maxBias, strength);
                int n = result - min;
                counts[n] = counts[n] + 1;
            }
            int[] topIndices = new int[Math.min(10, counts.length)];
            for (int i = 0; i < topIndices.length; ++i) {
                int maxIndex = 0;
                for (int j = 1; j < counts.length; ++j) {
                    if (counts[j] <= counts[maxIndex]) continue;
                    maxIndex = j;
                }
                topIndices[i] = maxIndex;
                System.out.printf("  %d: %.1f%% ", min + maxIndex, (double)counts[maxIndex] / 500000.0 * 100.0);
                counts[maxIndex] = -1;
            }
            System.out.println();
        }
    }
}

