/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.config;

import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;

public class ConfigFileEntry<T> {
    public final String key;
    public T defaultValue;
    public final ConfigTypes type;
    public final String displayName;
    public final String description;
    public final String groupInfo;
    public final List<String> args;

    public ConfigFileEntry(String key, T defaultValue, String groupInfo, String displayName, String description) {
        this(key, defaultValue, ConfigFileEntry.getTypeFromValue(defaultValue), groupInfo, displayName, description);
    }

    public ConfigFileEntry(String key, T defaultValue, ConfigTypes type, String groupInfo, String displayName, String description) {
        this(key, defaultValue, type, groupInfo, displayName, description, null);
    }

    public ConfigFileEntry(String key, T defaultValue, ConfigTypes type, String groupInfo, String displayName, String description, List<String> args) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
        this.displayName = displayName;
        this.description = description;
        this.groupInfo = groupInfo;
        this.args = args;
    }

    public static ConfigTypes getTypeFromValue(Object defaultValue) {
        if (defaultValue instanceof Integer) {
            return ConfigTypes.INTEGER;
        }
        if (defaultValue instanceof Boolean) {
            return ConfigTypes.BOOLEAN;
        }
        if (defaultValue instanceof Double) {
            return ConfigTypes.DOUBLE;
        }
        if (defaultValue instanceof String) {
            return ConfigTypes.STRING;
        }
        return ConfigTypes.NULL;
    }

    public T get(ConfigManager config) {
        try {
            T t = this.defaultValue;
            if (t instanceof Integer) {
                Integer i = (Integer)t;
                return (T)Integer.valueOf(config.getOrCreateInt(this.key, i));
            }
            t = this.defaultValue;
            if (t instanceof Boolean) {
                Boolean b = (Boolean)t;
                return (T)Boolean.valueOf(config.getOrCreateBoolean(this.key, b));
            }
            t = this.defaultValue;
            if (t instanceof Double) {
                Double d = (Double)t;
                return (T)Double.valueOf(config.getOrCreateDouble(this.key, d));
            }
            t = this.defaultValue;
            if (t instanceof String) {
                String s = (String)t;
                return (T)config.getOrCreateProperty(this.key, s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Main.LOGGER.error(TextUtils.formatString("Config value {} was null, returning default value - {}", this.key, this.defaultValue));
        return this.defaultValue;
    }
}

