/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.main;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.NumberConfigEntry;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;

@Environment(value=EnvType.CLIENT)
public class IntegerConfigEntry
extends NumberConfigEntry<Integer> {
    public IntegerConfigEntry(String fieldName, String displayName, String description, int value, int defaultValue) {
        super(fieldName, displayName, description, Integer.valueOf(value), Integer.valueOf(defaultValue));
    }

    public IntegerConfigEntry(String fieldName, String displayName, String description, int value, int defaultValue, Integer minValue, Integer maxValue) {
        super(fieldName, displayName, description, value, defaultValue, minValue, maxValue);
    }

    @Override
    protected Integer parseValue(String text) throws NumberFormatException {
        return Integer.parseInt(text);
    }

    @Override
    protected boolean isValueInRange(Integer value) {
        if (this.minValue == null || this.maxValue == null) {
            return true;
        }
        return value >= (Integer)this.minValue && value <= (Integer)this.maxValue;
    }

    @Override
    protected boolean isValidType(Object value) {
        return value instanceof Integer;
    }

    @Override
    protected Integer castValue(Object value) {
        return (Integer)value;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.INTEGER;
    }
}

