/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.pastlife;

import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.pastlife.PastLifeBoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.pastlife.PastLifeConfig;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PastLife
extends Season {
    public static final String COMMANDS_ADMIN_TEXT = "/lifeseries, /session, /claimkill, /lives, /boogeyman, /society, /pastlife";
    public static final String COMMANDS_TEXT = "/claimkill, /lives, /society, /initiate";

    @Override
    public Seasons getSeason() {
        return Seasons.PAST_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        return new PastLifeConfig();
    }

    @Override
    public BoogeymanManager createBoogeymanManager() {
        return new PastLifeBoogeymanManager();
    }

    @Override
    public String getAdminCommands() {
        return COMMANDS_ADMIN_TEXT;
    }

    @Override
    public String getNonAdminCommands() {
        return COMMANDS_TEXT;
    }

    @Override
    public void addSessionActions() {
        if (this.boogeymanManager.BOOGEYMAN_ENABLED && this.secretSociety.SOCIETY_ENABLED) {
            TaskScheduler.scheduleTask(20, this::requestSessionAction);
            return;
        }
        super.addSessionActions();
    }

    public void requestSessionAction() {
        for (class_3222 player : PlayerUtils.getAdminPlayers()) {
            if (NetworkHandlerServer.wasHandshakeSuccessful(player)) {
                NetworkHandlerServer.sendStringPacket(player, PacketNames.PAST_LIFE_CHOOSE_TWIST, "");
                continue;
            }
            player.method_64398(class_2561.method_30163((String)"\u00a77Past Life session started:"));
            player.method_64398(class_2561.method_30163((String)"\u00a77 Type \u00a7f\"/pastlife boogeyman\"\u00a77 to have the Boogeyman in this session."));
            player.method_64398(class_2561.method_30163((String)"\u00a77 Type \u00a7f\"/pastlife society\"\u00a77 to have the Secret Society in this session."));
            player.method_64398(class_2561.method_30163((String)"\u00a77 Or type \u00a7f\"/pastlife pickRandom\"\u00a77 if you want the game to pick randomly."));
        }
    }
}

