/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.StringListConfig;
import net.mat0u5.lifeseries.config.StringListManager;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLifeLocationConfig;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLifeUsedTasks;
import net.mat0u5.lifeseries.seasons.season.secretlife.Task;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.mat0u5.lifeseries.utils.world.ItemSpawner;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.mat0u5.lifeseries.utils.world.WorldUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.joml.Vector3f;

public class TaskManager {
    public static int EASY_SUCCESS = 20;
    public static int EASY_FAIL = 0;
    public static int HARD_SUCCESS = 40;
    public static int HARD_FAIL = -20;
    public static int RED_SUCCESS = 10;
    public static int RED_FAIL = -5;
    public static double ASSIGN_TASKS_MINUTE = 1.0;
    public static boolean BROADCAST_SECRET_KEEPER = false;
    public static boolean CONSTANT_TASKS = false;
    public static boolean PUBLIC_TASKS_ON_SUBMIT = false;
    public static class_2338 successButtonPos;
    public static class_2338 rerollButtonPos;
    public static class_2338 failButtonPos;
    public static class_2338 itemSpawnerPos;
    public static boolean tasksChosen;
    public static List<UUID> tasksChosenFor;
    public static List<UUID> submittedOrFailed;
    public static boolean secretKeeperBeingUsed;
    public static int secretKeeperBeingUsedFor;
    public static StringListConfig usedTasksConfig;
    public static SecretLifeLocationConfig locationsConfig;
    public static Map<UUID, Task> preAssignedTasks;
    public static Map<UUID, Task> assignedTasks;
    public static List<String> easyTasks;
    public static List<String> hardTasks;
    public static List<String> redTasks;
    public static final Random rnd;
    public static boolean searchingForLocations;

    public static SessionAction getActionChooseTasks() {
        return new SessionAction(OtherUtils.minutesToTicks(ASSIGN_TASKS_MINUTE), TextUtils.formatString("\u00a77Assign Tasks \u00a7f[{}]", OtherUtils.formatTime(OtherUtils.minutesToTicks(ASSIGN_TASKS_MINUTE))), "Assign Tasks"){

            @Override
            public void trigger() {
                TaskManager.chooseTasks(Main.livesManager.getAlivePlayers(), null);
                tasksChosen = true;
            }
        };
    }

    public static void initialize() {
        usedTasksConfig = new StringListConfig("./config/lifeseries/main", "DO_NOT_MODIFY_secretlife_used_tasks.properties");
        locationsConfig = new SecretLifeLocationConfig();
        locationsConfig.loadLocations();
        StringListManager configEasyTasks = new StringListManager("./config/lifeseries/secretlife", "easy-tasks.json");
        StringListManager configHardTasks = new StringListManager("./config/lifeseries/secretlife", "hard-tasks.json");
        StringListManager configRedTasks = new StringListManager("./config/lifeseries/secretlife", "red-tasks.json");
        easyTasks = configEasyTasks.loadStrings();
        hardTasks = configHardTasks.loadStrings();
        redTasks = configRedTasks.loadStrings();
        List<String> alreadySelected = SecretLifeUsedTasks.getUsedTasks(usedTasksConfig);
        for (String selected : alreadySelected) {
            easyTasks.remove(selected);
            hardTasks.remove(selected);
        }
    }

    public static void deleteLocations() {
        locationsConfig.deleteLocations();
    }

    public static Task getRandomTask(class_3222 owner, TaskTypes type) {
        String selectedTask = "";
        if (easyTasks.isEmpty()) {
            StringListManager configEasyTasks = new StringListManager("./config/lifeseries/secretlife", "easy-tasks.json");
            easyTasks = configEasyTasks.loadStrings();
            SecretLifeUsedTasks.deleteAllTasks(usedTasksConfig, easyTasks);
        }
        if (hardTasks.isEmpty()) {
            StringListManager configHardTasks = new StringListManager("./config/lifeseries/secretlife", "hard-tasks.json");
            hardTasks = configHardTasks.loadStrings();
            SecretLifeUsedTasks.deleteAllTasks(usedTasksConfig, hardTasks);
        }
        if (type == TaskTypes.EASY && !easyTasks.isEmpty()) {
            selectedTask = TaskManager.getRandomTask(owner, type, easyTasks);
            if (!selectedTask.isEmpty()) {
                easyTasks.remove(selectedTask);
            }
        } else if (type == TaskTypes.HARD && !hardTasks.isEmpty()) {
            selectedTask = TaskManager.getRandomTask(owner, type, hardTasks);
            if (!selectedTask.isEmpty()) {
                hardTasks.remove(selectedTask);
            }
        } else if (type == TaskTypes.RED && !redTasks.isEmpty()) {
            selectedTask = TaskManager.getRandomTask(owner, type, redTasks);
        }
        if (type != TaskTypes.RED && !selectedTask.isEmpty()) {
            SecretLifeUsedTasks.addUsedTask(usedTasksConfig, selectedTask);
        }
        return new Task(selectedTask, type);
    }

    public static String getRandomTask(class_3222 owner, TaskTypes type, List<String> tasks) {
        ArrayList<String> tasksCopy = new ArrayList<String>(tasks);
        Collections.shuffle(tasksCopy);
        for (String taskCandidate : tasksCopy) {
            Task testTask = new Task(taskCandidate, type);
            if (!testTask.isValid(owner)) continue;
            return taskCandidate;
        }
        return "";
    }

    public static List<Task> getAllTasks(TaskTypes type) {
        ArrayList<Task> result = new ArrayList<Task>();
        List<String> tasks = easyTasks;
        if (type == TaskTypes.HARD) {
            tasks = hardTasks;
        } else if (type == TaskTypes.RED) {
            tasks = redTasks;
        }
        for (String taskStr : tasks) {
            Task task = new Task(taskStr, type);
            result.add(task);
        }
        return result;
    }

    public static class_1799 getTaskBook(class_3222 player, Task task) {
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        List<class_9262<class_2561>> lines = task.getBookLines(player);
        class_9302 bookContent = new class_9302(class_9262.method_57137((Object)TextUtils.formatString("\u00a7c{}'s Secret Task", player)), "Secret Keeper", 0, lines, true);
        ArrayList<String> linesStr = new ArrayList<String>();
        for (class_9262<class_2561> line : lines) {
            linesStr.add(((class_2561)line.method_57140(true)).getString());
        }
        book.method_57379(class_9334.field_49606, (Object)bookContent);
        SessionTranscript.assignTask(player, task, linesStr);
        ItemStackUtils.setCustomComponentBoolean(book, "SecretTask", true);
        ItemStackUtils.setCustomComponentInt(book, "TaskDifficulty", task.getDifficulty());
        ItemStackUtils.setCustomComponentBoolean(book, "KillPermitted", task.killPermitted());
        return book;
    }

    public static void assignRandomTaskToPlayer(class_3222 player, TaskTypes type) {
        Task task;
        if (type != TaskTypes.RED || CONSTANT_TASKS) {
            submittedOrFailed.remove(player.method_5667());
        }
        TaskManager.removePlayersTaskBook(player);
        if (Main.livesManager.isDead(player)) {
            return;
        }
        if (preAssignedTasks.containsKey(player.method_5667())) {
            task = preAssignedTasks.get(player.method_5667());
            preAssignedTasks.remove(player.method_5667());
        } else {
            task = TaskManager.getRandomTask(player, type);
        }
        class_1799 book = TaskManager.getTaskBook(player, task);
        if (!player.method_7270(book)) {
            ItemStackUtils.spawnItemForPlayer(PlayerUtils.getServerWorld(player), WorldUtils.getEntityPos((class_1297)player), book, (class_1657)player);
        }
        assignedTasks.put(player.method_5667(), task);
    }

    public static void assignRandomTasks(List<class_3222> allowedPlayers, TaskTypes type) {
        for (class_3222 player : allowedPlayers) {
            if (Main.livesManager.isDead(player)) continue;
            TaskTypes thisType = type;
            if (thisType == null) {
                thisType = TaskTypes.EASY;
                if (Main.livesManager.isOnLastLife(player, false)) {
                    thisType = TaskTypes.RED;
                }
            }
            TaskManager.assignRandomTaskToPlayer(player, thisType);
        }
    }

    public static void chooseTasks(List<class_3222> allowedPlayers, TaskTypes type) {
        secretKeeperBeingUsed = true;
        for (class_3222 player : allowedPlayers) {
            if (tasksChosenFor.contains(player.method_5667())) continue;
            tasksChosenFor.add(player.method_5667());
        }
        PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"Your secret is...").method_27692(class_124.field_1061), 20, 35, 0);
        TaskScheduler.scheduleTask(40, () -> {
            PlayerUtils.playSoundToPlayers(allowedPlayers, (class_3414)class_3417.field_15015.comp_349());
            PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"3").method_27692(class_124.field_1061), 0, 35, 0);
        });
        TaskScheduler.scheduleTask(70, () -> {
            PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"2").method_27692(class_124.field_1061), 0, 35, 0);
            PlayerUtils.playSoundToPlayers(allowedPlayers, class_3414.method_47908((class_2960)class_2960.method_60656((String)"secretlife_task")));
        });
        TaskScheduler.scheduleTask(105, () -> PlayerUtils.sendTitleToPlayers(allowedPlayers, (class_2561)class_2561.method_43470((String)"1").method_27692(class_124.field_1061), 0, 35, 0));
        TaskScheduler.scheduleTask(130, () -> {
            for (class_3222 player : allowedPlayers) {
                boolean redTask = type == TaskTypes.RED || type == null && Main.livesManager.isOnLastLife(player, false);
                AnimationUtils.playSecretLifeTotemAnimation(player, redTask);
            }
        });
        TaskScheduler.scheduleTask(165, () -> {
            TaskManager.assignRandomTasks(allowedPlayers, type);
            secretKeeperBeingUsed = false;
        });
    }

    public static class_1799 getPlayersTaskBook(class_3222 player) {
        for (class_1799 item : PlayerUtils.getPlayerInventory(player)) {
            if (!ItemStackUtils.hasCustomComponentEntry(item, "SecretTask")) continue;
            return item;
        }
        return null;
    }

    public static boolean hasNonRedTaskBook(class_3222 player) {
        for (class_1799 item : PlayerUtils.getPlayerInventory(player)) {
            int difficulty;
            if (!ItemStackUtils.hasCustomComponentEntry(item, "SecretTask") || !ItemStackUtils.hasCustomComponentEntry(item, "TaskDifficulty") || (difficulty = ItemStackUtils.getCustomComponentInt(item, "TaskDifficulty").intValue()) != 1 && difficulty != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean removePlayersTaskBook(class_3222 player) {
        boolean success = false;
        for (class_1799 item : PlayerUtils.getPlayerInventory(player)) {
            if (!ItemStackUtils.hasCustomComponentEntry(item, "SecretTask")) continue;
            PlayerUtils.clearItemStack(player, item);
            success = true;
        }
        return success;
    }

    public static boolean getPlayerKillPermitted(class_3222 player) {
        class_1799 item = TaskManager.getPlayersTaskBook(player);
        if (item == null) {
            return false;
        }
        if (!ItemStackUtils.hasCustomComponentEntry(item, "SecretTask")) {
            return false;
        }
        if (!ItemStackUtils.hasCustomComponentEntry(item, "TaskDifficulty")) {
            return false;
        }
        if (!ItemStackUtils.hasCustomComponentEntry(item, "KillPermitted")) {
            return false;
        }
        return ItemStackUtils.getCustomComponentBoolean(item, "KillPermitted");
    }

    public static TaskTypes getPlayersTaskType(class_3222 player) {
        class_1799 item = TaskManager.getPlayersTaskBook(player);
        if (item == null) {
            return null;
        }
        if (!ItemStackUtils.hasCustomComponentEntry(item, "SecretTask")) {
            return null;
        }
        if (!ItemStackUtils.hasCustomComponentEntry(item, "TaskDifficulty")) {
            return null;
        }
        int difficulty = ItemStackUtils.getCustomComponentInt(item, "TaskDifficulty");
        if (difficulty == 1) {
            return TaskTypes.EASY;
        }
        if (difficulty == 2) {
            return TaskTypes.HARD;
        }
        if (difficulty == 3) {
            return TaskTypes.RED;
        }
        return null;
    }

    public static void addHealthThenItems(class_3222 player, int addHealth) {
        int rounded;
        int remainderToMax;
        if (Main.server == null) {
            return;
        }
        if (addHealth == 0) {
            secretKeeperBeingUsed = false;
            return;
        }
        secretKeeperBeingUsed = true;
        SecretLife season = (SecretLife)Main.currentSeason;
        double currentHealth = season.getPlayerHealth(player);
        if (currentHealth > SecretLife.MAX_HEALTH) {
            currentHealth = SecretLife.MAX_HEALTH;
        }
        if (addHealth <= (remainderToMax = (int)SecretLife.MAX_HEALTH - (rounded = (int)Math.floor(currentHealth))) && remainderToMax != 0) {
            season.addPlayerHealth(player, addHealth);
            secretKeeperBeingUsed = false;
        } else {
            int itemsNum;
            if (remainderToMax != 0) {
                season.setPlayerHealth(player, SecretLife.MAX_HEALTH);
            }
            if ((itemsNum = (addHealth - remainderToMax) / 2) == 0) {
                secretKeeperBeingUsed = false;
                return;
            }
            class_243 spawnPos = itemSpawnerPos.method_46558();
            for (int i = 0; i <= itemsNum; ++i) {
                if (i == 0) continue;
                TaskScheduler.scheduleTask(3 * i, () -> {
                    Main.server.method_30002().method_43128(null, spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
                    List<class_1799> lootTableItems = ItemSpawner.getRandomItemsFromLootTable(Main.server, Main.server.method_30002(), player, class_2960.method_60655((String)"lifeseriesdynamic", (String)"task_reward_loottable"));
                    if (!lootTableItems.isEmpty()) {
                        for (class_1799 item : lootTableItems) {
                            ItemStackUtils.spawnItemForPlayer(Main.server.method_30002(), spawnPos, item, (class_1657)player);
                        }
                    } else {
                        class_1799 randomItem = season.itemSpawner.getRandomItem();
                        ItemStackUtils.spawnItemForPlayer(Main.server.method_30002(), spawnPos, randomItem, (class_1657)player);
                    }
                });
            }
            TaskScheduler.scheduleTask(3 * itemsNum + 20, () -> {
                secretKeeperBeingUsed = false;
            });
        }
    }

    public static boolean hasSessionStarted(class_3222 player) {
        if (Main.currentSession.statusNotStarted()) {
            player.method_64398(class_2561.method_30163((String)"\u00a7cThe session has not started yet."));
            return false;
        }
        return true;
    }

    public static boolean isBeingUsed(class_3222 player) {
        if (!secretKeeperBeingUsed) {
            return false;
        }
        player.method_64398(class_2561.method_30163((String)"\u00a7cSomeone else is using the Secret Keeper right now."));
        return true;
    }

    public static boolean hasTaskBookCheck(class_3222 player, boolean sendMessage) {
        TaskTypes type = TaskManager.getPlayersTaskType(player);
        if (type != null) {
            return true;
        }
        if (sendMessage) {
            player.method_64398(class_2561.method_30163((String)"\u00a7cYou do not have a secret task book in your inventory."));
        }
        return false;
    }

    public static void sendPublicTaskMessage(class_3222 player) {
        String rawTask = "";
        Task task = null;
        if (TaskManager.hasTaskBookCheck(player, false) && assignedTasks.containsKey(player.method_5667())) {
            task = assignedTasks.get(player.method_5667());
        } else if (preAssignedTasks.containsKey(player.method_5667())) {
            task = preAssignedTasks.get(player.method_5667());
        }
        if (task == null) {
            return;
        }
        rawTask = !task.formattedTask.isEmpty() ? task.formattedTask : task.rawTask;
        PlayerUtils.broadcastMessage((class_2561)TextUtils.format("\u00a77Click {}\u00a77 to see what {}\u00a77's task was.", TextUtils.selfMessageText(rawTask), player));
    }

    public static void succeedTask(class_3222 player, boolean fromCommand) {
        if (Main.server == null) {
            return;
        }
        if (!fromCommand) {
            if (!TaskManager.hasSessionStarted(player)) {
                return;
            }
            if (TaskManager.isBeingUsed(player)) {
                return;
            }
        }
        TaskTypes type = TaskManager.getPlayersTaskType(player);
        if (!TaskManager.hasTaskBookCheck(player, !fromCommand)) {
            return;
        }
        if (BROADCAST_SECRET_KEEPER) {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a7a succeeded their task.", player));
        }
        if (PUBLIC_TASKS_ON_SUBMIT) {
            TaskManager.sendPublicTaskMessage(player);
        }
        SessionTranscript.successTask(player);
        TaskManager.removePlayersTaskBook(player);
        submittedOrFailed.add(player.method_5667());
        secretKeeperBeingUsed = true;
        class_243 centerPos = itemSpawnerPos.method_46558();
        AnimationUtils.createGlyphAnimation(Main.server.method_30002(), centerPos, 40);
        Main.server.method_30002().method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_task")), class_3419.field_15248, 1.0f, 1.0f);
        TaskScheduler.scheduleTask(60, () -> {
            Main.server.method_30002().method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_47211, class_3419.field_15248, 1.0f, 1.0f);
            AnimationUtils.spawnFireworkBall(Main.server.method_30002(), centerPos, 40, 0.3, new Vector3f(0.0f, 1.0f, 0.0f));
            if (type == TaskTypes.EASY) {
                TaskManager.showHeartTitle(player, EASY_SUCCESS);
                TaskManager.addHealthThenItems(player, EASY_SUCCESS);
            }
            if (type == TaskTypes.HARD) {
                TaskManager.showHeartTitle(player, HARD_SUCCESS);
                TaskManager.addHealthThenItems(player, HARD_SUCCESS);
            }
            if (type == TaskTypes.RED) {
                TaskManager.showHeartTitle(player, RED_SUCCESS);
                TaskManager.addHealthThenItems(player, RED_SUCCESS);
            }
        });
        TaskManager.chooseNewTaskForPlayerIfNecessary(player);
    }

    public static void rerollTask(class_3222 player, boolean fromCommand) {
        if (!fromCommand) {
            if (!TaskManager.hasSessionStarted(player)) {
                return;
            }
            if (TaskManager.isBeingUsed(player)) {
                return;
            }
        }
        TaskTypes type = TaskManager.getPlayersTaskType(player);
        if (!TaskManager.hasTaskBookCheck(player, !fromCommand)) {
            return;
        }
        if (type == TaskTypes.RED) {
            TaskManager.failTask(player, false);
            return;
        }
        if (type == TaskTypes.EASY) {
            TaskManager.removePlayersTaskBook(player);
            if (BROADCAST_SECRET_KEEPER) {
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 re-rolled their easy task.", player));
            }
            if (PUBLIC_TASKS_ON_SUBMIT) {
                TaskManager.sendPublicTaskMessage(player);
            }
            SessionTranscript.rerollTask(player);
            secretKeeperBeingUsed = true;
            TaskTypes newType = TaskTypes.HARD;
            if (Main.livesManager.isOnLastLife(player, false)) {
                TaskManager.chooseTasks(List.of(player), TaskTypes.RED);
                return;
            }
            PlayerUtils.playSoundToPlayer(player, (class_3414)class_3417.field_15015.comp_349());
            PlayerUtils.sendTitle(player, (class_2561)class_2561.method_43470((String)"The reward is more").method_27692(class_124.field_1077).method_27692(class_124.field_1067), 20, 35, 0);
            TaskScheduler.scheduleTask(50, () -> {
                PlayerUtils.playSoundToPlayer(player, (class_3414)class_3417.field_15015.comp_349());
                PlayerUtils.sendTitle(player, (class_2561)class_2561.method_43470((String)"The risk is great").method_27692(class_124.field_1060).method_27692(class_124.field_1067), 20, 35, 0);
            });
            TaskScheduler.scheduleTask(100, () -> {
                PlayerUtils.playSoundToPlayer(player, (class_3414)class_3417.field_15015.comp_349());
                PlayerUtils.sendTitle(player, (class_2561)class_2561.method_43470((String)"Let me open the door").method_27692(class_124.field_1054).method_27692(class_124.field_1067), 20, 35, 0);
            });
            TaskScheduler.scheduleTask(150, () -> {
                PlayerUtils.playSoundToPlayer(player, (class_3414)class_3417.field_15015.comp_349());
                PlayerUtils.sendTitle(player, (class_2561)class_2561.method_43470((String)"Accept your fate").method_27692(class_124.field_1061).method_27692(class_124.field_1067), 20, 30, 0);
            });
            TaskScheduler.scheduleTask(200, () -> AnimationUtils.playSecretLifeTotemAnimation(player, false));
            TaskScheduler.scheduleTask(240, () -> {
                TaskManager.assignRandomTaskToPlayer(player, newType);
                secretKeeperBeingUsed = false;
            });
            return;
        }
        if (type == TaskTypes.HARD) {
            if (!Main.livesManager.isOnLastLife(player, true)) {
                player.method_64398(class_2561.method_30163((String)"\u00a7cYou cannot re-roll a Hard task."));
            } else {
                player.method_64398(class_2561.method_30163((String)"\u00a7cYou cannot re-roll a Hard task. If you want your red task instead, click the Fail button."));
            }
        }
    }

    public static void failTask(class_3222 player, boolean fromCommand) {
        if (Main.server == null) {
            return;
        }
        if (!fromCommand) {
            if (!TaskManager.hasSessionStarted(player)) {
                return;
            }
            if (TaskManager.isBeingUsed(player)) {
                return;
            }
        }
        SecretLife season = (SecretLife)Main.currentSeason;
        TaskTypes type = TaskManager.getPlayersTaskType(player);
        if (!TaskManager.hasTaskBookCheck(player, !fromCommand)) {
            return;
        }
        if (BROADCAST_SECRET_KEEPER) {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a7c failed their task.", player));
        }
        if (PUBLIC_TASKS_ON_SUBMIT) {
            TaskManager.sendPublicTaskMessage(player);
        }
        SessionTranscript.failTask(player);
        TaskManager.removePlayersTaskBook(player);
        submittedOrFailed.add(player.method_5667());
        secretKeeperBeingUsed = true;
        class_243 centerPos = itemSpawnerPos.method_46558();
        AnimationUtils.createGlyphAnimation(Main.server.method_30002(), centerPos, 40);
        Main.server.method_30002().method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3414.method_47908((class_2960)class_2960.method_60655((String)"minecraft", (String)"secretlife_task")), class_3419.field_15248, 1.0f, 1.0f);
        TaskScheduler.scheduleTask(60, () -> {
            Main.server.method_30002().method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_47206, class_3419.field_15248, 1.0f, 1.0f);
            AnimationUtils.spawnFireworkBall(Main.server.method_30002(), centerPos, 40, 0.3, new Vector3f(1.0f, 0.0f, 0.0f));
            if (type == TaskTypes.EASY) {
                TaskManager.showHeartTitle(player, EASY_FAIL);
                season.removePlayerHealth(player, -EASY_FAIL);
            }
            if (type == TaskTypes.HARD) {
                TaskManager.showHeartTitle(player, HARD_FAIL);
                season.removePlayerHealth(player, -HARD_FAIL);
            }
            if (type == TaskTypes.RED) {
                TaskManager.showHeartTitle(player, RED_FAIL);
                season.removePlayerHealth(player, -RED_FAIL);
            }
            if (!Main.livesManager.isOnLastLife(player, false)) {
                secretKeeperBeingUsed = false;
            }
        });
        TaskManager.chooseNewTaskForPlayerIfNecessary(player);
    }

    public static void chooseNewTaskForPlayerIfNecessary(class_3222 player) {
        if (Main.livesManager.isOnLastLife(player, false) || CONSTANT_TASKS) {
            TaskScheduler.scheduleTask(120, () -> {
                TaskTypes newType = Main.livesManager.isOnLastLife(player, false) ? TaskTypes.RED : TaskTypes.EASY;
                TaskManager.chooseTasks(List.of(player), newType);
            });
        }
    }

    public static void showHeartTitle(class_3222 player, int amount) {
        double finalHearts;
        if (amount == 0) {
            return;
        }
        SecretLife season = (SecretLife)Main.currentSeason;
        if (amount > 0 && season.getPlayerHealth(player) >= SecretLife.MAX_HEALTH) {
            return;
        }
        int healthBefore = class_3532.method_15384((double)season.getPlayerHealth(player));
        int finalAmount = amount;
        if (healthBefore + amount <= 0) {
            finalAmount = -healthBefore + 1;
            if (healthBefore == 1) {
                finalAmount = 0;
            }
        }
        if ((double)(healthBefore + amount) > SecretLife.MAX_HEALTH) {
            finalAmount = amount > 0 ? (int)(SecretLife.MAX_HEALTH - (double)healthBefore) : amount;
        }
        if ((finalHearts = (double)finalAmount / 2.0) == 0.0) {
            return;
        }
        Object finalStr = String.valueOf(finalHearts);
        if (finalAmount % 2 == 0) {
            finalStr = String.valueOf((int)finalHearts);
        }
        class_124 formatting = class_124.field_1060;
        if (finalAmount < 0) {
            formatting = class_124.field_1061;
        } else {
            finalStr = "+" + (String)finalStr;
        }
        PlayerUtils.sendTitle(player, (class_2561)TextUtils.format("{} Hearts", finalStr).method_27692(formatting), 20, 40, 20);
    }

    public static boolean alreadyHasPos(class_2338 pos) {
        if (successButtonPos != null && successButtonPos.equals((Object)pos)) {
            return true;
        }
        if (rerollButtonPos != null && rerollButtonPos.equals((Object)pos)) {
            return true;
        }
        if (failButtonPos != null && failButtonPos.equals((Object)pos)) {
            return true;
        }
        return itemSpawnerPos != null && itemSpawnerPos.equals((Object)pos);
    }

    public static void positionFound(class_2338 pos, boolean fromButton) {
        if (pos == null) {
            return;
        }
        if (TaskManager.alreadyHasPos(pos)) {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7c[SecretLife setup] This location is already being used."), 20);
            return;
        }
        if (successButtonPos == null && fromButton) {
            successButtonPos = pos;
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7a[SecretLife setup 1/4] Location set.\n"));
        } else if (rerollButtonPos == null && fromButton) {
            rerollButtonPos = pos;
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7a[SecretLife setup 2/4] Location set.\n"));
        } else if (failButtonPos == null && fromButton) {
            failButtonPos = pos;
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7a[SecretLife setup 3/4] Location set.\n"));
        }
        if (itemSpawnerPos == null && !fromButton && successButtonPos != null && rerollButtonPos != null && failButtonPos != null) {
            itemSpawnerPos = pos;
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7a[SecretLife] All locations have been set. If you wish to change them in the future, use \u00a72'/secretlife changeLocations'\n"));
            PlayerUtils.broadcastMessage(class_2561.method_30163((String)"\nUse \u00a7b'/session timer set <time>'\u00a7f to set the desired session time."));
            PlayerUtils.broadcastMessage(class_2561.method_30163((String)"After that, use \u00a7b'/session start'\u00a7f to start the session."));
        }
        locationsConfig.saveLocations();
        TaskManager.checkSecretLifePositions();
    }

    public static boolean checkSecretLifePositions() {
        if (successButtonPos == null) {
            PlayerUtils.broadcastMessageToAdmins((class_2561)class_2561.method_43470((String)"\u00a7c[SecretLife setup 1/4] Location for the secret keeper task \u00a76\u00a7lSUCCESS BUTTON\u00a7r\u00a7c was not found. \u00a7nThe next button you click will be set as the location."));
            searchingForLocations = true;
            return false;
        }
        if (rerollButtonPos == null) {
            PlayerUtils.broadcastMessageToAdmins((class_2561)class_2561.method_43470((String)"\u00a7c[SecretLife setup 2/4] Location for the secret keeper task \u00a76\u00a7lRE-ROLL BUTTON\u00a7r\u00a7c was not found. \u00a7nThe next button you click will be set as the location."));
            searchingForLocations = true;
            return false;
        }
        if (failButtonPos == null) {
            PlayerUtils.broadcastMessageToAdmins((class_2561)class_2561.method_43470((String)"\u00a7c[SecretLife setup 3/4] Location for the secret keeper task \u00a76\u00a7lFAIL BUTTON\u00a7r\u00a7c was not found. \u00a7nThe next button you click will be set as the location."));
            searchingForLocations = true;
            return false;
        }
        if (itemSpawnerPos == null) {
            PlayerUtils.broadcastMessageToAdmins((class_2561)class_2561.method_43470((String)"\u00a7c[SecretLife setup 4/4] Location for the secret keeper task \u00a76\u00a7lITEM SPAWN BLOCK\u00a7r\u00a7c was not found. \u00a7nPlease place a bedrock block at the desired spot to mark it."));
            searchingForLocations = true;
            return false;
        }
        searchingForLocations = false;
        return true;
    }

    public static void onBlockUse(class_3222 player, class_3218 world, class_3965 hitResult) {
        class_2338 pos = hitResult.method_17777();
        String name = world.method_8320(pos).method_26204().method_9518().getString().toLowerCase();
        if (name.contains("button")) {
            if (searchingForLocations) {
                TaskManager.positionFound(pos, true);
            } else if (pos.equals((Object)successButtonPos)) {
                TaskManager.succeedTask(player, false);
            } else if (pos.equals((Object)rerollButtonPos)) {
                TaskManager.rerollTask(player, false);
            } else if (pos.equals((Object)failButtonPos)) {
                TaskManager.failTask(player, false);
            }
        }
        if (!searchingForLocations) {
            return;
        }
        if (successButtonPos == null || rerollButtonPos == null || failButtonPos == null) {
            return;
        }
        class_2338 placePos = pos.method_10093(hitResult.method_17780());
        TaskScheduler.scheduleTask(1, () -> {
            String name2 = world.method_8320(placePos).method_26204().method_9518().getString().toLowerCase();
            if (name2.contains("bedrock")) {
                TaskManager.positionFound(placePos, false);
                world.method_22352(placePos, false);
            }
        });
    }

    public static void tick() {
        secretKeeperBeingUsedFor = secretKeeperBeingUsed ? ++secretKeeperBeingUsedFor : 0;
        if (secretKeeperBeingUsedFor > 500) {
            secretKeeperBeingUsed = false;
            secretKeeperBeingUsedFor = 0;
            Main.LOGGER.error("Resetting Secret Keeper.");
        }
    }

    static {
        tasksChosen = false;
        tasksChosenFor = new ArrayList<UUID>();
        submittedOrFailed = new ArrayList<UUID>();
        secretKeeperBeingUsed = false;
        secretKeeperBeingUsedFor = 0;
        preAssignedTasks = new HashMap<UUID, Task>();
        assignedTasks = new HashMap<UUID, Task>();
        rnd = new Random();
        searchingForLocations = false;
    }
}

