/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config;

import java.util.List;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.ConfigScreen;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4280;

@Environment(value=EnvType.CLIENT)
public class ConfigListWidget
extends class_4280<ConfigEntryWidget> {
    public static final int ENTRY_GAP = 2;
    private static final int MAX_HIGHLIGHTED_ENTRIES = 3;
    private static final int SCROLLBAR_OFFSET_X = 6;
    protected ConfigScreen screen;

    public ConfigListWidget(class_310 client, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
    }

    public void setScreen(ConfigScreen screen) {
        this.screen = screen;
    }

    public void addEntry(ConfigEntry configEntry) {
        this.method_25321((class_350.class_351)new ConfigEntryWidget(configEntry));
    }

    public void clearAllEntries() {
        this.method_25339();
    }

    public int method_25322() {
        return this.field_22758 - 20;
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
        int maxScroll = this.method_25331();
        if (this.getScrolledAmount() > (double)maxScroll) {
            this.method_25307(maxScroll);
        }
        int listLeft = this.method_46426();
        int listTop = this.method_46427();
        int listRight = listLeft + this.field_22758;
        int listBottom = listTop + this.field_22759;
        context.method_25294(listLeft, listTop, listRight, listBottom, TextColors.BLACK_A32);
        int currentY = this.getCurrentY();
        TreeMap<Float, ConfigEntry> highlightedEntries = new TreeMap<Float, ConfigEntry>();
        for (int i = 0; i < this.method_25340(); ++i) {
            ConfigEntryWidget entry = (ConfigEntryWidget)this.method_25326(i);
            ConfigEntry configEntry = entry.getConfigEntry();
            int entryHeight = configEntry.getPreferredHeight();
            if (currentY + entryHeight >= listTop && currentY < listBottom) {
                int entryWidth = this.method_25322();
                int entryLeft = listLeft + (this.field_22758 - entryWidth) / 2;
                boolean hovered = mouseX >= entryLeft && mouseX < entryLeft + entryWidth && mouseY >= currentY && mouseY < currentY + entryHeight;
                entry.method_25343(context, i, currentY, entryLeft, entryWidth, entryHeight, mouseX, mouseY, hovered, delta);
                List<Object> withChildren = List.of(configEntry);
                if (this.screen != null && !(withChildren = this.screen.getAllEntries(withChildren)).contains(configEntry)) {
                    withChildren.add(configEntry);
                }
                for (ConfigEntry configEntry2 : withChildren) {
                    if (!(configEntry2.highlightAlpha > 0.0f)) continue;
                    highlightedEntries.put(Float.valueOf(configEntry2.highlightAlpha), configEntry2);
                }
            }
            currentY += entryHeight + 2;
        }
        int highlightedCount = highlightedEntries.size();
        if (highlightedCount > 3) {
            int pos = 0;
            for (ConfigEntry entry : highlightedEntries.values()) {
                if (pos >= 3) break;
                entry.highlightAlpha = 0.0f;
                ++pos;
            }
        }
        if (maxScroll > 0) {
            int scrollbarX = listRight - 6;
            int scrollbarTop = listTop;
            int scrollbarBottom = listBottom;
            int scrollbarHeight = scrollbarBottom - scrollbarTop;
            context.method_25294(scrollbarX, scrollbarTop, scrollbarX + 6, scrollbarBottom, TextColors.BLACK_A64);
            int handleHeight = Math.max(10, scrollbarHeight * scrollbarHeight / (scrollbarHeight + maxScroll));
            int handleY = scrollbarTop + (int)((double)(scrollbarHeight - handleHeight) * this.getScrolledAmount() / (double)maxScroll);
            context.method_25294(scrollbarX + 1, handleY, scrollbarX + 6 - 1, handleY + handleHeight, TextColors.WHITE_A128);
        }
    }

    public int method_25331() {
        int totalHeight = 0;
        for (int i = 0; i < this.method_25340(); ++i) {
            totalHeight += ((ConfigEntryWidget)this.method_25326(i)).getConfigEntry().getPreferredHeight();
        }
        return Math.max(0, totalHeight - this.field_22759 + 8);
    }

    protected boolean method_57717() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        int listTop = this.method_46427();
        int currentY = this.getCurrentY();
        for (int i = 0; i < this.method_25340(); ++i) {
            ConfigEntryWidget entry = (ConfigEntryWidget)this.method_25326(i);
            int entryHeight = entry.getConfigEntry().getPreferredHeight() + 2;
            if (mouseY >= (double)currentY && mouseY < (double)(currentY + entryHeight)) {
                this.method_25395((class_364)entry);
                entry.getConfigEntry().setFocused(true);
                return entry.method_25402(mouseX, mouseY, button);
            }
            currentY += entryHeight;
        }
        return false;
    }

    public double getScrolledAmount() {
        return this.method_25341();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        ConfigEntryWidget entry = (ConfigEntryWidget)this.method_25336();
        if (entry == null) {
            return false;
        }
        return entry.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        ConfigEntryWidget entry = (ConfigEntryWidget)this.method_25336();
        if (entry == null) {
            return false;
        }
        return entry.method_25400(chr, modifiers);
    }

    public int getCurrentY() {
        return this.method_46427() + 4 - (int)this.getScrolledAmount();
    }

    public int method_25340() {
        return this.method_25396().size();
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigEntryWidget
    extends class_4280.class_4281<ConfigEntryWidget> {
        private final ConfigEntry configEntry;

        public ConfigEntryWidget(ConfigEntry configEntry) {
            this.configEntry = configEntry;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.configEntry.render(context, x, y, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.configEntry.setFocused(true);
            return this.configEntry.mouseClicked(mouseX, mouseY, button);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            this.configEntry.setFocused(true);
            return this.configEntry.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            this.configEntry.setFocused(true);
            return this.configEntry.charTyped(chr, modifiers);
        }

        public class_2561 method_37006() {
            return this.configEntry.getDisplayName();
        }

        public ConfigEntry getConfigEntry() {
            return this.configEntry;
        }
    }
}

