/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season;

import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.dependencies.DependencyManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.aprilfools.reallife.RealLife;
import net.mat0u5.lifeseries.seasons.season.aprilfools.simplelife.SimpleLife;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLife;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.seasons.season.pastlife.PastLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.thirdlife.ThirdLife;
import net.mat0u5.lifeseries.seasons.season.unassigned.UnassignedSeason;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.minecraft.class_2960;

public enum Seasons {
    UNASSIGNED("Unassigned", "unassigned"),
    THIRD_LIFE("Third Life", "thirdlife"),
    LAST_LIFE("Last Life", "lastlife"),
    DOUBLE_LIFE("Double Life", "doublelife"),
    LIMITED_LIFE("Limited Life", "limitedlife"),
    SECRET_LIFE("Secret Life", "secretlife"),
    WILD_LIFE("Wild Life", "wildlife"),
    PAST_LIFE("Past Life", "pastlife"),
    REAL_LIFE("Real Life", "reallife"),
    SIMPLE_LIFE("Simple Life", "simplelife");

    private String name;
    private String id;

    private Seasons(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Season getSeasonInstance() {
        if (this == THIRD_LIFE) {
            return new ThirdLife();
        }
        if (this == LAST_LIFE) {
            return new LastLife();
        }
        if (this == DOUBLE_LIFE) {
            return new DoubleLife();
        }
        if (this == LIMITED_LIFE) {
            return new LimitedLife();
        }
        if (this == SECRET_LIFE) {
            return new SecretLife();
        }
        if (this == WILD_LIFE && DependencyManager.wildLifeModsLoaded()) {
            return new WildLife();
        }
        if (this == PAST_LIFE) {
            return new PastLife();
        }
        if (this == REAL_LIFE) {
            return new RealLife();
        }
        if (this == SIMPLE_LIFE) {
            return new SimpleLife();
        }
        return new UnassignedSeason();
    }

    public class_2960 getLogo() {
        return class_2960.method_60655((String)"lifeseries", (String)("textures/gui/" + this.getId() + ".png"));
    }

    public static Seasons getSeasonFromStringName(String name) {
        for (Seasons season : Seasons.values()) {
            if (!season.getName().equalsIgnoreCase(name) && !season.getId().equalsIgnoreCase(name)) continue;
            return season;
        }
        return UNASSIGNED;
    }

    public static List<Seasons> getSeasons() {
        ArrayList<Seasons> allSeasons = new ArrayList<Seasons>(List.of(Seasons.values()));
        allSeasons.remove((Object)UNASSIGNED);
        return allSeasons;
    }

    public static List<Seasons> getAprilFoolsSeasons() {
        return new ArrayList<Seasons>(List.of(REAL_LIFE, SIMPLE_LIFE));
    }

    public static List<String> getSeasonIds() {
        ArrayList<String> seasonNames = new ArrayList<String>();
        for (Seasons season : Seasons.getSeasons()) {
            seasonNames.add(season.getId());
        }
        return seasonNames;
    }
}

