/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.secretsociety;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.secretsociety.SecretSociety;
import net.mat0u5.lifeseries.seasons.secretsociety.SocietyMember;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SocietyCommands
extends Command {
    public SecretSociety get() {
        return Main.currentSeason.secretSociety;
    }

    @Override
    public boolean isAllowed() {
        return this.get().SOCIETY_ENABLED;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when the Secret Society is enabled in the config.");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)SocietyCommands.literal("initiate").executes(context -> this.initiate((class_2168)context.getSource())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SocietyCommands.literal("society").then(((LiteralArgumentBuilder)SocietyCommands.literal("success").executes(context -> this.societySuccess((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)SocietyCommands.literal("confirm").requires(PermissionManager::isAdmin)).executes(context -> this.societySuccessConfirm((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)SocietyCommands.literal("fail").executes(context -> this.societyFail((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)SocietyCommands.literal("confirm").requires(PermissionManager::isAdmin)).executes(context -> this.societyFailConfirm((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SocietyCommands.literal("begin").requires(PermissionManager::isAdmin)).then(SocietyCommands.argument("secret_word", StringArgumentType.string()).executes(context -> this.societyBegin((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"secret_word"))))).executes(context -> this.societyBegin((class_2168)context.getSource(), null)))).then(((LiteralArgumentBuilder)SocietyCommands.literal("end").requires(PermissionManager::isAdmin)).executes(context -> this.societyEnd((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SocietyCommands.literal("members").requires(PermissionManager::isAdmin)).then(SocietyCommands.literal("add").then(SocietyCommands.argument("player", class_2186.method_9305()).executes(context -> this.membersAdd((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(SocietyCommands.literal("remove").then(SocietyCommands.argument("player", class_2186.method_9305()).executes(context -> this.membersRemove((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(SocietyCommands.literal("list").executes(context -> this.membersList((class_2168)context.getSource())))));
    }

    public int membersRemove(class_2168 source, class_3222 target) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (!society.isMember(target)) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Member"));
            return -1;
        }
        society.removeMemberManually(target);
        return 1;
    }

    public int membersAdd(class_2168 source, class_3222 target) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        if (society.isMember(target)) {
            source.method_9213(class_2561.method_30163((String)"That player already a Member"));
            return -1;
        }
        society.addMemberManually(target);
        return 1;
    }

    public int membersList(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        if (society.members.isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"The are no Secret Society members"));
            return -1;
        }
        ArrayList<String> societyMembers = new ArrayList<String>();
        for (SocietyMember member : society.members) {
            class_3222 player = member.getPlayer();
            if (player == null) continue;
            societyMembers.add(player.method_5820());
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.formatLoosely("Secret Society Members: \u00a77{}", societyMembers));
        return 1;
    }

    public boolean checkSocietyRunning(class_2168 source) {
        SecretSociety society = this.get();
        if (society == null) {
            return false;
        }
        if (society.societyEnded) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has already ended"));
            if (PermissionManager.isAdmin(source)) {
                OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Use '/society begin' or '/society begin <secret_word>' to start."));
            }
            return true;
        }
        if (!society.societyStarted) {
            source.method_9213(class_2561.method_30163((String)"The Secret Society has not started yet"));
            if (PermissionManager.isAdmin(source)) {
                OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Use '/society begin' or '/society begin <secret_word>' to start."));
            }
            return true;
        }
        return false;
    }

    public int societyBegin(class_2168 source, String word) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Starting the Secret Society..."));
        society.startSociety(word);
        return 1;
    }

    public int societyEnd(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Ending the Secret Society..."));
        society.forceEndSociety();
        return 1;
    }

    public int societyFail(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        SocietyMember member = society.getMember(self);
        if (member == null) {
            source.method_9213(class_2561.method_30163((String)"You are not a member of the Secret Society"));
            if (PermissionManager.isAdmin(self)) {
                OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Use the \u00a7f\"/society fail \u00a7lconfirm\"\u00a7l\u00a77 command to bypass this"));
            }
            return -1;
        }
        if (!member.initiated) {
            source.method_9213(class_2561.method_30163((String)"You have not been initiated"));
            return -1;
        }
        society.endFail();
        SessionTranscript.societyEndFail(self);
        return 1;
    }

    public int societyFailConfirm(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        society.endFail();
        SessionTranscript.societyEndFail(self);
        return 1;
    }

    public int societySuccess(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        SocietyMember member = society.getMember(self);
        if (member == null) {
            source.method_9213(class_2561.method_30163((String)"You are not a member of the Secret Society"));
            if (PermissionManager.isAdmin(self)) {
                OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Use the \u00a7f\"/society success \u00a7lconfirm\"\u00a7l\u00a77 command to bypass this"));
            }
            return -1;
        }
        if (!member.initiated) {
            source.method_9213(class_2561.method_30163((String)"You have not been initiated"));
            return -1;
        }
        society.endSuccess();
        SessionTranscript.societyEndSuccess(self);
        return 1;
    }

    public int societySuccessConfirm(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        society.endSuccess();
        SessionTranscript.societyEndSuccess(self);
        return 1;
    }

    public int initiate(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SecretSociety society = this.get();
        if (society == null) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (this.checkSocietyRunning(source)) {
            return -1;
        }
        SocietyMember member = society.getMember(self);
        if (member == null) {
            source.method_9213(class_2561.method_30163((String)"You are not a member of the Secret Society"));
            return -1;
        }
        if (member.initiated) {
            source.method_9213(class_2561.method_30163((String)"You have already been initiated"));
            return -1;
        }
        society.initiateMember(self);
        return 1;
    }
}

