/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.extra;

import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.BooleanConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.DoubleConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.IntegerConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.main.StringConfigEntry;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class BoogeymanConfigEntry
extends BooleanConfigEntry {
    private static final int DESCRIPTION_OFFSET_X = 35;
    private static final int DESCRIPTION_OFFSET_Y = 26;
    private Double boogeymanMultiplier = null;
    private Integer boogeymanMin = null;
    private Integer boogeymanMax = null;
    private String[] boogeymanIgnore = null;
    private String[] boogeymanForce = null;

    public BoogeymanConfigEntry(String fieldName, String displayName, String description, boolean value, boolean defaultValue) {
        super(fieldName, displayName, description, value, defaultValue);
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        String line;
        super.renderEntry(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
        if (this.parentGroup == null || !this.showBoogeymanInfoText()) {
            return;
        }
        this.updateBoogeyDescription();
        if (this.boogeymanMin == null || this.boogeymanMax == null || this.boogeymanIgnore == null || this.boogeymanForce == null || this.boogeymanMultiplier == null) {
            return;
        }
        ArrayList<String> boogeymanDescription = new ArrayList<String>();
        boogeymanDescription.add("\u00a7nCurrent Boogeyman Settings:\u00a7r");
        if (this.boogeymanIgnore.length > 0) {
            line = TextUtils.formatString("{} \u00a7f{}\u00a7r cannot become the boogeyman.", TextUtils.pluralize("Player", this.boogeymanIgnore.length), String.join((CharSequence)"\u00a7r, \u00a7f", this.boogeymanIgnore));
            boogeymanDescription.add(line);
        }
        if (this.boogeymanForce.length > 0) {
            line = TextUtils.formatString("{} \u00a7f{}\u00a7r will be forced to become the Boogeyman.", TextUtils.pluralize("Player", this.boogeymanForce.length), String.join((CharSequence)"\u00a7r, \u00a7f", this.boogeymanForce));
            boogeymanDescription.add(line);
        }
        boogeymanDescription.add("");
        double currentChance = 1.0;
        int offset = Math.max(1, this.boogeymanMin - 1);
        for (int i = 0; i < 5; ++i) {
            int boogeyNum = i + offset;
            if (boogeyNum > this.boogeymanMin) {
                currentChance *= this.boogeymanMultiplier.doubleValue();
            }
            if (boogeyNum > this.boogeymanMax) {
                currentChance = 0.0;
            }
            boogeymanDescription.add(TextUtils.formatString("Chance for at least {} {}: {}", boogeyNum, TextUtils.pluralize("Boogeyman", "Boogeymen", boogeyNum), String.format("%.1f%%", currentChance * 100.0)));
        }
        int currentY = y + 26;
        for (String line2 : boogeymanDescription) {
            RenderUtils.drawTextLeft(context, this.textRenderer, TextColors.LIGHT_GRAY, (class_2561)class_2561.method_43470((String)line2), x + 35, currentY);
            Objects.requireNonNull(this.textRenderer);
            currentY += 9;
        }
    }

    private void updateBoogeyDescription() {
        String boogeymanIgnoreRaw = null;
        String boogeymanForceRaw = null;
        for (ConfigEntry entry : this.parentGroup.getChildEntries()) {
            DoubleConfigEntry doubleConfigEntry;
            if (entry instanceof IntegerConfigEntry) {
                IntegerConfigEntry integerConfigEntry = (IntegerConfigEntry)entry;
                if (integerConfigEntry.getFieldName().equalsIgnoreCase("boogeyman_min_amount")) {
                    this.boogeymanMin = (Integer)integerConfigEntry.getValue();
                }
                if (integerConfigEntry.getFieldName().equalsIgnoreCase("boogeyman_max_amount")) {
                    this.boogeymanMax = (Integer)integerConfigEntry.getValue();
                }
            }
            if (entry instanceof StringConfigEntry) {
                StringConfigEntry stringConfigEntry = (StringConfigEntry)entry;
                if (stringConfigEntry.getFieldName().equalsIgnoreCase("boogeyman_ignore")) {
                    boogeymanIgnoreRaw = stringConfigEntry.getValue();
                }
                if (stringConfigEntry.getFieldName().equalsIgnoreCase("boogeyman_force")) {
                    boogeymanForceRaw = stringConfigEntry.getValue();
                }
            }
            if (!(entry instanceof DoubleConfigEntry) || !(doubleConfigEntry = (DoubleConfigEntry)entry).getFieldName().equalsIgnoreCase("boogeyman_chance_multiplier")) continue;
            this.boogeymanMultiplier = (Double)doubleConfigEntry.getValue();
        }
        if (boogeymanIgnoreRaw == null || boogeymanForceRaw == null) {
            return;
        }
        boogeymanIgnoreRaw = boogeymanIgnoreRaw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim();
        boogeymanForceRaw = boogeymanForceRaw.replaceAll("\\[", "").replaceAll("]", "").replaceAll(" ", "").trim();
        this.boogeymanIgnore = !boogeymanIgnoreRaw.isEmpty() ? boogeymanIgnoreRaw.split(",") : new String[0];
        this.boogeymanForce = !boogeymanForceRaw.isEmpty() ? boogeymanForceRaw.split(",") : new String[0];
    }

    @Override
    public int getPreferredHeight() {
        int initial = super.getPreferredHeight();
        if (this.showBoogeymanInfoText()) {
            int lines = 9;
            Objects.requireNonNull(this.textRenderer);
            return initial + 9 * lines + 6;
        }
        return initial;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.BOOGEYMAN;
    }

    public boolean showBoogeymanInfoText() {
        return this.clicked;
    }
}

