/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.doublelife;

import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.minecraft.class_3222;

public class DoubleLifeBoogeymanManager
extends BoogeymanManager {
    public boolean skipNextInfiniteCall = false;

    @Override
    public boolean isBoogeymanThatCanBeCured(class_3222 player, class_3222 victim) {
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            class_3222 soulmate;
            DoubleLife doubleLife = (DoubleLife)season;
            if (DoubleLife.SOULBOUND_BOOGEYMAN && (soulmate = doubleLife.getSoulmate(player)) != null && soulmate == victim) {
                return false;
            }
        }
        return super.isBoogeymanThatCanBeCured(player, victim);
    }

    @Override
    public void addBoogeymanManually(class_3222 player) {
        super.addBoogeymanManually(player);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            class_3222 soulmate;
            DoubleLife doubleLife = (DoubleLife)season;
            if (DoubleLife.SOULBOUND_BOOGEYMAN && (soulmate = doubleLife.getSoulmate(player)) != null) {
                super.addBoogeymanManually(soulmate);
            }
        }
    }

    @Override
    public void removeBoogeymanManually(class_3222 player) {
        super.removeBoogeymanManually(player);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            class_3222 soulmate;
            DoubleLife doubleLife = (DoubleLife)season;
            if (DoubleLife.SOULBOUND_BOOGEYMAN && (soulmate = doubleLife.getSoulmate(player)) != null) {
                super.removeBoogeymanManually(soulmate);
            }
        }
    }

    @Override
    public void cure(class_3222 player) {
        super.cure(player);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            class_3222 soulmate;
            DoubleLife doubleLife = (DoubleLife)season;
            if (DoubleLife.SOULBOUND_BOOGEYMAN && (soulmate = doubleLife.getSoulmate(player)) != null) {
                super.cure(soulmate);
            }
        }
    }

    @Override
    public void playerFailBoogeymanManually(class_3222 player, boolean sendMessage) {
        super.playerFailBoogeymanManually(player, sendMessage);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            class_3222 soulmate;
            DoubleLife doubleLife = (DoubleLife)season;
            if (DoubleLife.SOULBOUND_BOOGEYMAN && (soulmate = doubleLife.getSoulmate(player)) != null) {
                super.playerFailBoogeymanManually(soulmate, sendMessage);
            }
        }
    }

    @Override
    public void chooseNewBoogeyman() {
        if (!DoubleLife.SOULBOUND_BOOGEYMAN || !this.skipNextInfiniteCall) {
            super.chooseNewBoogeyman();
            return;
        }
        this.skipNextInfiniteCall = true;
        TaskScheduler.scheduleTask(1, () -> {
            this.skipNextInfiniteCall = false;
        });
    }

    @Override
    public boolean playerFailBoogeyman(class_3222 player, boolean sendMessage) {
        boolean returnValue = super.playerFailBoogeyman(player, sendMessage);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.syncSoulboundLives(player);
        }
        return returnValue;
    }

    @Override
    public void handleBoogeymanLists(List<class_3222> normalPlayers, List<class_3222> boogeyPlayers) {
        Season season;
        if (!DoubleLife.SOULBOUND_BOOGEYMAN || !((season = Main.currentSeason) instanceof DoubleLife)) {
            super.handleBoogeymanLists(normalPlayers, boogeyPlayers);
            return;
        }
        DoubleLife doubleLife = (DoubleLife)season;
        ArrayList<class_3222> newNormalPlayers = new ArrayList<class_3222>();
        ArrayList<class_3222> newBoogeyPlayers = new ArrayList<class_3222>(boogeyPlayers);
        for (class_3222 normalPlayer : normalPlayers) {
            class_3222 soulmate = doubleLife.getSoulmate(normalPlayer);
            if (soulmate == null || newBoogeyPlayers.contains(normalPlayer)) {
                newNormalPlayers.add(normalPlayer);
                continue;
            }
            if (newBoogeyPlayers.contains(soulmate)) {
                newBoogeyPlayers.add(normalPlayer);
                continue;
            }
            newNormalPlayers.add(normalPlayer);
        }
        super.handleBoogeymanLists(newNormalPlayers, newBoogeyPlayers);
    }
}

