/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SessionCommand
extends Command {
    public static final String INVALID_TIME_FORMAT_ERROR = "Invalid time format. Use h, m, s for hours, minutes, and seconds.";

    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when you have selected a Season.");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SessionCommand.literal("session").then(((LiteralArgumentBuilder)SessionCommand.literal("start").requires(PermissionManager::isAdmin)).executes(context -> this.startSession((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)SessionCommand.literal("stop").requires(PermissionManager::isAdmin)).executes(context -> this.stopSession((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)SessionCommand.literal("pause").requires(PermissionManager::isAdmin)).executes(context -> this.pauseSession((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)SessionCommand.literal("timer").then(((LiteralArgumentBuilder)SessionCommand.literal("set").requires(PermissionManager::isAdmin)).then(SessionCommand.argument("time", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("1h", "1h30m", "2h"), (SuggestionsBuilder)builder)).executes(context -> this.setTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)SessionCommand.literal("add").requires(PermissionManager::isAdmin)).then(SessionCommand.argument("time", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("30m", "1h"), (SuggestionsBuilder)builder)).executes(context -> this.addTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)SessionCommand.literal("fastforward").requires(PermissionManager::isAdmin)).then(SessionCommand.argument("time", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("5m"), (SuggestionsBuilder)builder)).executes(context -> this.skipTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)SessionCommand.literal("remove").requires(PermissionManager::isAdmin)).then(SessionCommand.argument("time", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(List.of("5m"), (SuggestionsBuilder)builder)).executes(context -> this.removeTime((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"time")))))).then(SessionCommand.literal("remaining").executes(context -> this.getTime((class_2168)context.getSource())))).then(SessionCommand.literal("showDisplay").executes(context -> this.displayTimer((class_2168)context.getSource())))));
    }

    public int getTime(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.validTime()) {
            source.method_9213(class_2561.method_30163((String)"The session time has not been set yet"));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("The session ends in {}", Main.currentSession.getRemainingTimeStr()));
        return 1;
    }

    public int displayTimer(class_2168 source) {
        boolean isInDisplayTimer;
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (NetworkHandlerServer.wasHandshakeSuccessful(self)) {
            NetworkHandlerServer.sendStringPacket(self, PacketNames.TOGGLE_TIMER, "");
        }
        if (isInDisplayTimer = Main.currentSession.isInDisplayTimer(self)) {
            Main.currentSession.removeFromDisplayTimer(self);
        } else {
            Main.currentSession.addToDisplayTimer(self);
        }
        return 1;
    }

    public int startSession(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!Main.currentSession.validTime()) {
            source.method_9213(class_2561.method_30163((String)"The session time is not set! Use '/session timer set <time>' to set the session time."));
            return -1;
        }
        if (Main.currentSession.statusStarted()) {
            source.method_9213(class_2561.method_30163((String)"The session has already started"));
            return -1;
        }
        if (Main.currentSession.statusPaused()) {
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Unpausing session..."));
            Main.currentSession.sessionPause();
            return 1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Starting session..."));
        if (!Main.currentSession.sessionStart()) {
            source.method_9213(class_2561.method_30163((String)"Could not start session"));
            return -1;
        }
        return 1;
    }

    public int stopSession(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            source.method_9213(class_2561.method_30163((String)"The session has not yet started"));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Stopping session..."));
        Main.currentSession.sessionEnd();
        return 1;
    }

    public int pauseSession(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            source.method_9213(class_2561.method_30163((String)"The session has not yet started"));
            return -1;
        }
        if (Main.currentSession.statusPaused()) {
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Unpausing session..."));
        } else {
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Pausing session..."));
        }
        Main.currentSession.sessionPause();
        return 1;
    }

    public int skipTime(class_2168 source, String timeArgument) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Skipped {} in the session length", OtherUtils.formatTime(totalTicks)));
        Main.currentSession.passedTime += (double)totalTicks.intValue();
        return 1;
    }

    public int setTime(class_2168 source, String timeArgument) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        Main.currentSession.setSessionLength(totalTicks);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("The session length has been set to {}", OtherUtils.formatTime(totalTicks)));
        return 1;
    }

    public int addTime(class_2168 source, String timeArgument) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        Main.currentSession.addSessionLength(totalTicks);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Added {} to the session length", OtherUtils.formatTime(totalTicks)));
        return 1;
    }

    public int removeTime(class_2168 source, String timeArgument) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Integer totalTicks = OtherUtils.parseTimeFromArgument(timeArgument);
        if (totalTicks == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)INVALID_TIME_FORMAT_ERROR));
            return -1;
        }
        Main.currentSession.removeSessionLength(totalTicks);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Removed {} from the session length", OtherUtils.formatTime(totalTicks)));
        return 1;
    }
}

