/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.snail.goal;

import net.mat0u5.lifeseries.entity.snail.Snail;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public final class SnailJumpAttackPlayerGoal
extends class_1352 {
    @NotNull
    private final Snail mob;
    @NotNull
    private class_243 previousTargetPosition = class_243.field_1353;
    private int attackCooldown = 10;
    private int attackCooldown2 = 0;

    public SnailJumpAttackPlayerGoal(@NotNull Snail mob) {
        this.mob = mob;
    }

    public boolean method_6264() {
        if (this.mob.method_73183().method_8608()) {
            return false;
        }
        if (!this.mob.serverData.shouldPathfind()) {
            return false;
        }
        if (this.mob.isPaused()) {
            return false;
        }
        if (this.mob.serverData.dontAttackFor > 0) {
            return false;
        }
        if (this.mob.isSnailGliding() || this.mob.isSnailMining()) {
            return false;
        }
        class_1309 boundEntity = this.mob.serverData.getBoundEntity();
        if (boundEntity == null) {
            return false;
        }
        if (this.mob.isSnailAttacking()) {
            return true;
        }
        double distanceToTarget = this.mob.method_5858((class_1297)boundEntity);
        if (distanceToTarget > (double)this.mob.serverData.getJumpRangeSquared()) {
            return false;
        }
        return this.mob.method_6057((class_1297)boundEntity);
    }

    public boolean method_6266() {
        if (!this.mob.serverData.shouldPathfind()) {
            return false;
        }
        if (this.attackCooldown2 > 0) {
            --this.attackCooldown2;
            return false;
        }
        if (this.attackCooldown <= 4) {
            return true;
        }
        class_1309 boundEntity = this.mob.serverData.getBoundEntity();
        if (boundEntity == null) {
            return false;
        }
        if (this.mob.method_5858((class_1297)boundEntity) > (double)this.mob.serverData.getJumpRangeSquared()) {
            return false;
        }
        return this.mob.method_6057((class_1297)boundEntity);
    }

    public void method_6269() {
        class_1309 boundEntity = this.mob.serverData.getBoundEntity();
        if (boundEntity != null) {
            this.previousTargetPosition = boundEntity.method_73189();
        }
        this.attackCooldown = 10;
        this.mob.setSnailAttacking(true);
    }

    public void method_6270() {
        this.attackCooldown = 10;
        this.previousTargetPosition = class_243.field_1353;
        this.mob.setSnailAttacking(false);
    }

    public void method_6268() {
        if (this.attackCooldown2 > 0) {
            --this.attackCooldown2;
            return;
        }
        class_1309 boundEntity = this.mob.serverData.getBoundEntity();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.attackCooldown == 4) {
            this.mob.sounds.playAttackSound();
        }
        if (this.attackCooldown <= 0) {
            this.jumpAttackPlayer();
        }
        if (boundEntity != null) {
            this.previousTargetPosition = boundEntity.method_73189();
            this.mob.method_5951((class_1297)boundEntity, 15.0f, 15.0f);
        }
    }

    private void jumpAttackPlayer() {
        class_1309 boundEntity = this.mob.serverData.getBoundEntity();
        if (boundEntity == null) {
            return;
        }
        this.attackCooldown = 10;
        this.attackCooldown2 = 30;
        class_243 mobVelocity = this.mob.method_18798();
        class_243 relativeTargetPos = new class_243(this.previousTargetPosition.method_10216() - this.mob.method_23317(), this.previousTargetPosition.method_10214() - this.mob.method_23318(), this.previousTargetPosition.method_10215() - this.mob.method_23321());
        if (boundEntity.method_59922().method_43048(3) == 0) {
            relativeTargetPos = new class_243(boundEntity.method_23317() - this.mob.method_23317(), boundEntity.method_23318() - this.mob.method_23318(), boundEntity.method_23321() - this.mob.method_23321());
        }
        if (boundEntity.method_59922().method_43048(6) == 0) {
            class_243 targetVelocity = boundEntity.method_73189().method_1020(this.previousTargetPosition);
            relativeTargetPos = relativeTargetPos.method_1019(targetVelocity.method_1021(3.0));
        }
        class_243 attackVector = mobVelocity;
        if (relativeTargetPos.method_1027() > 1.0E-4) {
            attackVector = relativeTargetPos.method_1029().method_1021(this.mob.serverData.isNerfed() ? 0.8 : 1.0);
        }
        if (this.mob.isSnailFlying()) {
            attackVector = attackVector.method_1021(0.5);
        }
        double addY = 0.5 + this.mob.method_5858((class_1297)boundEntity) / (double)this.mob.serverData.getJumpRangeSquared();
        this.mob.method_18800(attackVector.field_1352, attackVector.field_1351 + addY, attackVector.field_1350);
    }
}

