/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.session;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.secretlife.SecretLife;
import net.mat0u5.lifeseries.seasons.season.secretlife.Task;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SessionTranscript {
    public static final List<String> messages = new ArrayList<String>();
    public static Map<String, List<Integer>> playerRecords = new HashMap<String, List<Integer>>();

    public static void societyEndSuccess(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has marked the Secret Society as successful.", player));
    }

    public static void societyEndFail(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has marked the Secret Society as failed.", player));
    }

    public static void societyMemberInitiated(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has been initiated into the Secret Society.", player));
    }

    public static void societyMembersChosen(List<class_3222> players) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("Secret Society members chosen: {}", players));
    }

    public static void societyStarted() {
        SessionTranscript.addMessageWithTime("The Secret Society has started.");
    }

    public static void societyEnded() {
        SessionTranscript.addMessageWithTime("The Secret Society has ended.");
    }

    public static void logHealth(class_3222 player, double health) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} is now on {} health.", player, health));
    }

    public static void giftHeart(class_3222 player, class_3222 receiver) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} gifted a heart to {}.", player, receiver));
    }

    public static void newSuperpower(class_3222 player, Superpowers superpower) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has been assigned the {} superpower.", player, superpower.getString()));
    }

    public static void newTriviaBot(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("Spawned trivia bot for {}", player));
    }

    public static void endingIsYours() {
        SessionTranscript.addMessageWithTime("The ending is yours... Make it WILD.");
    }

    public static void newHungerRule() {
        SessionTranscript.addMessageWithTime("[Wildcard] Food has been randomized.");
    }

    public static void mobSwap() {
        SessionTranscript.addMessageWithTime("[Wildcard] Mobs have been swapped.");
    }

    public static void deactivateWildcard(Wildcards type) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("Deactivated Wildcard: {}", new Object[]{type}));
    }

    public static void activateWildcard(Wildcards type) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("Activated Wildcard: {}", new Object[]{type}));
    }

    public static void logPlayers() {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("Players online: {}", PlayerUtils.getAllPlayers()));
    }

    public static void rerollTask(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has rerolled their task.", player));
    }

    public static void successTask(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has passed their task.", player));
    }

    public static void failTask(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has failed their task.", player));
    }

    public static void assignTask(class_3222 player, Task task, List<String> linesStr) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has been given a {} task: {}", player, task.type.name(), String.join((CharSequence)" ", linesStr)));
    }

    public static void claimKill(class_3222 killer, class_3222 victim) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{}'s kill claim of {} has been accepted.", killer, victim));
    }

    public static void soulmate(class_3222 player, class_3222 soulmate) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{}'s soulmate has been chosen to be {}", player, soulmate));
    }

    public static void assignRandomLives(class_3222 player, int amount) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} has been randomly assigned {} lives", player, amount));
    }

    public static void givelife(class_2561 playerName, class_3222 target) {
        SessionTranscript.addMessageWithTime("<@", "> ", TextUtils.formatString("{} gave a life to {}", playerName, target));
    }

    public static void playerLeave(class_3222 player) {
        SessionTranscript.addMessageWithTime("<@", "> ", TextUtils.formatString("{} left the game.", player));
        SessionTranscript.addRecordIfMissing(player);
    }

    public static void playerJoin(class_3222 player) {
        SessionTranscript.addMessageWithTime("<@", "> ", TextUtils.formatString("{} joined the game.", player));
        SessionTranscript.addRecordIfMissing(player);
    }

    public static void triggerSessionAction(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        SessionTranscript.addMessageWithTime("TRIGGERED_SESSION_ACTION: " + message);
    }

    public static void onPlayerDeath(class_3222 player, class_1282 source) {
        SessionTranscript.addMessageWithTime("<@", "> ", source.method_5506((class_1309)player).getString());
        playerRecords.computeIfPresent(player.method_5820(), (key, value) -> {
            value.set(1, (Integer)value.get(1) + 1);
            return value;
        });
    }

    public static void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        SessionTranscript.addRecordIfMissing(killer);
        playerRecords.computeIfPresent(killer.method_5820(), (key, value) -> {
            value.set(0, (Integer)value.get(0) + 1);
            return value;
        });
    }

    public static void addRecordIfMissing(class_3222 player) {
        if (player.ls$isDead() || player.ls$isWatcher()) {
            return;
        }
        if (!playerRecords.containsKey(player.method_5820())) {
            playerRecords.put(player.method_5820(), new ArrayList<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(0))));
        }
    }

    public static void onPlayerLostAllLives(class_3222 player) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("{} lost all lives.", player));
    }

    public static void boogeymenChosen(List<class_3222> players) {
        SessionTranscript.addMessageWithTime(TextUtils.formatString("Boogeymen chosen: {}", players));
    }

    public static void sessionStart() {
        playerRecords.clear();
        PlayerUtils.getAllFunctioningPlayers().forEach(SessionTranscript::addRecordIfMissing);
        messages.add("\n");
        SessionTranscript.addMessageWithTime("-----  Session started!  -----");
    }

    public static void sessionEnd() {
        SessionTranscript.addMessageWithTime("-----  The session has ended!  -----\n");
        for (Map.Entry<String, List<Integer>> playerRecord : playerRecords.entrySet()) {
            if (playerRecord.getValue().size() < 2) continue;
            int kills = playerRecord.getValue().get(0);
            int deaths = playerRecord.getValue().get(1);
            messages.add(TextUtils.formatString("\t{}: {} {} and {} {}", playerRecord.getKey(), kills, TextUtils.pluralize("kill", kills), deaths, TextUtils.pluralize("death", deaths)));
        }
        if (!playerRecords.isEmpty()) {
            messages.add("\n");
        }
    }

    public static void addMessageWithTime(String message) {
        SessionTranscript.addMessageWithTime("[@", "] ", message);
    }

    private static void addMessageWithTime(String start, String end, String message) {
        String time = Main.currentSession.getPassedTimeStr();
        Object finalMessage = start + time + end + message;
        if (Main.currentSession.statusNotStarted() || Main.currentSession.statusFinished()) {
            finalMessage = message;
        }
        if (messages.isEmpty()) {
            SessionTranscript.addDefaultMessages();
        }
        messages.add((String)finalMessage);
    }

    public static void resetStats() {
        messages.clear();
        SessionTranscript.addDefaultMessages();
    }

    public static void addDefaultMessages() {
        messages.add(TextUtils.formatString("-----  Life Series Mod by Mat0u5  |  Mod version: {}  -----", "1.4.3.1"));
        messages.add(TextUtils.formatString("-----  {}  |  Time and date: {}  -----", Main.currentSeason.getSeason().name(), OtherUtils.getTimeAndDate()));
        messages.add("-----  Session Transcript  -----\n");
    }

    public static String getStats() {
        return String.join((CharSequence)"\n", messages);
    }

    public static void onSessionEnd() {
        Season season = Main.currentSeason;
        if (season instanceof SecretLife) {
            SecretLife secretLife = (SecretLife)season;
            secretLife.heartsTranscript();
        }
        SessionTranscript.sendTranscriptToAdmins();
        SessionTranscript.writeTranscriptToFile();
    }

    public static void sendTranscriptToAdmins() {
        class_2561 sessionTranscript = SessionTranscript.getTranscriptMessage();
        PlayerUtils.broadcastMessageToAdmins(sessionTranscript);
    }

    public static void writeTranscriptToFile() {
        String content = SessionTranscript.getStats();
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        String filename = now.format(formatter) + ".txt";
        try {
            Path filePath = Paths.get("transcripts", filename);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.write(filePath, content.getBytes(), new OpenOption[0]);
            Main.LOGGER.info("Session transcript file created: " + String.valueOf(filePath));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class_2561 getTranscriptMessage() {
        return TextUtils.format("\u00a77Click {}\u00a77 to copy the session transcript.", TextUtils.copyClipboardText(SessionTranscript.getStats()));
    }

    public record TranscriptPlayerRecord(UUID uuid, String name, int kills, int deaths) {
    }
}

