/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.antighost;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiGhost
implements ClientModInitializer {
    public static final String MOD_ID = "antighost";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"antighost");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("antighost.properties");
    private static class_304 requestBlocksKey;
    private static int radius;

    public void onInitializeClient() {
        this.loadConfig();
        String category = "key.categories.antighost";
        requestBlocksKey = new class_304("key.antighost.reveal", 71, "key.categories.antighost");
        KeyBindingHelper.registerKeyBinding((class_304)requestBlocksKey);
        ClientTickEvents.END_CLIENT_TICK.register(e -> this.keyPressed());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ghost").then(ClientCommandManager.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> {
                int customRadius = IntegerArgumentType.getInteger((CommandContext)c, (String)"radius");
                this.requestBlocks(customRadius);
                return 0;
            }))).executes(c -> {
                this.requestBlocks(radius);
                return 0;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)MOD_ID).then(ClientCommandManager.literal((String)"setradius").then(ClientCommandManager.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> {
                radius = IntegerArgumentType.getInteger((CommandContext)c, (String)"radius");
                this.saveConfig();
                class_746 player = class_310.method_1551().field_1724;
                player.method_7353((class_2561)class_2561.method_43469((String)"msg.radius_set", (Object[])new Object[]{radius}), false);
                return 0;
            }))));
        });
    }

    public void keyPressed() {
        class_746 player = class_310.method_1551().field_1724;
        if (requestBlocksKey.method_1436()) {
            this.requestBlocks(radius);
            player.method_7353((class_2561)class_2561.method_43471((String)"msg.request"), false);
        }
    }

    public void requestBlocks(int radius) {
        class_310 mc = class_310.method_1551();
        class_634 conn = mc.method_1562();
        if (conn == null) {
            return;
        }
        class_2338 pos = mc.field_1724.method_24515();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2846 packet = new class_2846(class_2846.class_2847.field_12971, new class_2338(pos.method_10263() + dx, pos.method_10264() + dy, pos.method_10260() + dz), class_2350.field_11036);
                    conn.method_52787((class_2596)packet);
                }
            }
        }
    }

    private void loadConfig() {
        Properties properties = new Properties();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                properties.load(reader);
                radius = Integer.parseInt(properties.getProperty("radius", String.valueOf(radius)));
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("Failed to load configuration. Using default radius.", (Throwable)e);
            }
        } else {
            this.saveConfig();
        }
    }

    private void saveConfig() {
        Properties properties = new Properties();
        properties.setProperty("radius", String.valueOf(radius));
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            properties.store(writer, null);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save configuration.", (Throwable)e);
        }
    }

    static {
        radius = 4;
    }
}

