/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.applaunch.plugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.StandardPluginCandidate;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.StandardPluginMetadata;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginContributor;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginDependency;
import org.spongepowered.plugin.metadata.builtin.model.StandardPluginLinks;

public class FabricModPluginLanguageService
implements PluginLanguageService {
    private final Logger logger = LogManager.getLogger((String)this.name());

    public String name() {
        return "fabric_mod";
    }

    public String pluginLoader() {
        return "dk.nelind.loofah.launch.plugin.FabricModPluginLoader";
    }

    public void initialize(Environment environment) {
    }

    public List<PluginCandidate> createPluginCandidates(Environment environment, PluginResource resource) throws Exception {
        Objects.requireNonNull(environment, "environment");
        Objects.requireNonNull(resource, "resource");
        LinkedList<PluginCandidate> candidates = new LinkedList<PluginCandidate>();
        Optional optStream = resource.openResource("fabric.mod.json");
        if (optStream.isEmpty()) {
            this.logger.debug("Container in path '{}' doesn't have a fabric.mod.json file, skipping...", (Object)resource.path());
            return candidates;
        }
        try (InputStream stream = (InputStream)optStream.get();){
            Set<PluginMetadata> metadataSet = this.parseFabricMetadata(JsonParser.parseReader((Reader)new InputStreamReader(stream)));
            for (PluginMetadata metadata : metadataSet) {
                candidates.add((PluginCandidate)new StandardPluginCandidate(metadata, resource));
            }
        }
        return candidates;
    }

    private Set<PluginMetadata> parseFabricMetadata(JsonElement jsonRoot) {
        HashSet<PluginMetadata> metadataSet = new HashSet<PluginMetadata>();
        if (jsonRoot.isJsonArray()) {
            for (JsonElement jsonElement : jsonRoot.getAsJsonArray()) {
                this.parseFabricMetadata(jsonElement.getAsJsonObject()).ifPresent(metadataSet::add);
            }
        } else {
            this.parseFabricMetadata(jsonRoot.getAsJsonObject()).ifPresent(metadataSet::add);
        }
        return metadataSet;
    }

    private Optional<PluginMetadata> parseFabricMetadata(JsonObject rootObject) {
        JsonElement recommends;
        JsonElement contributors;
        JsonElement authors;
        JsonElement contact;
        JsonElement description;
        JsonElement customValues = rootObject.get("custom");
        if (customValues != null) {
            for (Map.Entry entry : customValues.getAsJsonObject().entrySet()) {
                if (!((String)entry.getKey()).equals("fabric-loom:generated")) continue;
                return Optional.empty();
            }
        }
        StandardPluginMetadata.Builder builder = StandardPluginMetadata.builder();
        JsonElement schemaVersion = rootObject.get("schemaVersion");
        if (schemaVersion == null || schemaVersion.getAsInt() != 1) {
            throw new IllegalArgumentException("Unknown or no schemaVersion in fabric.mod.json!");
        }
        JsonElement id = rootObject.get("id");
        builder.id(id.getAsString().replace("-", "_"));
        JsonElement version = rootObject.get("version");
        builder.version(version.getAsString());
        JsonElement entryPoints = rootObject.get("entrypoints");
        if (entryPoints != null) {
            JsonObject entryPointsObject = entryPoints.getAsJsonObject();
            if (entryPointsObject.has("main")) {
                JsonElement firstMainEntrypoint = entryPointsObject.get("main").getAsJsonArray().get(0);
                if (firstMainEntrypoint.isJsonObject()) {
                    builder.entrypoint(firstMainEntrypoint.getAsJsonObject().get("value").getAsString());
                } else {
                    builder.entrypoint(firstMainEntrypoint.getAsString());
                }
            } else if (entryPointsObject.has("server")) {
                JsonElement firstServerEntrypoints = entryPointsObject.get("server").getAsJsonArray().get(0);
                if (firstServerEntrypoints.isJsonObject()) {
                    builder.entrypoint(firstServerEntrypoints.getAsJsonObject().get("value").getAsString());
                } else {
                    builder.entrypoint(firstServerEntrypoints.getAsString());
                }
            } else if (entryPointsObject.has("client")) {
                JsonElement firstClientEntrypoints = entryPointsObject.get("client").getAsJsonArray().get(0);
                if (firstClientEntrypoints.isJsonObject()) {
                    builder.entrypoint(firstClientEntrypoints.getAsJsonObject().get("value").getAsString());
                } else {
                    builder.entrypoint(firstClientEntrypoints.getAsString());
                }
            } else {
                builder.entrypoint("unknown");
            }
        } else {
            builder.entrypoint("none");
        }
        JsonElement name = rootObject.get("name");
        if (name != null) {
            builder.name(name.getAsString());
        }
        if ((description = rootObject.get("description")) != null) {
            builder.description(description.getAsString());
        }
        if ((contact = rootObject.get("contact")) != null) {
            builder.links(this.parseFabricModLinks(contact.getAsJsonObject()));
        }
        if ((authors = rootObject.get("authors")) != null) {
            for (Iterator author : authors.getAsJsonArray()) {
                if (author.isJsonPrimitive()) {
                    builder.addContributor(this.parseFabricModPersonWithDescription(author.getAsString(), "Author"));
                    continue;
                }
                builder.addContributor(this.parseFabricModPersonWithDescription(author.getAsJsonObject(), "Author"));
            }
        }
        if ((contributors = rootObject.get("contributors")) != null) {
            for (JsonElement contributor : contributors.getAsJsonArray()) {
                if (contributor.isJsonPrimitive()) {
                    builder.addContributor(this.parseFabricModPersonWithDescription(contributor.getAsString(), "Contributor"));
                    continue;
                }
                builder.addContributor(this.parseFabricModPersonWithDescription(contributor.getAsJsonObject(), "Contributor"));
            }
        }
        HashSet<StandardPluginDependency> dependencies = new HashSet<StandardPluginDependency>();
        JsonElement depends = rootObject.get("depends");
        if (depends != null) {
            dependencies.addAll(this.parseFabricModDependency(depends.getAsJsonObject(), false));
        }
        if ((recommends = rootObject.get("recommends")) != null) {
            dependencies.addAll(this.parseFabricModDependency(recommends.getAsJsonObject(), true));
        }
        builder.dependencies(dependencies);
        return Optional.of((PluginMetadata)builder.build());
    }

    private StandardPluginLinks parseFabricModLinks(JsonObject contactInfoObject) {
        StandardPluginLinks.Builder builder = StandardPluginLinks.builder();
        try {
            JsonElement sourcesLink;
            JsonElement issuesLink;
            JsonElement homepageLink = contactInfoObject.get("homepage");
            if (homepageLink != null) {
                builder.homepage(URI.create(homepageLink.getAsString()).toURL());
            }
            if ((issuesLink = contactInfoObject.get("issues")) != null) {
                builder.issues(URI.create(issuesLink.getAsString()).toURL());
            }
            if ((sourcesLink = contactInfoObject.get("sources")) != null) {
                builder.source(URI.create(sourcesLink.getAsString()).toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Fabric mod had a malformed URL!", e);
        }
        return builder.build();
    }

    private StandardPluginContributor parseFabricModPersonWithDescription(String name, String description) {
        StandardPluginContributor.Builder builder = StandardPluginContributor.builder();
        builder.name(name);
        builder.description(description);
        return builder.build();
    }

    private StandardPluginContributor parseFabricModPersonWithDescription(JsonObject personObject, String description) {
        StandardPluginContributor.Builder builder = StandardPluginContributor.builder();
        builder.name(personObject.get("name").getAsString());
        builder.description(description);
        return builder.build();
    }

    private Set<StandardPluginDependency> parseFabricModDependency(JsonObject dependenciesObject, boolean optional) {
        HashSet<StandardPluginDependency> dependencies = new HashSet<StandardPluginDependency>();
        dependenciesObject.entrySet().forEach(entry -> {
            if (((String)entry.getKey()).equals("java")) {
                return;
            }
            StandardPluginDependency.Builder builder = StandardPluginDependency.builder();
            builder.id(((String)entry.getKey()).replace("-", "_"));
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                StringBuilder versionStringBldr = new StringBuilder();
                ((JsonElement)entry.getValue()).getAsJsonArray().forEach(elm -> versionStringBldr.append(elm.getAsString()).append(","));
                builder.version(versionStringBldr.toString());
            } else {
                builder.version(((JsonElement)entry.getValue()).getAsString());
            }
            builder.optional(optional);
            dependencies.add(builder.build());
        });
        return dependencies;
    }
}

