/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.applaunch.plugin;

import dk.nelind.loofah.applaunch.plugin.resource.FabricPluginResource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.applaunch.config.LaunchConfig;
import org.spongepowered.common.applaunch.config.TokenReplacement;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.PluginResourceLocatorService;
import org.spongepowered.plugin.blackboard.Keys;
import org.spongepowered.plugin.builtin.StandardEnvironment;
import org.spongepowered.plugin.builtin.jvm.JVMKeys;

public class FabricPluginPlatform
implements PluginPlatform {
    private static volatile boolean bootstrapped;
    private final Environment environment;
    private final LaunchConfig config;
    private final TokenReplacement tokens;
    private final Map<String, PluginResourceLocatorService<?>> locatorServices;
    private final Map<String, PluginLanguageService> languageServices;
    private final Map<String, Set<? extends PluginResource>> locatorResources;
    private final Map<PluginLanguageService, List<PluginCandidate>> pluginCandidates;

    public static synchronized void bootstrap() {
        FabricPluginPlatform platform;
        if (bootstrapped) {
            return;
        }
        try {
            platform = new FabricPluginPlatform();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AppLaunch.setPluginPlatform(platform);
        bootstrapped = true;
    }

    public FabricPluginPlatform() throws IOException {
        FabricLoader loader = FabricLoader.getInstance();
        this.environment = new StandardEnvironment(LogManager.getLogger((String)"Loofah/AppLaunch"));
        ModContainer loofahModContainer = (ModContainer)loader.getModContainer("loofah").orElseThrow(() -> new IllegalStateException("Tried to get own ModContainer, but it wasn't available. This should be impossible!!"));
        String loofahVersion = loofahModContainer.getMetadata().getVersion().getFriendlyString();
        this.setVersion(loofahVersion == null ? "dev" : loofahVersion);
        Path baseDirectory = loader.getGameDir();
        this.setBaseDirectory(baseDirectory);
        this.setMetadataFilePath("META-INF/sponge_plugins.json");
        this.config = LaunchConfig.load(baseDirectory, true);
        Path modsDirectory = baseDirectory.resolve("mods");
        this.tokens = new TokenReplacement();
        this.tokens.register("BASE_DIR", baseDirectory);
        this.tokens.register("CONFIG_DIR", this.configDirectory());
        this.tokens.register("MODS_DIR", modsDirectory);
        this.locatorServices = new HashMap();
        this.languageServices = new HashMap<String, PluginLanguageService>();
        this.locatorResources = new HashMap<String, Set<? extends PluginResource>>();
        this.pluginCandidates = new IdentityHashMap<PluginLanguageService, List<PluginCandidate>>();
        Path additionalPluginsDirectory = Path.of(this.tokens.replace(this.config.additionalPluginsDirectory()), new String[0]);
        Files.createDirectories(additionalPluginsDirectory, new FileAttribute[0]);
        this.setPluginDirectories(List.of(modsDirectory, additionalPluginsDirectory));
    }

    @Override
    public String version() {
        return (String)this.environment.blackboard().get(Keys.VERSION);
    }

    public void setVersion(String version) {
        this.environment.blackboard().set(Keys.VERSION, (Object)version);
    }

    @Override
    public Logger logger() {
        return this.environment.logger();
    }

    @Override
    public boolean vanilla() {
        return false;
    }

    @Override
    public Path baseDirectory() {
        return (Path)this.environment.blackboard().get(Keys.BASE_DIRECTORY);
    }

    @Override
    public Path configDirectory() {
        return this.baseDirectory().resolve("config");
    }

    @Override
    public LaunchConfig config() {
        return this.config;
    }

    @Override
    public TokenReplacement tokens() {
        return this.tokens;
    }

    public void setBaseDirectory(Path path) {
        this.environment.blackboard().set(Keys.BASE_DIRECTORY, (Object)path);
    }

    @Override
    public List<Path> pluginDirectories() {
        return (List)this.environment.blackboard().get(Keys.PLUGIN_DIRECTORIES);
    }

    public void setPluginDirectories(List<Path> list) {
        this.environment.blackboard().set(Keys.PLUGIN_DIRECTORIES, list);
    }

    public String metadataFilePath() {
        return (String)this.environment.blackboard().get(Keys.METADATA_FILE_PATH);
    }

    public void setMetadataFilePath(String path) {
        this.environment.blackboard().set(Keys.METADATA_FILE_PATH, (Object)path);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Map<String, PluginResourceLocatorService<? extends PluginResource>> getLocatorServices() {
        return Collections.unmodifiableMap(this.locatorServices);
    }

    public Map<String, PluginLanguageService> getLanguageServices() {
        return Collections.unmodifiableMap(this.languageServices);
    }

    public Map<String, Set<? extends PluginResource>> getResources() {
        return Collections.unmodifiableMap(this.locatorResources);
    }

    public Map<PluginLanguageService, List<PluginCandidate>> getCandidates() {
        return Collections.unmodifiableMap(this.pluginCandidates);
    }

    public void discoverLocatorServices() {
        ServiceLoader<PluginResourceLocatorService> serviceLoader = ServiceLoader.load(PluginResourceLocatorService.class, FabricPluginPlatform.class.getClassLoader());
        Iterator<PluginResourceLocatorService> iter = serviceLoader.iterator();
        while (iter.hasNext()) {
            PluginResourceLocatorService next;
            try {
                next = iter.next();
            }
            catch (ServiceConfigurationError e) {
                this.environment.logger().error("Error encountered initializing plugin resource locator!", (Throwable)e);
                continue;
            }
            this.logger().info("Plugin resource locator '{}' found.", (Object)next.name());
            this.locatorServices.put(next.name(), next);
        }
    }

    public void discoverLanguageServices() {
        this.environment.blackboard().set(JVMKeys.JVM_PLUGIN_RESOURCE_FACTORY, FabricPluginResource::new);
        this.environment.blackboard().set(JVMKeys.ENVIRONMENT_LOCATOR_VARIABLE_NAME, (Object)"SPONGE_PLUGINS");
        ServiceLoader<PluginLanguageService> serviceLoader = ServiceLoader.load(PluginLanguageService.class, FabricPluginPlatform.class.getClassLoader());
        Iterator<PluginLanguageService> iter = serviceLoader.iterator();
        while (iter.hasNext()) {
            PluginLanguageService next;
            try {
                next = iter.next();
            }
            catch (ServiceConfigurationError e) {
                this.environment.logger().error("Error encountered initializing plugin language service!", (Throwable)e);
                continue;
            }
            this.logger().info("Plugin language loader '{}' found.", (Object)next.name());
            this.languageServices.put(next.name(), next);
        }
    }

    public void locatePluginResources() {
        for (Map.Entry<String, PluginResourceLocatorService<?>> locatorEntry : this.locatorServices.entrySet()) {
            PluginResourceLocatorService<?> locatorService = locatorEntry.getValue();
            Set resources = locatorService.locatePluginResources(this.environment);
            if (resources.isEmpty()) continue;
            this.locatorResources.put(locatorEntry.getKey(), resources);
        }
    }

    public void createPluginCandidates() {
        for (PluginLanguageService languageService : this.languageServices.values()) {
            List candidates;
            if (languageService.name().equals("fabric_mod")) {
                for (PluginResource pluginResource2 : this.locatorResources.values().stream().flatMap(Collection::stream).filter(pluginResource -> pluginResource.locator().equals("fabric_mods")).toList()) {
                    try {
                        candidates = languageService.createPluginCandidates(this.environment, pluginResource2);
                        if (candidates.isEmpty()) continue;
                        this.pluginCandidates.computeIfAbsent(languageService, k -> new LinkedList()).addAll(candidates);
                    }
                    catch (Exception ex) {
                        this.environment.logger().error("Failed to create plugin candidates", (Throwable)ex);
                    }
                }
                continue;
            }
            for (PluginResource pluginResource2 : this.locatorResources.values().stream().flatMap(Collection::stream).filter(pluginResource -> !pluginResource.locator().equals("fabric_mods")).toList()) {
                try {
                    candidates = languageService.createPluginCandidates(this.environment, pluginResource2);
                    if (candidates.isEmpty()) continue;
                    this.pluginCandidates.computeIfAbsent(languageService, k -> new LinkedList()).addAll(candidates);
                }
                catch (Exception ex) {
                    this.environment.logger().error("Failed to create plugin candidates", (Throwable)ex);
                }
            }
        }
    }
}

