/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.applaunch.plugin.resource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import org.spongepowered.plugin.builtin.jvm.JVMPluginResource;

public class FabricModPluginResource
implements JVMPluginResource {
    private final String locator;
    private final List<Path> paths;
    private final Manifest manifest;

    public FabricModPluginResource(String locator, Path[] paths) {
        this.locator = locator;
        try {
            this.paths = FabricModPluginResource.processPaths(paths);
            this.manifest = FabricModPluginResource.getManifest(this.paths);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Path> processPaths(Path[] paths) throws IOException {
        ArrayList<Path> processedPaths = new ArrayList<Path>();
        for (Path path : paths) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                processedPaths.add(path);
                continue;
            }
            if (path.toString().endsWith(".jar")) {
                FileSystemUtil.FileSystemDelegate fs = FileSystemUtil.getJarFileSystem((Path)path, (boolean)false);
                Path jarPath = fs.get().getRootDirectories().iterator().next();
                processedPaths.add(jarPath);
                continue;
            }
            throw new IllegalStateException(String.format("Resource path \"%s\" of unknown type given!Plugins can only be provided in jar or directory form!", path));
        }
        return processedPaths;
    }

    public static Manifest getManifest(List<Path> paths) throws IOException {
        Manifest manifest = new Manifest();
        for (Path path : paths) {
            Path manifestPath = path.resolve("META-INF/MANIFEST.MF");
            if (!Files.exists(manifestPath, new LinkOption[0])) continue;
            manifest.read(Files.newInputStream(manifestPath, new OpenOption[0]));
            break;
        }
        return manifest;
    }

    public Optional<URI> locateResource(String path) {
        Optional<URI> resource = Optional.empty();
        for (Path resourcePath : this.paths) {
            Path p = resourcePath.resolve(path);
            if (!Files.exists(p, new LinkOption[0])) continue;
            resource = Optional.of(p.toUri());
            break;
        }
        return resource;
    }

    public String locator() {
        return this.locator;
    }

    public Path path() {
        return this.paths.getLast();
    }

    public Manifest manifest() {
        return this.manifest;
    }

    public Path resourcesRoot() {
        return this.path();
    }
}

