/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.launch;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import dk.nelind.loofah.applaunch.plugin.FabricPluginPlatform;
import dk.nelind.loofah.launch.inject.FabricModule;
import dk.nelind.loofah.launch.plugin.FabricDummyPluginContainer;
import dk.nelind.loofah.launch.plugin.FabricPluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeLifecycle;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;
import org.spongepowered.common.inject.SpongeCommonModule;
import org.spongepowered.common.inject.SpongeGuice;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public class FabricLaunch
extends Launch {
    private final FabricPluginManager pluginManager = new FabricPluginManager();
    public static final List<String> PLATFORM_PLUGINS = List.of("minecraft", "spongeapi", "sponge", "loofah");

    public FabricLaunch(PluginPlatform pluginPlatform) {
        super(pluginPlatform);
    }

    public static void launch(FabricPluginPlatform pluginPlatform) {
        FabricLaunch launch = new FabricLaunch(pluginPlatform);
        Launch.setInstance(launch);
        launch.bootstrap();
        launch.loadPlugins();
    }

    private void bootstrap() {
        this.createPlatformPlugins();
        class_155.method_36208();
        Stage stage = SpongeGuice.getInjectorStage(this.injectionStage());
        SpongeCommon.logger().debug("Creating injector in stage '{}'", (Object)stage);
        Injector bootstrapInjector = this.createInjector();
        SpongeLifecycle lifecycle = (SpongeLifecycle)bootstrapInjector.getInstance(SpongeLifecycle.class);
        this.setLifecycle(lifecycle);
        lifecycle.establishFactories();
        lifecycle.establishBuilders();
    }

    private void loadPlugins() {
        this.pluginManager.loadPlugins(this.pluginPlatform());
    }

    private void createPlatformPlugins() {
        this.pluginPlatform().getCandidates().values().stream().flatMap(Collection::stream).filter(plugin -> PLATFORM_PLUGINS.contains(plugin.metadata().id())).map(FabricDummyPluginContainer::of).forEach(this.pluginManager()::addPlugin);
    }

    @Override
    public Stage injectionStage() {
        return FabricLoader.getInstance().isDevelopmentEnvironment() ? Stage.DEVELOPMENT : Stage.PRODUCTION;
    }

    @Override
    public boolean dedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    @Override
    public FabricPluginManager pluginManager() {
        return this.pluginManager;
    }

    @Override
    public FabricPluginPlatform pluginPlatform() {
        return (FabricPluginPlatform)this.pluginPlatform;
    }

    @Override
    public PluginContainer platformPlugin() {
        return this.pluginManager.plugin("loofah").orElseThrow(() -> new IllegalStateException("Couldn't get the plugin representing Loofah this shouldn't be possible!"));
    }

    @Override
    public Injector createInjector() {
        ArrayList modules = Lists.newArrayList((Object[])new Module[]{new SpongeModule(), new SpongeCommonModule(), new FabricModule()});
        return Guice.createInjector((Stage)this.injectionStage(), (Iterable)modules);
    }
}

