/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.launch.plugin;

import com.google.inject.Singleton;
import dk.nelind.loofah.applaunch.plugin.FabricPluginPlatform;
import dk.nelind.loofah.launch.plugin.resolver.DependencyResolver;
import dk.nelind.loofah.launch.plugin.resolver.ResolutionResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.applaunch.plugin.DummyPluginContainer;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.plugin.SpongePluginManager;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.InvalidPluginException;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginLoader;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.metadata.model.PluginDependency;

@Singleton
public final class FabricPluginManager
implements SpongePluginManager {
    private final Map<String, PluginContainer> plugins = new Object2ObjectOpenHashMap();
    private final Map<Object, PluginContainer> instancesToPlugins = new IdentityHashMap<Object, PluginContainer>();
    private final List<PluginContainer> sortedPlugins = new ArrayList<PluginContainer>();
    private final Map<PluginContainer, PluginResource> containerToResource = new Object2ObjectOpenHashMap();
    private boolean ready = false;

    public Optional<PluginContainer> fromInstance(Object instance) {
        return Optional.ofNullable(this.instancesToPlugins.get(Objects.requireNonNull(instance, "instance")));
    }

    public Optional<PluginContainer> plugin(String id) {
        return Optional.ofNullable(this.plugins.get(Objects.requireNonNull(id, "id")));
    }

    public Collection<PluginContainer> plugins() {
        return Collections.unmodifiableCollection(this.sortedPlugins);
    }

    public void loadPlugins(FabricPluginPlatform platform) {
        HashMap pluginLanguageLookup = new HashMap();
        HashMap<PluginLanguageService, PluginLoader> pluginLoaders = new HashMap<PluginLanguageService, PluginLoader>();
        for (Map.Entry<PluginLanguageService, List<PluginCandidate>> candidate : platform.getCandidates().entrySet()) {
            PluginLanguageService languageService = candidate.getKey();
            String loaderClass = languageService.pluginLoader();
            try {
                pluginLoaders.put(languageService, (PluginLoader)Class.forName(loaderClass).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            candidate.getValue().forEach(x -> pluginLanguageLookup.put(x, languageService));
        }
        LinkedHashSet<PluginCandidate> resources = new LinkedHashSet<PluginCandidate>();
        pluginLanguageLookup.keySet().stream().filter(x -> this.plugins.containsKey(x.metadata().id())).forEach(resources::add);
        resources.addAll(pluginLanguageLookup.keySet());
        ResolutionResult resolutionResult = DependencyResolver.resolveAndSortCandidates(resources, platform.logger());
        HashMap<PluginCandidate, String> failedInstances = new HashMap<PluginCandidate, String>();
        HashMap<PluginCandidate, String> consequentialFailedInstances = new HashMap<PluginCandidate, String>();
        ClassLoader launchClassloader = Launch.instance().getClass().getClassLoader();
        for (PluginCandidate candidate : resolutionResult.sortedSuccesses()) {
            PluginContainer plugin;
            String id = candidate.metadata().id();
            if (id.indexOf(45) >= 0) {
                platform.logger().warn("The dash character (-) is no longer supported in plugin ids.\nPlugin {} is still using it. If you are the developer of this plugin, please change the id.", (Object)id);
            }
            if ((plugin = this.plugins.get(id)) != null) {
                if (plugin instanceof DummyPluginContainer) continue;
                resolutionResult.duplicateIds().add(candidate.metadata().id());
                PrettyPrinter prettyPrinter = new PrettyPrinter(120).add("ATTEMPTED TO CREATE PLUGIN WITH DUPLICATE PLUGIN ID").centre().hr().addWrapped("Loofah attempted to create a second plugin with ID '%s'. This is not allowed - all plugins must have a unique ID. Usually, Loofah will catch this earlier -- but in this case Loofah has validated two plugins with the same ID. Please report this error to Loofah devs.", id).add().add("Technical Details:").add((Object)"Plugins to load:", 4);
                resolutionResult.sortedSuccesses().forEach(x -> prettyPrinter.add((Object)("*" + x.metadata().id()), 4));
                prettyPrinter.add().add((Object)"Detected Duplicate IDs:", 4);
                resolutionResult.duplicateIds().forEach(x -> prettyPrinter.add((Object)("*" + x), 4));
                prettyPrinter.log(platform.logger(), Level.ERROR);
                continue;
            }
            if (!this.stillValid(candidate, consequentialFailedInstances)) continue;
            PluginLanguageService languageService = (PluginLanguageService)pluginLanguageLookup.get(candidate);
            PluginLoader pluginLoader = (PluginLoader)pluginLoaders.get(languageService);
            try {
                PluginContainer container = pluginLoader.loadPlugin(platform.getEnvironment(), candidate, launchClassloader);
                this.addPlugin(container);
                this.containerToResource.put(container, candidate.resource());
            }
            catch (InvalidPluginException e) {
                failedInstances.put(candidate, "Failed to construct: see stacktrace(s) above this message for details.");
                platform.logger().error("Failed to construct plugin {}", (Object)id, (Object)e);
            }
        }
        resolutionResult.printErrorsIfAny(failedInstances, consequentialFailedInstances, platform.logger());
        platform.logger().info("Loaded plugin(s): {}", this.sortedPlugins.stream().map(p -> p.metadata().id()).collect(Collectors.toList()));
        this.ready = true;
    }

    public void addPlugin(PluginContainer plugin) {
        this.plugins.put(plugin.metadata().id(), Objects.requireNonNull(plugin, "plugin"));
        this.sortedPlugins.add(plugin);
        if (!(plugin instanceof DummyPluginContainer)) {
            this.instancesToPlugins.put(plugin.instance(), plugin);
        }
    }

    public @Nullable PluginResource resource(PluginContainer container) {
        return this.containerToResource.get(container);
    }

    private boolean stillValid(PluginCandidate candidate, Map<PluginCandidate, String> consequential) {
        Optional<PluginDependency> failedId = candidate.metadata().dependencies().stream().filter(d -> !this.isDependencyStillValid((PluginDependency)d)).findFirst();
        if (failedId.isPresent()) {
            consequential.put(candidate, failedId.get().id());
            return false;
        }
        return true;
    }

    private boolean isDependencyStillValid(PluginDependency dependency) {
        if (!dependency.optional()) {
            return switch (dependency.loadOrder()) {
                case PluginDependency.LoadOrder.BEFORE -> {
                    if (!this.plugins.containsKey(dependency.id())) {
                        yield true;
                    }
                    yield false;
                }
                case PluginDependency.LoadOrder.AFTER -> this.plugins.containsKey(dependency.id());
                default -> true;
            };
        }
        return true;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }
}

