/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.launch.plugin;

import com.google.inject.Injector;
import dk.nelind.loofah.launch.plugin.FabricJavaPluginContainer;
import java.lang.invoke.MethodHandles;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.spongepowered.common.inject.plugin.PluginGuice;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.InvalidPluginException;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLoader;

public class JavaPluginLoader
implements PluginLoader<FabricJavaPluginContainer> {
    private static final ArtifactVersion VERSION = new DefaultArtifactVersion("1.0");
    private static final MethodHandles.Lookup LOOFAH_LOOKUP = MethodHandles.lookup();

    public ArtifactVersion version() {
        return VERSION;
    }

    public FabricJavaPluginContainer loadPlugin(Environment environment, PluginCandidate candidate, ClassLoader targetClassLoader) throws InvalidPluginException {
        FabricJavaPluginContainer container = new FabricJavaPluginContainer(candidate);
        try {
            String mainClass = container.metadata().entrypoint();
            Class<?> pluginClass = Class.forName(mainClass, true, targetClassLoader);
            Injector pluginInjector = PluginGuice.create(container, pluginClass, ((Launch)Launch.instance()).lifecycle().platformInjector());
            Object plugin = pluginInjector.getInstance(pluginClass);
            container.setInjector(pluginInjector);
            container.initializeInstance(plugin);
            container.initializeLookup(MethodHandles.privateLookupIn(pluginClass, LOOFAH_LOOKUP));
            return container;
        }
        catch (Exception ex) {
            throw new InvalidPluginException("An error occurred creating an instance of plugin '" + container.metadata().id() + "'!", (Throwable)ex);
        }
    }
}

