/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.launch.plugin.resolver;

import dk.nelind.loofah.launch.plugin.resolver.ResolutionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.metadata.model.PluginDependency;

public final class DependencyResolver {
    public static ResolutionResult resolveAndSortCandidates(Collection<PluginCandidate> candidates, Logger logger) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        ResolutionResult resolutionResult = new ResolutionResult();
        for (PluginCandidate pluginCandidate : candidates) {
            String id = pluginCandidate.metadata().id();
            if (nodes.containsKey(id)) {
                resolutionResult.duplicateIds().add(id);
                continue;
            }
            nodes.put(id, new Node(pluginCandidate));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            Node node = (Node)entry.getValue();
            for (PluginDependency pd : node.candidate.metadata().dependencies()) {
                boolean isOptional = pd.optional();
                Node dep = (Node)nodes.get(pd.id());
                if (dep == null) {
                    if (isOptional) continue;
                    node.invalid = true;
                    String failure = pd.version() != null ? String.format("%s version %s", pd.id(), pd.version()) : pd.id();
                    resolutionResult.missingDependencies().computeIfAbsent(((Node)entry.getValue()).candidate, k -> new ArrayList()).add(failure);
                    node.checked = true;
                    continue;
                }
                if (!DependencyResolver.checkVersion(pd.version(), dep.candidate.metadata().version())) {
                    if (isOptional) continue;
                    resolutionResult.versionMismatch().computeIfAbsent(((Node)entry.getValue()).candidate, k -> new ArrayList()).add(Tuple.of((Object)pd.version().toString(), (Object)dep.candidate));
                    node.invalid = true;
                    node.checked = true;
                }
                if (pd.loadOrder() == PluginDependency.LoadOrder.BEFORE) {
                    if (!pd.optional()) {
                        node.beforeRequiredDependency.add(node);
                    }
                    DependencyResolver.setDependency(dep, node, true);
                    continue;
                }
                DependencyResolver.setDependency(node, dep, pd.optional());
            }
        }
        DependencyResolver.checkCyclic(nodes.values(), resolutionResult);
        for (Node node : nodes.values()) {
            DependencyResolver.calculateSecondaryFailures(node, resolutionResult);
        }
        List original = nodes.values().stream().filter(x -> !x.invalid).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<Node> arrayList = new ArrayList<Node>(original);
        LinkedHashSet<Node> sorted = new LinkedHashSet<Node>();
        arrayList.stream().filter(x -> x.dependencies.isEmpty() && x.optionalDependencies.isEmpty()).forEach(sorted::add);
        arrayList.removeIf(sorted::contains);
        int size = arrayList.size();
        boolean excludeOptionals = false;
        while (!arrayList.isEmpty()) {
            boolean containsOptionalDeps = false;
            for (Node node : arrayList) {
                if (!sorted.containsAll(node.dependencies) || !DependencyResolver.checkOptionalDependencies(excludeOptionals, sorted, node)) continue;
                boolean hasOptionalDeps = !node.optionalDependencies.isEmpty();
                containsOptionalDeps |= hasOptionalDeps;
                sorted.add(node);
                if (!excludeOptionals || !hasOptionalDeps) continue;
                logger.warn("Plugin {} will be loaded before its optional dependencies: [ {} ]", (Object)node.candidate.metadata().id(), (Object)node.optionalDependencies.stream().map(x -> x.candidate.metadata().id()).collect(Collectors.joining(", ")));
            }
            arrayList.removeIf(sorted::contains);
            if (arrayList.size() == size) {
                if (excludeOptionals || !containsOptionalDeps) {
                    throw new IllegalStateException(String.format("Dependency resolver could not resolve order of all plugins.\n\nAttempted to sort %d plugins: [ %s ]\nCould not sort %d plugins: [ %s ]", original.size(), original.stream().map(x -> x.candidate.metadata().id()).collect(Collectors.joining(", ")), arrayList.size(), arrayList.stream().map(x -> x.candidate.metadata().id()).collect(Collectors.joining(", "))));
                }
                logger.warn("Failed to resolve plugin load order due to failed dependency resolution, attempting to resolve order ignoring optional dependencies.");
                excludeOptionals = true;
                continue;
            }
            size = arrayList.size();
            excludeOptionals = false;
        }
        Collection<PluginCandidate> sortedSuccesses = resolutionResult.sortedSuccesses();
        for (Node x2 : sorted) {
            sortedSuccesses.add(x2.candidate);
        }
        return resolutionResult;
    }

    private static <T extends PluginResource> boolean checkOptionalDependencies(boolean excludeOptionals, Collection<Node> sorted, Node node) {
        if (excludeOptionals) {
            return node.optionalDependencies.stream().flatMap(x -> x.beforeRequiredDependency.stream()).distinct().allMatch(sorted::contains);
        }
        return sorted.containsAll(node.optionalDependencies);
    }

    private static <T extends PluginResource> void setDependency(Node before, Node after, boolean optional) {
        if (optional) {
            before.optionalDependencies.add(after);
        } else {
            before.dependencies.add(after);
        }
    }

    private static boolean checkVersion(@Nullable VersionRange requestedVersion, ArtifactVersion dependencyVersion) {
        if (requestedVersion == null || !requestedVersion.hasRestrictions()) {
            return true;
        }
        return Objects.equals(requestedVersion.getRecommendedVersion(), dependencyVersion) || requestedVersion.containsVersion(dependencyVersion);
    }

    private static <T extends PluginResource> void checkCyclic(Collection<Node> nodes, ResolutionResult resolutionResult) {
        for (Node node : nodes) {
            if (node.checked) continue;
            LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>();
            nodeSet.add(node);
            DependencyResolver.checkCyclic(node, resolutionResult, nodeSet);
        }
    }

    private static <T extends PluginResource> void checkCyclic(Node node, ResolutionResult resolutionResult, LinkedHashSet<Node> dependencyPath) {
        if (node.invalid) {
            return;
        }
        for (Node dependency : node.dependencies) {
            if (dependency.checked) continue;
            if (!dependencyPath.add(dependency)) {
                dependency.checked = true;
                node.invalid = true;
                boolean append = false;
                LinkedList<PluginCandidate> candidatePath = new LinkedList<PluginCandidate>();
                for (Node depInCycle : dependencyPath) {
                    if (!(append |= depInCycle == dependency)) continue;
                    candidatePath.add(depInCycle.candidate);
                    depInCycle.invalid = true;
                }
                for (PluginCandidate dep : candidatePath) {
                    resolutionResult.cyclicDependency().put(dep, candidatePath);
                }
                continue;
            }
            DependencyResolver.checkCyclic(dependency, resolutionResult, dependencyPath);
            dependencyPath.remove(dependency);
        }
    }

    private static <T extends PluginResource> boolean calculateSecondaryFailures(Node node, ResolutionResult resolutionResult) {
        if (node.secondaryChecked) {
            return node.invalid;
        }
        node.secondaryChecked = true;
        if (node.invalid) {
            return true;
        }
        if (node.dependencies.isEmpty() && node.beforeRequiredDependency.isEmpty()) {
            return false;
        }
        for (Node depNode : node.dependencies) {
            if (!DependencyResolver.calculateSecondaryFailures(depNode, resolutionResult)) continue;
            node.invalid = true;
            resolutionResult.cascadedFailure().computeIfAbsent(node.candidate, k -> new HashSet()).add(depNode.candidate);
        }
        for (Node depNode : node.beforeRequiredDependency) {
            if (!DependencyResolver.calculateSecondaryFailures(depNode, resolutionResult)) continue;
            node.invalid = true;
            resolutionResult.cascadedFailure().computeIfAbsent(node.candidate, k -> new HashSet()).add(depNode.candidate);
        }
        return node.invalid;
    }

    static class Node {
        final PluginCandidate candidate;
        final Set<Node> beforeRequiredDependency = new HashSet<Node>();
        final Set<Node> dependencies = new HashSet<Node>();
        final Set<Node> optionalDependencies = new HashSet<Node>();
        boolean invalid = false;
        boolean checked = false;
        boolean secondaryChecked = false;

        public Node(PluginCandidate candidate) {
            this.candidate = candidate;
        }
    }
}

