/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.launch.plugin.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.PluginCandidate;

public final class ResolutionResult {
    private final LinkedHashSet<PluginCandidate> sortedSuccesses = new LinkedHashSet();
    private final Collection<String> duplicateIds = new HashSet<String>();
    private final Map<PluginCandidate, Collection<String>> missingDependencies = new HashMap<PluginCandidate, Collection<String>>();
    private final Map<PluginCandidate, Collection<Tuple<String, PluginCandidate>>> versionMismatch = new HashMap<PluginCandidate, Collection<Tuple<String, PluginCandidate>>>();
    private final Map<PluginCandidate, Collection<PluginCandidate>> cyclicDependency = new HashMap<PluginCandidate, Collection<PluginCandidate>>();
    private final Map<PluginCandidate, Collection<PluginCandidate>> cascadedFailure = new HashMap<PluginCandidate, Collection<PluginCandidate>>();

    public Collection<PluginCandidate> sortedSuccesses() {
        return this.sortedSuccesses;
    }

    public Collection<String> duplicateIds() {
        return this.duplicateIds;
    }

    public Map<PluginCandidate, Collection<String>> missingDependencies() {
        return this.missingDependencies;
    }

    public Map<PluginCandidate, Collection<Tuple<String, PluginCandidate>>> versionMismatch() {
        return this.versionMismatch;
    }

    public Map<PluginCandidate, Collection<PluginCandidate>> cyclicDependency() {
        return this.cyclicDependency;
    }

    public Map<PluginCandidate, Collection<PluginCandidate>> cascadedFailure() {
        return this.cascadedFailure;
    }

    public void printErrorsIfAny(Map<PluginCandidate, String> failedInstance, Map<PluginCandidate, String> consequentialFailedInstance, Logger logger) {
        int noOfFailures = this.numberOfFailures() + failedInstance.size() + consequentialFailedInstance.size();
        if (noOfFailures == 0) {
            return;
        }
        PrettyPrinter errorPrinter = new PrettyPrinter(120);
        errorPrinter.add("SPONGE PLUGINS FAILED TO LOAD").centre().hr().addWrapped("%d plugin(s) have unfulfilled or cyclic dependencies or failed to load. Your game will continue to load without these plugins.", noOfFailures);
        if (!this.duplicateIds.isEmpty()) {
            errorPrinter.add();
            errorPrinter.add("The following plugins IDs were duplicated - some plugins will not have been loaded:");
            for (String string : this.duplicateIds) {
                errorPrinter.add(" * %s", string);
            }
        }
        if (!this.missingDependencies.isEmpty()) {
            errorPrinter.add();
            errorPrinter.add("The following plugins are missing dependencies:");
            for (Map.Entry entry : this.missingDependencies.entrySet()) {
                errorPrinter.add(" * %s requires [ %s ]", ((PluginCandidate)entry.getKey()).metadata().id(), String.join((CharSequence)", ", (Iterable)entry.getValue()));
            }
        }
        if (!this.versionMismatch.isEmpty()) {
            errorPrinter.add();
            errorPrinter.add("The following plugins require different version(s) of dependencies you have installed:");
            for (Map.Entry entry : this.versionMismatch.entrySet()) {
                PluginCandidate pluginCandidate = (PluginCandidate)entry.getKey();
                Collection mismatchedDeps = (Collection)entry.getValue();
                String errorString = mismatchedDeps.stream().map(x -> String.format("%s version %s (currently version %s)", ((PluginCandidate)x.second()).metadata().id(), x.first(), ((PluginCandidate)x.second()).metadata().version())).collect(Collectors.joining(", "));
                errorPrinter.add(" * %s requires [ %s ]", pluginCandidate.metadata().id(), errorString);
            }
        }
        if (!this.cyclicDependency.isEmpty()) {
            errorPrinter.add();
            errorPrinter.add("The following plugins were found to have cyclic dependencies:");
            for (Map.Entry entry : this.cyclicDependency.entrySet()) {
                errorPrinter.add(" * %s has dependency cycle [ ... -> %s -> ... ]", ((PluginCandidate)entry.getKey()).metadata().id(), ((Collection)entry.getValue()).stream().map(x -> x.metadata().id()).collect(Collectors.joining(" -> ")));
            }
        }
        if (!failedInstance.isEmpty()) {
            errorPrinter.add();
            errorPrinter.add("The following plugins threw exceptions when being created (report these to the plugin authors):");
            for (Map.Entry entry : failedInstance.entrySet()) {
                errorPrinter.add(" * %s with the error message \"%s\"", ((PluginCandidate)entry.getKey()).metadata().id(), entry.getValue());
            }
        }
        if (!this.cascadedFailure.isEmpty() || !consequentialFailedInstance.isEmpty()) {
            HashMap<PluginCandidate, String> mergedFailures = new HashMap<PluginCandidate, String>(consequentialFailedInstance);
            for (Map.Entry<PluginCandidate, Collection<PluginCandidate>> entry : this.cascadedFailure.entrySet()) {
                String error = entry.getValue().stream().map(x -> x.metadata().id()).collect(Collectors.joining(", "));
                mergedFailures.merge(entry.getKey(), error, (old, incoming) -> old + ", " + incoming);
            }
            errorPrinter.add();
            errorPrinter.add("The following plugins are not loading because they depend on plugins that will not load:");
            for (Map.Entry entry : mergedFailures.entrySet()) {
                errorPrinter.add(" * %s depends on [ %s ]", ((PluginCandidate)entry.getKey()).metadata().id(), entry.getValue());
            }
        }
        errorPrinter.add().hr().addWrapped("DO NOT REPORT THIS TO SPONGE. These errors are not Sponge errors, they are plugin loading errors. Seek support from the authors of the plugins listed above if you need help getting these plugins to load.", new Object[0]).add();
        errorPrinter.addWrapped("Your game will continue to start without the %d plugins listed above. Other plugins will continue to load, however you may wish to stop your game and fix these issues. For any missing dependencies, you may be able to find them at https://ore.spongepowered.org/. For any plugins that have cyclic dependencies or threw exceptions, it is likely a bug in the plugin.", noOfFailures);
        errorPrinter.log(logger, Level.ERROR);
    }

    private int numberOfFailures() {
        return this.missingDependencies.size() + this.versionMismatch.size() + this.cyclicDependency.size() + this.cascadedFailure.size();
    }
}

