/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.mixin.plugin;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.common.mixin.plugin.AbstractMixinConfigPlugin;

public class FabricSuperclassChangePlugin
extends AbstractMixinConfigPlugin {
    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        FabricSuperclassChangePlugin.transform(targetClass, mixinInfo.getClassNode(0));
    }

    private static void transform(ClassNode targetClass, ClassNode mixinClass) {
        AnnotationNode ann = Annotations.getInvisible((ClassNode)mixinClass, ChangeSuperclass.class);
        String newSuperclass = ((Type)Annotations.getValue((AnnotationNode)ann, (String)"value")).getClassName();
        String sanitizedSuperClass = newSuperclass.replace('.', '/');
        targetClass.methods.forEach(m -> FabricSuperclassChangePlugin.transformMethod(m, targetClass.superName, sanitizedSuperClass));
        targetClass.superName = sanitizedSuperClass;
    }

    private static void transformMethod(MethodNode node, String originalSuperclass, String superClass) {
        for (MethodInsnNode insn : FabricSuperclassChangePlugin.findSuper(node, originalSuperclass)) {
            insn.owner = superClass;
        }
    }

    private static List<MethodInsnNode> findSuper(MethodNode method, String originalSuperClass) {
        ArrayList<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode node : method.instructions.toArray()) {
            if (node.getOpcode() != 183 || !originalSuperClass.equals(((MethodInsnNode)node).owner)) continue;
            nodes.add((MethodInsnNode)node);
        }
        return nodes;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ChangeSuperclass {
        public Class<?> value();
    }
}

