/*
 * Decompiled with CFR 0.152.
 */
package dk.nelind.loofah.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.plugin.PluginContainer;

public final class PluginPackResources
extends class_3255 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PluginContainer container;
    private final class_3272 metadata;
    private final @Nullable Path pluginRoot;

    public PluginPackResources(class_9224 info, PluginContainer container, @Nullable Path pluginRoot) {
        super(info);
        this.container = container;
        this.metadata = new class_3272((class_2561)class_2561.method_43470((String)"Plugin Resources"), 6, Optional.empty());
        this.pluginRoot = pluginRoot;
    }

    public class_7367<InputStream> method_14410(String ... var1) {
        String rawPath = String.join((CharSequence)"/", var1);
        return this.getResource(rawPath);
    }

    private class_7367<InputStream> getResource(String rawPath) {
        Optional uri = this.container.locateResource(rawPath);
        if (uri.isEmpty()) {
            return null;
        }
        return () -> ((URI)uri.get()).toURL().openStream();
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 loc) {
        return this.getResource(String.format(Locale.ROOT, "%s/%s/%s", type.method_14413(), loc.method_12836(), loc.method_12832()));
    }

    public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 out) {
        try {
            Path root = this.typeRoot(type);
            Path namespaceDir = root.resolve(namespace);
            Path resourcesDir = namespaceDir.resolve(path);
            try (Stream<Path> stream = Files.walk(resourcesDir, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filePath -> !filePath.getFileName().toString().endsWith(".mcmeta")).map(namespaceDir::relativize).map(filePath -> this.convertResourcePath(namespace, (Path)filePath)).filter(Objects::nonNull).forEach(loc -> out.accept(loc, this.method_14405(type, (class_2960)loc)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private @Nullable class_2960 convertResourcePath(String namespace, Path resourcePath) {
        String path = resourcePath.toString();
        class_2960 location = class_2960.method_43902((String)namespace, (String)path);
        if (location == null) {
            LOGGER.warn("Invalid path in plugin pack: {}:{}, ignoring", (Object)namespace, (Object)path);
        }
        return location;
    }

    public <T> @Nullable T method_14407(class_3270<T> deserializer) throws IOException {
        if (deserializer.method_14420().equals("pack")) {
            return (T)this.metadata;
        }
        return null;
    }

    public Set<String> method_14406(class_3264 type) {
        block8: {
            Set<String> set;
            block9: {
                @Nullable Path root = this.typeRoot(type);
                if (root == null) break block8;
                Stream<Path> stream = Files.list(root);
                try {
                    set = stream.map(Path::getFileName).map(Object::toString).filter(s -> {
                        if (s.equals(s.toLowerCase(Locale.ROOT))) {
                            return true;
                        }
                        SpongeCommon.logger().warn("Pack: ignored non-lowercased namespace: {} in {}", s, (Object)root.toAbsolutePath().toString());
                        return false;
                    }).collect(Collectors.toSet());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return set;
        }
        return Collections.emptySet();
    }

    public void close() {
    }

    private @Nullable Path typeRoot(class_3264 type) throws IOException {
        if (this.pluginRoot == null) {
            return null;
        }
        return this.pluginRoot.resolve(type.method_14413());
    }
}

