/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.class_155;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.scheduler.ServerScheduler;

@Singleton
public final class SpongeCommon {
    private static final Logger LOGGER = LogManager.getLogger((String)((Launch)Launch.instance()).id());
    private static final SpongeMinecraftVersion MINECRAFT_VERSION = new SpongeMinecraftVersion(class_155.method_16673().method_48019(), class_155.method_16673().method_48020());
    @Inject
    private static @Nullable SpongeGame game;
    private static @MonotonicNonNull Path pluginConfigDir;

    private SpongeCommon() {
    }

    public static boolean initialized() {
        return game != null;
    }

    public static Logger logger() {
        return LOGGER;
    }

    public static SpongeMinecraftVersion minecraftVersion() {
        return MINECRAFT_VERSION;
    }

    public static SpongeGame game() {
        if (game == null) {
            throw new IllegalStateException("SpongeCommon has not been initialized yet!");
        }
        return game;
    }

    public static MinecraftServer server() {
        return (MinecraftServer)Sponge.server();
    }

    public static class_5455.class_6890 vanillaRegistryAccess() {
        return SpongeCommon.server().method_30611();
    }

    public static <E> class_2378<E> vanillaRegistry(class_5321<? extends class_2378<? extends E>> key) {
        return SpongeCommon.vanillaRegistryAccess().method_30530(key);
    }

    public static ServerScheduler serverScheduler() {
        return (ServerScheduler)Sponge.server().scheduler();
    }

    public static AsyncScheduler asyncScheduler() {
        return SpongeCommon.game().asyncScheduler();
    }

    public static Path gameDirectory() {
        return AppLaunch.pluginPlatform().baseDirectory();
    }

    public static Path pluginConfigDirectory() {
        if (pluginConfigDir == null) {
            pluginConfigDir = Paths.get(AppLaunch.pluginPlatform().tokens().replace(SpongeConfigs.getCommon().get().general.pluginConfigDir), new String[0]);
        }
        return pluginConfigDir;
    }

    public static boolean post(Event event) {
        return Sponge.eventManager().post(event);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            @Nullable SpongeGame game = game;
            if (game != null) {
                try {
                    game.configManager().close();
                }
                catch (IOException e) {
                    SpongeCommon.logger().error("Failed to shut down configuration watch service", (Throwable)e);
                }
            }
        }, "Sponge shutdown thread"));
    }
}

