/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7712;
import net.minecraft.class_7923;
import org.spongepowered.api.Client;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.plugin.DummyPluginContainer;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.packs.resources.ResourceManagerBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.event.lifecycle.AbstractRegisterRegistryEvent;
import org.spongepowered.common.event.lifecycle.AbstractRegisterRegistryValueEvent;
import org.spongepowered.common.event.lifecycle.RegisterBuilderEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterChannelEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterDataEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterFactoryEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterTagEventImpl;
import org.spongepowered.common.event.manager.SpongeEventManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.registry.SpongeBuilderProvider;
import org.spongepowered.common.registry.SpongeFactoryProvider;
import org.spongepowered.common.registry.SpongeRegistries;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.service.SpongeServiceProvider;
import org.spongepowered.common.service.server.permission.SpongeContextCalculator;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeLifecycle
implements Lifecycle {
    private final Game game;
    private final Injector injector;
    private class_7699 featureFlags;
    public boolean establishedPluginRegistries = false;

    @Inject
    public SpongeLifecycle(Game game, Injector injector) {
        this.game = game;
        this.injector = injector;
    }

    @Override
    public Injector platformInjector() {
        return this.injector;
    }

    @Override
    public void establishFactories() {
        ((SpongeFactoryProvider)this.game.factoryProvider()).registerDefaultFactories();
    }

    @Override
    public void establishBuilders() {
        ((SpongeBuilderProvider)this.game.builderProvider()).registerDefaultBuilders();
        ((SpongeDataManager)this.game.dataManager()).registerDefaultBuilders();
    }

    @Override
    public void callRegisterFactoryEvent() {
        this.game.eventManager().post((Event)new RegisterFactoryEventImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game));
    }

    @Override
    public void callRegisterBuilderEvent() {
        this.game.eventManager().post((Event)new RegisterBuilderEventImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game));
    }

    @Override
    public void establishEarlyGlobalRegistries() {
        SpongeRegistryHolder holder = (SpongeRegistryHolder)this.game;
        holder.setRootMinecraftRegistry(class_7923.field_41167);
        SpongeRegistries.registerEarlyGlobalRegistries(holder);
    }

    @Override
    public void finalizeEarlyGlobalRegistries() {
        this.game.eventManager().post(new AbstractRegisterRegistryValueEvent.BuiltInImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game, (Registry)class_7923.field_47496));
    }

    @Override
    public void establishGlobalRegistries(class_5455.class_6890 registryAccess, class_7659 layer) {
        SpongeRegistryHolder holder = (SpongeRegistryHolder)this.game;
        SpongeCommon.logger().info("Layer {}", (Object)layer);
        switch (layer) {
            case field_39973: {
                SpongeRegistries.registerGlobalRegistriesDimensionLayer((SpongeRegistryHolder)this.game, registryAccess, this.featureFlags);
                this.game.eventManager().post((Event)new AbstractRegisterRegistryEvent.GameScopedImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game));
                holder.registryHolder().freezeSpongeRootRegistry();
                break;
            }
            case field_39974: {
                if (this.establishedPluginRegistries) break;
                this.game.eventManager().post((Event)new AbstractRegisterRegistryValueEvent.GameScopedImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game));
                holder.registryHolder().freezeSpongeDynamicRegistries();
                this.establishedPluginRegistries = true;
            }
        }
    }

    @Override
    public void callRegisterDataEvent() {
        this.game.eventManager().post((Event)new RegisterDataEventImpl(Cause.of((EventContext)EventContext.empty(), (Object)Sponge.game()), Sponge.game(), (SpongeDataManager)this.game.dataManager()));
    }

    @Override
    public void establishDataProviders() {
        ((SpongeDataManager)this.game.dataManager()).registerDefaultProviders();
    }

    @Override
    public void establishDataKeyListeners() {
        ((SpongeDataManager)this.game.dataManager()).registerKeyListeners();
    }

    @Override
    public void callRegisterChannelEvent() {
        this.game.eventManager().post((Event)new RegisterChannelEventImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game, (SpongeChannelManager)this.game.channelManager()));
    }

    @Override
    public void establishGameServices() {
        ((SpongeServiceProvider)this.game.serviceProvider()).init();
    }

    @Override
    public void establishServerServices() {
        ((MinecraftServerBridge)this.game.server()).bridge$initServices(this.game, this.injector);
    }

    @Override
    public void establishServerFeatures() {
        Sponge.server().serviceProvider().contextService().registerContextCalculator((ContextCalculator)new SpongeContextCalculator());
        ((SpongeServer)this.game.server()).getUsernameCache().load();
    }

    @Override
    public void callConstructEvent() {
        for (PluginContainer plugin : this.filterInternalPlugins(this.game.pluginManager().plugins())) {
            ((SpongeEventManager)this.game.eventManager()).postToPlugin((Event)SpongeEventFactory.createConstructPluginEvent((Cause)Cause.of((EventContext)EventContext.empty(), (Object)this.game), (Game)this.game, (PluginContainer)plugin), plugin);
        }
    }

    @Override
    public void establishServerRegistries(Server server) {
        SpongeRegistries.registerServerRegistries((RegistryHolder)server);
        this.game.eventManager().post(new AbstractRegisterRegistryEvent.EngineScopedImpl<Server>(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game, server));
        ((SpongeRegistryHolder)server).registryHolder().freezeSpongeRootRegistry();
        this.game.eventManager().post(new AbstractRegisterRegistryValueEvent.EngineScopedImpl<Server>(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game, server));
        ((SpongeRegistryHolder)server).registryHolder().freezeSpongeDynamicRegistries();
    }

    @Override
    public void establishClientRegistries(Client client) {
        this.game.eventManager().post(new AbstractRegisterRegistryEvent.EngineScopedImpl<Client>(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game, client));
        ((SpongeRegistryHolder)client).registryHolder().freezeSpongeRootRegistry();
        this.game.eventManager().post(new AbstractRegisterRegistryValueEvent.EngineScopedImpl<Client>(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game, client));
        ((SpongeRegistryHolder)client).registryHolder().freezeSpongeDynamicRegistries();
    }

    @Override
    public void callStartingEngineEvent(Engine engine) {
        this.game.eventManager().post((Event)SpongeEventFactory.createStartingEngineEvent((Cause)PhaseTracker.getInstance().currentCause(), (Engine)engine, (Game)this.game, (TypeToken)TypeToken.get((Class)engine.getClass())));
    }

    @Override
    public void callStartedEngineEvent(Engine engine) {
        this.game.eventManager().post((Event)SpongeEventFactory.createStartedEngineEvent((Cause)PhaseTracker.getInstance().currentCause(), (Engine)engine, (Game)this.game, (TypeToken)TypeToken.get((Class)engine.getClass())));
    }

    @Override
    public void callLoadedGameEvent() {
        this.game.eventManager().post((Event)SpongeEventFactory.createLoadedGameEvent((Cause)PhaseTracker.getInstance().currentCause(), (Game)this.game));
    }

    @Override
    public void callStoppingEngineEvent(Engine engine) {
        SpongeGameProfileManager profileManager;
        this.game.eventManager().post((Event)SpongeEventFactory.createStoppingEngineEvent((Cause)PhaseTracker.getInstance().currentCause(), (Engine)engine, (Game)this.game, (TypeToken)TypeToken.get((Class)engine.getClass())));
        if (engine instanceof SpongeServer && (profileManager = ((SpongeServer)engine).gameProfileManagerIfPresent()) != null) {
            profileManager.close();
        }
    }

    @Override
    public void callStoppedGameEvent() {
        this.game.eventManager().post((Event)SpongeEventFactory.createStoppedGameEvent((Cause)PhaseTracker.getInstance().currentCause(), (Game)this.game));
        ((AsyncScheduler)this.game.asyncScheduler()).close();
    }

    @Override
    public void setWorldDataConfiguration(class_7712 config) {
        this.featureFlags = config.comp_1011();
    }

    private Collection<PluginContainer> filterInternalPlugins(Collection<PluginContainer> plugins) {
        return plugins.stream().filter(plugin -> !(plugin instanceof DummyPluginContainer)).collect(Collectors.toList());
    }

    @Override
    public void establishTags(class_3300 resourceManager) {
        RegisterTagEventImpl event = new RegisterTagEventImpl(Cause.of((EventContext)EventContext.empty(), (Object)this.game), this.game);
        this.game.eventManager().post((Event)event);
        ((ResourceManagerBridge)resourceManager).bridge$pluginProvidedTags(event.tags());
    }
}

