/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_8782;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.AdvancementTemplate;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.SpongeAdvancementTemplate;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.SpongeCriterionUtil;

public final class SpongeAdvancementBuilder
extends AbstractResourceKeyedBuilder<AdvancementTemplate, AdvancementTemplate.Builder>
implements AdvancementTemplate.Builder.RootStep {
    private @Nullable class_2960 parent;
    private AdvancementCriterion criterion;
    private @Nullable DisplayInfo displayInfo;
    private @Nullable class_2960 backgroundPath;
    private DataPack<AdvancementTemplate> pack = DataPacks.ADVANCEMENT;

    public SpongeAdvancementBuilder() {
        this.reset();
    }

    public AdvancementTemplate.Builder parent(@Nullable AdvancementTemplate parent) {
        return this.parent(parent.key());
    }

    public AdvancementTemplate.Builder parent(@Nullable ResourceKey parent) {
        this.parent = (class_2960)parent;
        this.backgroundPath = null;
        return this;
    }

    public AdvancementTemplate.Builder.RootStep root() {
        this.parent = null;
        return this;
    }

    public AdvancementTemplate.Builder background(ResourceKey backgroundPath) {
        this.backgroundPath = (class_2960)backgroundPath;
        return this;
    }

    public AdvancementTemplate.Builder criterion(AdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        this.criterion = criterion;
        return this;
    }

    public AdvancementTemplate.Builder displayInfo(@Nullable DisplayInfo displayInfo) {
        this.displayInfo = displayInfo;
        return this;
    }

    public AdvancementTemplate.Builder reset() {
        this.criterion = AdvancementCriterion.empty();
        this.displayInfo = null;
        this.parent = null;
        this.backgroundPath = null;
        this.pack = DataPacks.ADVANCEMENT;
        return this;
    }

    @Override
    public AdvancementTemplate build0() {
        Tuple<Map<String, class_175<?>>, List<List<String>>> result = SpongeCriterionUtil.toVanillaCriteriaData(this.criterion);
        class_170 rewards = class_170.field_1167;
        Optional<class_185> displayInfo = Optional.ofNullable(this.displayInfo).map(di -> new class_185(ItemStackUtil.fromSnapshotToNative(di.icon()), SpongeAdventure.asVanilla(di.title()), SpongeAdventure.asVanilla(di.description()), Optional.ofNullable(this.backgroundPath), (class_189)di.type(), di.doesShowToast(), di.doesAnnounceToChat(), di.isHidden()));
        class_161 advancement = new class_161(Optional.ofNullable(this.parent), displayInfo, rewards, (Map)result.first(), new class_8782((List)result.second()), false);
        ((AdvancementBridge)advancement).bridge$setCriterion(this.criterion);
        return new SpongeAdvancementTemplate(this.key, advancement, this.pack);
    }
}

