/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.advancement.AdvancementTypes;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.util.Preconditions;

public final class SpongeDisplayInfoBuilder
implements DisplayInfo.Builder {
    private AdvancementType advancementType;
    private Component description;
    private Component title;
    private ItemStackSnapshot icon;
    private boolean showToast;
    private boolean announceToChat;
    private boolean hidden;

    public SpongeDisplayInfoBuilder() {
        this.reset();
    }

    public DisplayInfo.Builder type(AdvancementType advancementType) {
        Objects.requireNonNull(advancementType, "advancementType");
        this.advancementType = advancementType;
        return this;
    }

    public DisplayInfo.Builder description(Component description) {
        Objects.requireNonNull(description, "description");
        this.description = description;
        return this;
    }

    public DisplayInfo.Builder title(Component title) {
        Objects.requireNonNull(title, "title");
        this.title = title;
        return this;
    }

    public DisplayInfo.Builder icon(ItemStackLike itemStack) {
        Objects.requireNonNull(itemStack, "itemStackSnapshot");
        this.icon = itemStack.asImmutable();
        return this;
    }

    public DisplayInfo.Builder showToast(boolean showToast) {
        this.showToast = showToast;
        return this;
    }

    public DisplayInfo.Builder announceToChat(boolean announceToChat) {
        this.announceToChat = announceToChat;
        return this;
    }

    public DisplayInfo.Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public DisplayInfo build() {
        Preconditions.checkState(this.title != null, "Title has not been set");
        Preconditions.checkState(this.icon != null, "Icon has not been set");
        class_2561 title = SpongeAdventure.asVanilla(this.title);
        class_2561 description = SpongeAdventure.asVanilla(this.description);
        class_189 frameType = (class_189)this.advancementType;
        class_1799 icon = (class_1799)this.icon.asMutable();
        return (DisplayInfo)new class_185(icon, title, description, null, frameType, this.showToast, this.announceToChat, this.hidden);
    }

    public DisplayInfo.Builder from(DisplayInfo value) {
        this.icon = value.icon();
        this.description = value.description();
        this.advancementType = value.type();
        this.announceToChat = value.doesAnnounceToChat();
        this.hidden = value.isHidden();
        this.showToast = value.doesShowToast();
        this.title = value.title();
        return this;
    }

    public DisplayInfo.Builder reset() {
        this.icon = null;
        this.description = Component.empty();
        this.advancementType = (AdvancementType)AdvancementTypes.TASK.get();
        this.announceToChat = true;
        this.hidden = false;
        this.showToast = true;
        this.title = null;
        return this;
    }
}

