/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.leangen.geantyref.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.SpongeCriterionTrigger;
import org.spongepowered.common.data.persistence.JsonDataFormat;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;

public final class SpongeTriggerBuilder<C extends FilteredTriggerConfiguration>
implements Trigger.Builder<C> {
    private static final Gson GSON = new Gson();
    private static final FilteredTriggerConfiguration.Empty EMPTY_TRIGGER_CONFIGURATION = new FilteredTriggerConfiguration.Empty();
    private static final Function<JsonObject, FilteredTriggerConfiguration.Empty> EMPTY_TRIGGER_CONFIGURATION_CONSTRUCTOR = jsonObject -> EMPTY_TRIGGER_CONFIGURATION;
    private @Nullable Type configType;
    private @Nullable Function<JsonObject, C> constructor;
    private @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    CriterionEvent.Trigger<C>> eventHandler;
    private @Nullable String name;

    public <T extends FilteredTriggerConfiguration & DataSerializable> Trigger.Builder<T> dataSerializableConfig(Class<T> dataConfigClass) {
        Objects.requireNonNull(dataConfigClass, "dataConfigClass");
        this.configType = dataConfigClass;
        this.constructor = new DataSerializableConstructor<T>(dataConfigClass);
        return this;
    }

    private static ConfigurationOptions defaultOptions() {
        return ConfigurationOptions.defaults().serializers(SpongeCommon.game().configManager().serializers());
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(TypeToken<T> configType) {
        return this.typeSerializableConfig(configType, SpongeTriggerBuilder.defaultOptions());
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(TypeToken<T> configType, ConfigurationOptions options) {
        Objects.requireNonNull(configType, "configType");
        Objects.requireNonNull(options, "options");
        this.configType = configType.getType();
        this.constructor = new ConfigurateConstructor(configType.getType(), options);
        return this;
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(TypeToken<T> configType, UnaryOperator<ConfigurationOptions> transformer) {
        return this.typeSerializableConfig(configType, (ConfigurationOptions)transformer.apply(SpongeTriggerBuilder.defaultOptions()));
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass) {
        return this.typeSerializableConfig(configClass, SpongeTriggerBuilder.defaultOptions());
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass, ConfigurationOptions options) {
        Objects.requireNonNull(configClass, "configClass");
        Objects.requireNonNull(options, "options");
        this.configType = configClass;
        this.constructor = new ConfigurateConstructor(configClass, options);
        return this;
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass, UnaryOperator<ConfigurationOptions> transformer) {
        Objects.requireNonNull(transformer, "transformer");
        return this.typeSerializableConfig(configClass, (ConfigurationOptions)transformer.apply(SpongeTriggerBuilder.defaultOptions()));
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> jsonSerializableConfig(Class<T> configClass, Gson gson) {
        Objects.requireNonNull(configClass, "configClass");
        this.configType = configClass;
        this.constructor = new JsonConstructor(configClass, gson);
        return this;
    }

    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> jsonSerializableConfig(Class<T> configClass) {
        return this.jsonSerializableConfig(configClass, GSON);
    }

    public Trigger.Builder<FilteredTriggerConfiguration.Empty> emptyConfig() {
        this.configType = FilteredTriggerConfiguration.Empty.class;
        this.constructor = EMPTY_TRIGGER_CONFIGURATION_CONSTRUCTOR;
        return this;
    }

    public Trigger.Builder<C> listener(Consumer<CriterionEvent.Trigger<C>> eventListener) {
        this.eventHandler = eventListener;
        return this;
    }

    public Trigger.Builder<C> name(String name) {
        Objects.requireNonNull(name, "name");
        this.name = name;
        return this;
    }

    public Trigger<C> build() {
        Objects.requireNonNull(this.name, "name");
        Preconditions.checkState(!this.name.isEmpty(), "The name cannot be empty!");
        Preconditions.checkState(this.configType != null, "The configType must be set");
        return (Trigger)new SpongeCriterionTrigger(this.configType, this.constructor, this.eventHandler, this.name);
    }

    public Trigger.Builder<C> from(Trigger<C> value) {
        this.configType = value.configurationType();
        if (value instanceof SpongeCriterionTrigger) {
            this.constructor = ((SpongeCriterionTrigger)value).constructor;
            this.eventHandler = ((SpongeCriterionTrigger)value).getEventHandler();
            this.name = ((SpongeCriterionTrigger)value).getName();
        }
        return this;
    }

    public Trigger.Builder<C> reset() {
        this.configType = null;
        this.constructor = null;
        this.eventHandler = null;
        this.name = null;
        return this;
    }

    private static class DataSerializableConstructor<C extends FilteredTriggerConfiguration & DataSerializable>
    implements Function<JsonObject, C> {
        private final Class<C> dataConfigClass;

        private DataSerializableConstructor(Class<C> dataConfigClass) {
            this.dataConfigClass = dataConfigClass;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            DataBuilder builder = (DataBuilder)Sponge.dataManager().builder(this.dataConfigClass).get();
            try {
                DataContainer dataView = JsonDataFormat.serialize(GSON, jsonObject);
                return (C)((FilteredTriggerConfiguration)builder.build((DataView)dataView).get());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class ConfigurateConstructor<C extends FilteredTriggerConfiguration>
    implements Function<JsonObject, C> {
        private final Type typeToken;
        private final ConfigurationOptions options;

        private ConfigurateConstructor(Type typeToken, ConfigurationOptions options) {
            this.typeToken = typeToken;
            this.options = options;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().defaultOptions(this.options)).source(() -> new BufferedReader(new StringReader(GSON.toJson((JsonElement)jsonObject))))).build();
            try {
                ConfigurationNode node = loader.load();
                return (C)((FilteredTriggerConfiguration)node.get(this.typeToken));
            }
            catch (ConfigurateException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class JsonConstructor<C extends FilteredTriggerConfiguration>
    implements Function<JsonObject, C> {
        private final Type configClass;
        private final Gson gson;

        private JsonConstructor(Type configClass, Gson gson) {
            this.configClass = configClass;
            this.gson = gson;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            return (C)((FilteredTriggerConfiguration)this.gson.fromJson((JsonElement)jsonObject, this.configClass));
        }
    }
}

