/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement.criterion;

import java.time.Instant;
import java.util.Optional;
import net.minecraft.class_3532;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.advancement.criteria.ScoreCriterionProgress;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.server.PlayerAdvancementsBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Preconditions;

public class SpongeScoreCriterionProgress
implements ScoreCriterionProgress,
ImplementationBackedCriterionProgress {
    private final SpongeScoreCriterion criterion;
    private final AdvancementProgress progress;
    private int score = -1;

    public SpongeScoreCriterionProgress(AdvancementProgress progress, SpongeScoreCriterion criterion) {
        this.criterion = criterion;
        this.progress = progress;
    }

    public ScoreAdvancementCriterion criterion() {
        return this.criterion;
    }

    public int score() {
        if (this.score == -1) {
            this.score = 0;
            for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
                Optional time1 = ((CriterionProgress)this.progress.get(advancementCriterion).get()).get();
                if (!time1.isPresent()) continue;
                ++this.score;
            }
        }
        return this.score;
    }

    public Optional<Instant> set(int score) {
        Preconditions.checkState(score >= 0 && score <= this.goal(), "Score cannot be negative or greater than the goal.");
        int lastScore = this.score();
        if (lastScore == score) {
            return this.get();
        }
        Cause cause = PhaseTracker.getInstance().currentCause();
        Advancement advancement = this.progress.advancement();
        ResourceKey advancementKey = (ResourceKey)((AdvancementProgressBridge)this.progress).bridge$getAdvancementKey();
        ServerPlayer player = ((PlayerAdvancementsBridge)((AdvancementProgressBridge)this.progress).bridge$getPlayerAdvancements()).bridge$getPlayer();
        Object event = lastScore == this.goal() ? SpongeEventFactory.createCriterionEventScoreRevoke((Cause)cause, (Advancement)advancement, (ResourceKey)advancementKey, (ScoreAdvancementCriterion)this.criterion(), (ServerPlayer)player, (int)lastScore, (int)score) : (score == this.goal() ? SpongeEventFactory.createCriterionEventScoreGrant((Cause)cause, (Advancement)advancement, (ResourceKey)advancementKey, (ScoreAdvancementCriterion)this.criterion(), (ServerPlayer)player, (Instant)Instant.now(), (int)lastScore, (int)score) : SpongeEventFactory.createCriterionEventScoreChange((Cause)cause, (Advancement)advancement, (ResourceKey)advancementKey, (ScoreAdvancementCriterion)this.criterion(), (ServerPlayer)player, (int)lastScore, (int)score));
        if (SpongeCommon.post((Event)event)) {
            return this.get();
        }
        SpongeScoreCriterion.BYPASS_EVENT = true;
        if (score == this.goal()) {
            Instant instant = null;
            for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
                CriterionProgress progress = (CriterionProgress)this.progress.get(advancementCriterion).get();
                if (progress.achieved()) continue;
                instant = progress.grant();
            }
            this.score = score;
            return Optional.of(instant == null ? Instant.now() : instant);
        }
        for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
            CriterionProgress criterionProgress = (CriterionProgress)this.progress.get(advancementCriterion).get();
            if (lastScore < score && !criterionProgress.achieved()) {
                criterionProgress.grant();
                ++lastScore;
            } else if (lastScore > score && criterionProgress.achieved()) {
                criterionProgress.revoke();
                --lastScore;
            }
            if (lastScore != score) continue;
            break;
        }
        this.score = score;
        SpongeScoreCriterion.BYPASS_EVENT = false;
        return Optional.empty();
    }

    public Optional<Instant> add(int score) {
        return this.set(class_3532.method_15340((int)(this.score() + score), (int)0, (int)this.goal()));
    }

    public Optional<Instant> remove(int score) {
        return this.set(class_3532.method_15340((int)(this.score() - score), (int)0, (int)this.goal()));
    }

    public Optional<Instant> get() {
        Optional time = Optional.empty();
        for (AdvancementCriterion advancementCriterion : this.criterion.internalCriteria) {
            Optional time1 = ((CriterionProgress)this.progress.get(advancementCriterion).get()).get();
            if (!time1.isPresent()) {
                return Optional.empty();
            }
            if (time.isPresent() && !((Instant)time1.get()).isAfter((Instant)time.get())) continue;
            time = time1;
        }
        return time;
    }

    public Instant grant() {
        return this.set(this.goal()).get();
    }

    public Optional<Instant> revoke() {
        Optional<Instant> previousState = this.get();
        this.set(0);
        return previousState;
    }

    @Override
    public void invalidateAchievedState() {
        this.score = -1;
    }
}

