/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.leangen.geantyref.TypeToken;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.common.command.SpongeCommandCompletion;

public final class CallbackCommand {
    public static final String NAME = "callback";
    public static final CallbackCommand INSTANCE = new CallbackCommand();
    private final Cache<UUID, Consumer<CommandCause>> callbacks = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).build();

    private CallbackCommand() {
    }

    public Command.Parameterized createCommand() {
        this.callbacks.invalidateAll();
        Parameter.Key key = Parameter.key((String)"key", (TypeToken)new TypeToken<Consumer<CommandCause>>(this){});
        return Command.builder().shortDescription((Component)Component.text((String)"Execute a callback registered as part of a TextComponent. Primarily for internal use")).addParameter((Parameter)Parameter.builder((Parameter.Key)key).addParser((ValueParser)new CallbackValueParameter()).build()).executor(context -> {
            ((Consumer)context.requireOne(key)).accept(context.cause());
            return CommandResult.success();
        }).build();
    }

    public UUID registerCallback(Consumer<CommandCause> callback) {
        UUID key = UUID.randomUUID();
        this.callbacks.put((Object)key, callback);
        return key;
    }

    private final class CallbackValueParameter
    implements ValueParameter<Consumer<CommandCause>> {
        private CallbackValueParameter() {
        }

        public List<CommandCompletion> complete(@NonNull CommandContext context, @NonNull String currentInput) {
            return CallbackCommand.this.callbacks.asMap().keySet().stream().map(UUID::toString).filter(string -> string.startsWith(currentInput)).map(SpongeCommandCompletion::new).collect(Collectors.toList());
        }

        public @NonNull Optional<? extends Consumer<CommandCause>> parseValue(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Parameter.Key<? super Consumer<CommandCause>> parameterKey, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ArgumentReader.Mutable reader, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull CommandContext.Builder context) throws ArgumentParseException {
            String next = reader.parseString();
            try {
                UUID id = UUID.fromString(next);
                Consumer ret = (Consumer)CallbackCommand.this.callbacks.getIfPresent((Object)id);
                if (ret == null) {
                    throw reader.createException((Component)Component.text((String)"The callback you provided was not valid. Keep in mind that callbacks will expire after 10 minutes, so you might want to consider clicking faster next time!"));
                }
                return Optional.of(ret);
            }
            catch (IllegalArgumentException ex) {
                throw reader.createException((Component)Component.text((String)("Input " + next + " was not a valid UUID")));
            }
        }
    }
}

