/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.Codec;
import net.kyori.adventure.util.TriState;
import net.minecraft.class_10104;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2522;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2572;
import net.minecraft.class_2574;
import net.minecraft.class_2575;
import net.minecraft.class_2576;
import net.minecraft.class_2578;
import net.minecraft.class_2579;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3419;
import net.minecraft.class_4616;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7419;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8828;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.adventure.ResolveOperation;
import org.spongepowered.api.adventure.SpongeComponents;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.chat.HoverEvent_ItemStackInfoAccessor;
import org.spongepowered.common.accessor.network.chat.StyleAccessor;
import org.spongepowered.common.adventure.AdventureTextComponent;
import org.spongepowered.common.adventure.CallbackCommand;
import org.spongepowered.common.adventure.ComponentFlattenerProvider;
import org.spongepowered.common.adventure.SpongeResolveOperation;
import org.spongepowered.common.bridge.adventure.BossBarBridge;
import org.spongepowered.common.bridge.adventure.ComponentBridge;
import org.spongepowered.common.bridge.adventure.StyleBridge;
import org.spongepowered.common.bridge.world.BossEventBridge;
import org.spongepowered.common.launch.Launch;

public final class SpongeAdventure {
    public static final AttributeKey<Locale> CHANNEL_LOCALE = AttributeKey.newInstance((String)"sponge:locale");
    public static final Codec<class_2487, String, IOException, IOException> NBT_CODEC = new Codec<class_2487, String, IOException, IOException>(){

        public @NonNull class_2487 decode(@NonNull String encoded) throws IOException {
            try {
                return class_2522.method_10718((String)encoded);
            }
            catch (CommandSyntaxException e) {
                throw new IOException(e);
            }
        }

        public @NonNull String encode(@NonNull class_2487 decoded) {
            return decoded.toString();
        }
    };
    public static final PrimitiveCodec<Component> STRING_CODEC = new PrimitiveCodec<Component>(){

        public <T> DataResult<Component> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).deserialize(arg_0));
        }

        public <T> T write(DynamicOps<T> ops, Component value) {
            return (T)ops.createString((String)GsonComponentSerializer.gson().serialize(value));
        }

        public String toString() {
            return "String[Component]";
        }
    };
    public static final ConfigurateComponentSerializer CONFIGURATE = ConfigurateComponentSerializer.builder().scalarSerializer((ComponentSerializer)GsonComponentSerializer.gson()).build();
    private static final Set<class_3213> ACTIVE_BOSS_BARS = ConcurrentHashMap.newKeySet();
    public static final ThreadLocal<Locale> ENCODING_LOCALE = new ThreadLocal();

    public static TriState asAdventure(Tristate state) {
        if (state == Tristate.UNDEFINED) {
            return TriState.NOT_SET;
        }
        if (state == Tristate.FALSE) {
            return TriState.FALSE;
        }
        if (state == Tristate.TRUE) {
            return TriState.TRUE;
        }
        throw new IllegalArgumentException(state.name());
    }

    public static Key asAdventure(class_2960 key) {
        return (Key)key;
    }

    public static class_2556.class_7602 asVanilla(class_5455 access, ChatType.Bound adv) {
        ChatType.Bound bound = adv;
        if (bound instanceof class_2556.class_7602) {
            class_2556.class_7602 vanilla = (class_2556.class_7602)bound;
            return vanilla;
        }
        class_2556.class_7602 vanilla = class_2556.method_44834((class_5321)class_5321.method_29179((class_5321)class_7924.field_41237, (class_2960)SpongeAdventure.asVanilla(adv.type().key())), (class_5455)access, (class_2561)SpongeAdventure.asVanilla(adv.name()));
        if (adv.target() != null) {
            vanilla = vanilla.method_44839(SpongeAdventure.asVanilla(adv.target()));
        }
        return vanilla;
    }

    public static @Nullable class_2561 asVanillaNullable(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(component);
    }

    public static class_2561 asVanilla(Component component) {
        return new AdventureTextComponent(component, (ComponentRenderer<Locale>)GlobalTranslator.renderer());
    }

    public static Optional<class_2561> asVanillaOpt(@Nullable Component component) {
        return component == null ? Optional.empty() : Optional.of(((ComponentBridge)component).bridge$asVanillaComponent());
    }

    public static class_5250 asVanillaMutable(Component component) {
        class_5250 vanilla = SpongeAdventure.asVanillaMutable0(component);
        for (Component child : component.children()) {
            vanilla.method_10852(((ComponentBridge)child).bridge$asVanillaComponent());
        }
        vanilla.method_10862(((StyleBridge)component.style()).bridge$asVanilla());
        return vanilla;
    }

    private static class_5250 asVanillaMutable0(Component component) {
        if (component instanceof TextComponent) {
            return class_2561.method_43470((String)((TextComponent)component).content());
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent $this = (TranslatableComponent)component;
            ArrayList<class_2561> with = new ArrayList<class_2561>($this.args().size());
            for (Component arg : $this.args()) {
                with.add(((ComponentBridge)arg).bridge$asVanillaComponent());
            }
            return class_2561.method_43469((String)$this.key(), (Object[])with.toArray(new Object[0]));
        }
        if (component instanceof KeybindComponent) {
            return class_2561.method_43472((String)((KeybindComponent)component).keybind());
        }
        if (component instanceof ScoreComponent) {
            ScoreComponent $this = (ScoreComponent)component;
            return class_2561.method_43466((String)$this.name(), (String)$this.objective());
        }
        if (component instanceof SelectorComponent) {
            SelectorComponent $this = (SelectorComponent)component;
            return class_2561.method_43467((class_10104)((class_10104)class_10104.method_62667((String)$this.pattern()).getOrThrow()), SpongeAdventure.asVanillaOpt($this.separator()));
        }
        if (component instanceof NBTComponent) {
            if (component instanceof BlockNBTComponent) {
                BlockNBTComponent $this = (BlockNBTComponent)component;
                return class_2561.method_43468((String)$this.nbtPath(), (boolean)$this.interpret(), SpongeAdventure.asVanillaOpt($this.separator()), (class_7419)new class_2575($this.pos().asString()));
            }
            if (component instanceof EntityNBTComponent) {
                EntityNBTComponent $this = (EntityNBTComponent)component;
                return class_2561.method_43468((String)$this.nbtPath(), (boolean)$this.interpret(), SpongeAdventure.asVanillaOpt($this.separator()), (class_7419)new class_2576($this.selector()));
            }
            if (component instanceof StorageNBTComponent) {
                StorageNBTComponent $this = (StorageNBTComponent)component;
                return class_2561.method_43468((String)$this.nbtPath(), (boolean)$this.interpret(), SpongeAdventure.asVanillaOpt($this.separator()), (class_7419)new class_4616(SpongeAdventure.asVanilla($this.storage())));
            }
        }
        throw new UnsupportedOperationException("Cannot convert Component of type " + String.valueOf(component.getClass()));
    }

    public static Component asAdventure(class_2561 component) {
        if (component instanceof AdventureTextComponent) {
            AdventureTextComponent ac = (AdventureTextComponent)component;
            return ac.wrapped();
        }
        ComponentBuilder<?, ?> builder = SpongeAdventure.asAdventureBuilder(component.method_10851());
        for (class_2561 child : component.method_10855()) {
            builder.append(SpongeAdventure.asAdventure(child));
        }
        builder.style(((org.spongepowered.common.bridge.network.chat.StyleBridge)component.method_10866()).bridge$asAdventure());
        return builder.build();
    }

    private static ComponentBuilder<?, ?> asAdventureBuilder(class_7417 contents) {
        if (contents instanceof class_8828) {
            class_8828 lc = (class_8828)contents;
            if (contents == class_8828.field_46625) {
                return Component.empty().toBuilder();
            }
            return Component.text().content(lc.comp_737());
        }
        if (contents instanceof class_2588) {
            class_2588 tc = (class_2588)contents;
            List<Component> argList = Arrays.stream(tc.method_11023()).map(arg -> {
                TextComponent textComponent;
                if (arg instanceof class_2561) {
                    class_2561 argComponent = (class_2561)arg;
                    textComponent = SpongeAdventure.asAdventure(argComponent);
                } else {
                    textComponent = Component.text((String)arg.toString());
                }
                return textComponent;
            }).toList();
            return Component.translatable().key(tc.method_11022()).args(argList);
        }
        if (contents instanceof class_2572) {
            class_2572 kc = (class_2572)contents;
            return Component.keybind().keybind(kc.method_10901());
        }
        if (contents instanceof class_2578) {
            class_2578 sc = (class_2578)contents;
            return Component.score().name((String)sc.comp_3078().mapLeft(class_10104::comp_3067).orThrow()).objective(sc.comp_3079());
        }
        if (contents instanceof class_2579) {
            class_2579 sc = (class_2579)contents;
            return Component.selector().pattern(sc.comp_3080().comp_3067()).separator((ComponentLike)SpongeAdventure.asAdventure(sc.comp_3081()));
        }
        if (contents instanceof class_2574) {
            BlockNBTComponent.Builder nbtBuilder;
            class_2574 nc = (class_2574)contents;
            class_7419 class_74192 = nc.method_43485();
            if (class_74192 instanceof class_2575) {
                class_2575 ds = (class_2575)class_74192;
                nbtBuilder = Component.blockNBT().pos(BlockNBTComponent.Pos.fromString((String)ds.comp_733()));
            } else {
                class_74192 = nc.method_43485();
                if (class_74192 instanceof class_2576) {
                    class_2576 ds = (class_2576)class_74192;
                    nbtBuilder = Component.entityNBT().selector(ds.comp_735());
                } else {
                    class_74192 = nc.method_43485();
                    if (class_74192 instanceof class_4616) {
                        class_4616 ds = (class_4616)class_74192;
                        nbtBuilder = Component.storageNBT().storage(SpongeAdventure.asAdventure(ds.comp_738()));
                    } else {
                        throw new UnsupportedOperationException("Cannot convert NBTContents with DataSource " + String.valueOf(nc.method_43485().getClass()));
                    }
                }
            }
            return nbtBuilder.nbtPath(nc.method_10920()).interpret(nc.method_10921()).separator((ComponentLike)SpongeAdventure.asAdventure(nc.method_43484()));
        }
        throw new UnsupportedOperationException("Cannot convert ComponentContents of type " + String.valueOf(contents.getClass()));
    }

    public static @Nullable Component asAdventure(Optional<class_2561> component) {
        return component.map(SpongeAdventure::asAdventure).orElse(null);
    }

    public static Style asAdventure(class_2583 mcStyle) {
        class_2558 clickEvent;
        Style.Builder builder = Style.style();
        StyleAccessor $access = (StyleAccessor)mcStyle;
        builder.font(SpongeAdventure.asAdventure($access.accessor$font()));
        builder.color(SpongeAdventure.asAdventure(mcStyle.method_10973()));
        builder.decoration(TextDecoration.OBFUSCATED, TextDecoration.State.byBoolean((Boolean)$access.accessor$obfuscated()));
        builder.decoration(TextDecoration.BOLD, TextDecoration.State.byBoolean((Boolean)$access.accessor$bold()));
        builder.decoration(TextDecoration.STRIKETHROUGH, TextDecoration.State.byBoolean((Boolean)$access.accessor$strikethrough()));
        builder.decoration(TextDecoration.UNDERLINED, TextDecoration.State.byBoolean((Boolean)$access.accessor$underlined()));
        builder.decoration(TextDecoration.ITALIC, TextDecoration.State.byBoolean((Boolean)$access.accessor$italic()));
        class_2568 hoverEvent = mcStyle.method_10969();
        if (hoverEvent != null) {
            builder.hoverEvent(SpongeAdventure.asAdventure(hoverEvent));
        }
        if ((clickEvent = mcStyle.method_10970()) != null) {
            builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)SpongeAdventure.asAdventure(clickEvent.method_10845()), (String)clickEvent.method_10844()));
        }
        builder.insertion(mcStyle.method_10955());
        return builder.build();
    }

    public static Component asAdventure(Message message) {
        if (message instanceof class_2561) {
            return SpongeAdventure.asAdventure((class_2561)message);
        }
        if (message instanceof Component) {
            return (Component)message;
        }
        return Component.text((String)message.getString());
    }

    public static class_2583 asVanilla(Style style) {
        return ((StyleBridge)style).bridge$asVanilla();
    }

    public static @Nullable class_5251 asVanillaNullable(@Nullable TextColor color) {
        if (color == null) {
            return null;
        }
        return class_5251.method_27717((int)color.value());
    }

    public static class_124 asVanilla(NamedTextColor color) {
        if (color == NamedTextColor.BLACK) {
            return class_124.field_1074;
        }
        if (color == NamedTextColor.DARK_BLUE) {
            return class_124.field_1058;
        }
        if (color == NamedTextColor.DARK_GREEN) {
            return class_124.field_1077;
        }
        if (color == NamedTextColor.DARK_AQUA) {
            return class_124.field_1062;
        }
        if (color == NamedTextColor.DARK_RED) {
            return class_124.field_1079;
        }
        if (color == NamedTextColor.DARK_PURPLE) {
            return class_124.field_1064;
        }
        if (color == NamedTextColor.GOLD) {
            return class_124.field_1065;
        }
        if (color == NamedTextColor.GRAY) {
            return class_124.field_1080;
        }
        if (color == NamedTextColor.DARK_GRAY) {
            return class_124.field_1063;
        }
        if (color == NamedTextColor.BLUE) {
            return class_124.field_1078;
        }
        if (color == NamedTextColor.GREEN) {
            return class_124.field_1060;
        }
        if (color == NamedTextColor.AQUA) {
            return class_124.field_1075;
        }
        if (color == NamedTextColor.RED) {
            return class_124.field_1061;
        }
        if (color == NamedTextColor.LIGHT_PURPLE) {
            return class_124.field_1076;
        }
        if (color == NamedTextColor.YELLOW) {
            return class_124.field_1054;
        }
        if (color == NamedTextColor.WHITE) {
            return class_124.field_1068;
        }
        throw new IllegalArgumentException();
    }

    public static @Nullable TextColor asAdventure(@Nullable class_5251 color) {
        if (color == null) {
            return null;
        }
        return TextColor.color((int)color.method_27716());
    }

    public static @Nullable TextColor asAdventure(class_124 formatting) {
        if (formatting == null) {
            return null;
        }
        Integer color = formatting.method_532();
        if (color == null) {
            return null;
        }
        return TextColor.color((int)color);
    }

    public static @Nullable NamedTextColor asAdventureNamed(@Nullable class_124 color) {
        if (color == null) {
            return null;
        }
        if (color == class_124.field_1074) {
            return NamedTextColor.BLACK;
        }
        if (color == class_124.field_1058) {
            return NamedTextColor.DARK_BLUE;
        }
        if (color == class_124.field_1077) {
            return NamedTextColor.DARK_GREEN;
        }
        if (color == class_124.field_1062) {
            return NamedTextColor.DARK_AQUA;
        }
        if (color == class_124.field_1079) {
            return NamedTextColor.DARK_RED;
        }
        if (color == class_124.field_1064) {
            return NamedTextColor.DARK_PURPLE;
        }
        if (color == class_124.field_1065) {
            return NamedTextColor.GOLD;
        }
        if (color == class_124.field_1080) {
            return NamedTextColor.GRAY;
        }
        if (color == class_124.field_1063) {
            return NamedTextColor.DARK_GRAY;
        }
        if (color == class_124.field_1078) {
            return NamedTextColor.BLUE;
        }
        if (color == class_124.field_1060) {
            return NamedTextColor.GREEN;
        }
        if (color == class_124.field_1075) {
            return NamedTextColor.AQUA;
        }
        if (color == class_124.field_1061) {
            return NamedTextColor.RED;
        }
        if (color == class_124.field_1076) {
            return NamedTextColor.LIGHT_PURPLE;
        }
        if (color == class_124.field_1054) {
            return NamedTextColor.YELLOW;
        }
        return NamedTextColor.WHITE;
    }

    public static @Nullable Boolean asVanillaNullable(TextDecoration.State state) {
        if (state == TextDecoration.State.TRUE) {
            return true;
        }
        if (state == TextDecoration.State.FALSE) {
            return false;
        }
        return null;
    }

    public static HoverEvent<?> asAdventure(class_2568 event) {
        class_2568.class_5247 action = event.method_10892();
        if (action == class_2568.class_5247.field_24342) {
            return HoverEvent.showText((Component)SpongeAdventure.asAdventure((class_2561)event.method_10891(class_2568.class_5247.field_24342)));
        }
        if (action == class_2568.class_5247.field_24344) {
            class_2568.class_5248 value = (class_2568.class_5248)event.method_10891(class_2568.class_5247.field_24344);
            class_2378 entityTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41266);
            return HoverEvent.showEntity((Key)SpongeAdventure.asAdventure(entityTypeRegistry.method_10221((Object)value.field_24351)), (UUID)value.field_24352, (Component)SpongeAdventure.asAdventure(value.field_24353));
        }
        if (action == class_2568.class_5247.field_24343) {
            class_2568.class_5249 value = (class_2568.class_5249)event.method_10891(class_2568.class_5247.field_24343);
            class_2378 itemRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41197);
            class_1799 itemStack = value.method_27683();
            return HoverEvent.showItem((Keyed)SpongeAdventure.asAdventure(itemRegistry.method_10221((Object)itemStack.method_7909())), (int)itemStack.method_7947(), SpongeAdventure.asAdventure(itemStack.method_57380()));
        }
        throw new IllegalArgumentException(event.toString());
    }

    public static @Nullable class_2558 asVanillaNullable(@Nullable ClickEvent event) {
        if (event == null) {
            return null;
        }
        return new class_2558(SpongeAdventure.asVanilla(event.action()), event.value());
    }

    public static @Nullable class_2568 asVanillaNullable(@Nullable HoverEvent<?> event) {
        if (event == null) {
            return null;
        }
        HoverEvent.Action action = event.action();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return new class_2568(class_2568.class_5247.field_24342, (Object)SpongeAdventure.asVanilla((Component)event.value()));
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity value = (HoverEvent.ShowEntity)event.value();
            class_2378 entityTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41266);
            return new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248((class_1299)entityTypeRegistry.method_63535(SpongeAdventure.asVanilla(value.type())), value.id(), SpongeAdventure.asVanillaNullable(value.name())));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem value = (HoverEvent.ShowItem)event.value();
            class_2378 itemRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41197);
            return new class_2568(class_2568.class_5247.field_24343, (Object)HoverEvent_ItemStackInfoAccessor.invoker$new((class_6880<class_1792>)class_6880.method_40223((Object)((class_1792)itemRegistry.method_63535(SpongeAdventure.asVanilla(value.item())))), value.count(), SpongeAdventure.asVanilla(value.dataComponents())));
        }
        throw new IllegalArgumentException(event.toString());
    }

    public static class_2568.class_5247<?> asVanilla(HoverEvent.Action<?> action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return class_2568.class_5247.field_24342;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return class_2568.class_5247.field_24343;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return class_2568.class_5247.field_24344;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static ClickEvent.Action asAdventure(class_2558.class_2559 action) {
        if (action == class_2558.class_2559.field_11749) {
            return ClickEvent.Action.OPEN_URL;
        }
        if (action == class_2558.class_2559.field_11746) {
            return ClickEvent.Action.OPEN_FILE;
        }
        if (action == class_2558.class_2559.field_11750) {
            return ClickEvent.Action.RUN_COMMAND;
        }
        if (action == class_2558.class_2559.field_11745) {
            return ClickEvent.Action.SUGGEST_COMMAND;
        }
        if (action == class_2558.class_2559.field_11748) {
            return ClickEvent.Action.CHANGE_PAGE;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static class_2558.class_2559 asVanilla(ClickEvent.Action action) {
        if (action == ClickEvent.Action.OPEN_URL) {
            return class_2558.class_2559.field_11749;
        }
        if (action == ClickEvent.Action.OPEN_FILE) {
            return class_2558.class_2559.field_11746;
        }
        if (action == ClickEvent.Action.RUN_COMMAND) {
            return class_2558.class_2559.field_11750;
        }
        if (action == ClickEvent.Action.SUGGEST_COMMAND) {
            return class_2558.class_2559.field_11745;
        }
        if (action == ClickEvent.Action.CHANGE_PAGE) {
            return class_2558.class_2559.field_11748;
        }
        if (action == ClickEvent.Action.COPY_TO_CLIPBOARD) {
            return class_2558.class_2559.field_21462;
        }
        throw new IllegalArgumentException(action.toString());
    }

    public static List<Component> json(List<String> strings) {
        GsonComponentSerializer gcs = GsonComponentSerializer.gson();
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : strings) {
            components.add(gcs.deserialize((Object)string));
        }
        return components;
    }

    public static class_2499 listTagJson(List<Component> components) {
        GsonComponentSerializer gcs = GsonComponentSerializer.gson();
        class_2499 nbt = new class_2499();
        for (Component component : components) {
            nbt.add((Object)class_2519.method_23256((String)((String)gcs.serialize(component))));
        }
        return nbt;
    }

    public static BossBar asAdventure(class_1259 bar) {
        return ((BossEventBridge)bar).bridge$asAdventure();
    }

    public static class_3213 asVanillaServer(BossBar bar) {
        return ((BossBarBridge)bar).bridge$asVanillaServerBar();
    }

    public static class_1259.class_1260 asVanilla(BossBar.Color color) {
        if (color == BossBar.Color.PINK) {
            return class_1259.class_1260.field_5788;
        }
        if (color == BossBar.Color.BLUE) {
            return class_1259.class_1260.field_5780;
        }
        if (color == BossBar.Color.RED) {
            return class_1259.class_1260.field_5784;
        }
        if (color == BossBar.Color.GREEN) {
            return class_1259.class_1260.field_5785;
        }
        if (color == BossBar.Color.YELLOW) {
            return class_1259.class_1260.field_5782;
        }
        if (color == BossBar.Color.PURPLE) {
            return class_1259.class_1260.field_5783;
        }
        if (color == BossBar.Color.WHITE) {
            return class_1259.class_1260.field_5786;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossBar.Color asAdventure(class_1259.class_1260 color) {
        if (color == class_1259.class_1260.field_5788) {
            return BossBar.Color.PINK;
        }
        if (color == class_1259.class_1260.field_5780) {
            return BossBar.Color.BLUE;
        }
        if (color == class_1259.class_1260.field_5784) {
            return BossBar.Color.RED;
        }
        if (color == class_1259.class_1260.field_5785) {
            return BossBar.Color.GREEN;
        }
        if (color == class_1259.class_1260.field_5782) {
            return BossBar.Color.YELLOW;
        }
        if (color == class_1259.class_1260.field_5783) {
            return BossBar.Color.PURPLE;
        }
        if (color == class_1259.class_1260.field_5786) {
            return BossBar.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static class_1259.class_1261 asVanilla(BossBar.Overlay overlay) {
        if (overlay == BossBar.Overlay.PROGRESS) {
            return class_1259.class_1261.field_5795;
        }
        if (overlay == BossBar.Overlay.NOTCHED_6) {
            return class_1259.class_1261.field_5796;
        }
        if (overlay == BossBar.Overlay.NOTCHED_10) {
            return class_1259.class_1261.field_5791;
        }
        if (overlay == BossBar.Overlay.NOTCHED_12) {
            return class_1259.class_1261.field_5793;
        }
        if (overlay == BossBar.Overlay.NOTCHED_20) {
            return class_1259.class_1261.field_5790;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static BossBar.Overlay asAdventure(class_1259.class_1261 overlay) {
        if (overlay == class_1259.class_1261.field_5795) {
            return BossBar.Overlay.PROGRESS;
        }
        if (overlay == class_1259.class_1261.field_5796) {
            return BossBar.Overlay.NOTCHED_6;
        }
        if (overlay == class_1259.class_1261.field_5791) {
            return BossBar.Overlay.NOTCHED_10;
        }
        if (overlay == class_1259.class_1261.field_5793) {
            return BossBar.Overlay.NOTCHED_12;
        }
        if (overlay == class_1259.class_1261.field_5790) {
            return BossBar.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static Set<BossBar.Flag> asAdventureFlags(boolean darkenScreen, boolean playBossMusic, boolean createWorldFog) {
        EnumSet<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);
        if (darkenScreen) {
            flags.add(BossBar.Flag.DARKEN_SCREEN);
        }
        if (playBossMusic) {
            flags.add(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
        if (createWorldFog) {
            flags.add(BossBar.Flag.CREATE_WORLD_FOG);
        }
        return flags;
    }

    public static class_9326 asVanilla(Map<Key, DataComponentValue> componentMap) {
        if (componentMap == null) {
            return class_9326.field_49588;
        }
        class_9326.class_9327 builder = class_9326.method_57841();
        componentMap.forEach((key, value) -> class_7923.field_49658.method_17966(SpongeAdventure.asVanilla(key)).ifPresent(type -> {
            if (value instanceof SpongeDataComponentValue) {
                SpongeDataComponentValue dcv = (SpongeDataComponentValue)value;
                builder.method_57854(type, dcv.value.orElse(null));
            }
        }));
        return builder.method_57852();
    }

    public static Map<Key, DataComponentValue> asAdventure(class_9326 components) {
        if (components == null) {
            return Map.of();
        }
        HashMap<Key, DataComponentValue> map = new HashMap<Key, DataComponentValue>();
        components.method_57846().forEach(entry -> {
            class_2960 key = class_7923.field_49658.method_10221((Object)((class_9331)entry.getKey()));
            map.put(SpongeAdventure.asAdventure(key), new SpongeDataComponentValue((Optional)entry.getValue()));
        });
        return map;
    }

    public static class_2960 asVanilla(Key key) {
        if (key instanceof class_2960) {
            return (class_2960)key;
        }
        return class_2960.method_60655((String)key.namespace(), (String)key.value());
    }

    public static @Nullable class_2960 asVanillaNullable(@Nullable Key key) {
        if (key == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(key);
    }

    public static Sound.Source asAdventure(class_3419 source) {
        switch (source) {
            case field_15250: {
                return Sound.Source.MASTER;
            }
            case field_15253: {
                return Sound.Source.MUSIC;
            }
            case field_15247: {
                return Sound.Source.RECORD;
            }
            case field_15252: {
                return Sound.Source.WEATHER;
            }
            case field_15245: {
                return Sound.Source.BLOCK;
            }
            case field_15251: {
                return Sound.Source.HOSTILE;
            }
            case field_15254: {
                return Sound.Source.NEUTRAL;
            }
            case field_15248: {
                return Sound.Source.PLAYER;
            }
            case field_15256: {
                return Sound.Source.AMBIENT;
            }
            case field_15246: {
                return Sound.Source.VOICE;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static class_3419 asVanilla(Sound.Source source) {
        switch (source) {
            case MASTER: {
                return class_3419.field_15250;
            }
            case MUSIC: {
                return class_3419.field_15253;
            }
            case RECORD: {
                return class_3419.field_15247;
            }
            case WEATHER: {
                return class_3419.field_15252;
            }
            case BLOCK: {
                return class_3419.field_15245;
            }
            case HOSTILE: {
                return class_3419.field_15251;
            }
            case NEUTRAL: {
                return class_3419.field_15254;
            }
            case PLAYER: {
                return class_3419.field_15248;
            }
            case AMBIENT: {
                return class_3419.field_15256;
            }
            case VOICE: {
                return class_3419.field_15246;
            }
        }
        throw new IllegalArgumentException(source.name());
    }

    public static @Nullable class_3419 asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return SpongeAdventure.asVanilla(source);
    }

    public static Iterable<? extends Audience> unpackAudiences(Audience audience) {
        if (audience instanceof ForwardingAudience) {
            ArrayList list = new ArrayList();
            for (Audience subAudience : ((ForwardingAudience)audience).audiences()) {
                SpongeAdventure.unpackAudiences(subAudience).forEach(list::add);
            }
            return list;
        }
        return Collections.singletonList(audience);
    }

    public static void registerBossBar(class_3213 mcBar) {
        ACTIVE_BOSS_BARS.add(mcBar);
    }

    public static void unregisterBossBar(class_3213 mcBar) {
        ACTIVE_BOSS_BARS.remove(mcBar);
    }

    public static void forEachBossBar(Consumer<class_3213> info) {
        ACTIVE_BOSS_BARS.forEach(info);
    }

    private record SpongeDataComponentValue<T>(Optional<T> value) implements DataComponentValue
    {
    }

    public static class Factory
    implements SpongeComponents.Factory {
        public @NonNull ClickEvent callbackClickEvent(@NonNull Consumer<CommandCause> callback) {
            Objects.requireNonNull(callback);
            UUID key = CallbackCommand.INSTANCE.registerCallback(callback);
            return ClickEvent.runCommand((String)String.format("/%s:%s %s", ((Launch)Launch.instance()).id(), "callback", key));
        }

        @SafeVarargs
        public final @NonNull Component render(@NonNull Component component, @NonNull CommandCause senderContext, @Nullable Audience viewer, @NonNull DefaultedRegistryReference<ResolveOperation> firstOperation, DefaultedRegistryReference<ResolveOperation> ... otherOperations) {
            Component output = Objects.requireNonNull(component, "component");
            Objects.requireNonNull(senderContext, "senderContext");
            while (viewer instanceof ForwardingAudience.Single && !(viewer instanceof Entity)) {
                viewer = ((ForwardingAudience.Single)viewer).audience();
            }
            Entity backing = viewer instanceof Entity ? (Entity)viewer : null;
            output = ((SpongeResolveOperation)Objects.requireNonNull(firstOperation, "firstOperation").get()).resolve(output, senderContext, backing);
            for (DefaultedRegistryReference<ResolveOperation> ref : otherOperations) {
                output = ((SpongeResolveOperation)ref.get()).resolve(output, senderContext, backing);
            }
            return output;
        }

        @SafeVarargs
        public final @NonNull Component render(@NonNull Component component, @NonNull CommandCause senderContext, @NonNull DefaultedRegistryReference<ResolveOperation> firstOperation, DefaultedRegistryReference<ResolveOperation> ... otherOperations) {
            return this.render(component, senderContext, (Audience)null, firstOperation, otherOperations);
        }

        public ComponentFlattener flattener() {
            return ComponentFlattenerProvider.INSTANCE;
        }
    }
}

