/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.text.format.Style;
import net.minecraft.class_2556;
import net.minecraft.class_2583;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7463;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.adventure.ChatType;
import org.spongepowered.api.adventure.ChatTypeTemplate;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeChatTypeTemplate
extends Record
implements ChatTypeTemplate {
    private final ResourceKey key;
    private final class_2556 representedType;
    private final DataPack<ChatTypeTemplate> pack;

    public SpongeChatTypeTemplate(ResourceKey key, class_2556 representedType, DataPack<ChatTypeTemplate> pack) {
        this.key = key;
        this.representedType = representedType;
        this.pack = pack;
    }

    public ChatType type() {
        return (ChatType)this.representedType;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeChatTypeTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized ChatType:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(ChatTypeTemplate template, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (JsonElement)class_2556.field_39227.encodeStart((DynamicOps)ops, (Object)((class_2556)template.type())).getOrThrow();
    }

    public static class_2556 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_2556)class_2556.field_39227.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static ChatTypeTemplate decode(DataPack<ChatTypeTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_2556 parsed = SpongeChatTypeTemplate.decode(packEntry, registryAccess);
        return new SpongeChatTypeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeChatTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeChatTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeChatTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_2556 representedType() {
        return this.representedType;
    }

    public DataPack<ChatTypeTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<ChatType, ChatTypeTemplate, ChatTypeTemplate.Builder>
    implements ChatTypeTemplate.Builder {
        private String translationKey;
        private class_2583 style;
        private List<class_7463.class_7464> parameters;
        private class_7463 narration;

        public BuilderImpl() {
            this.reset();
        }

        public ChatTypeTemplate.Builder fromValue(ChatType value) {
            class_2556 chatType = (class_2556)value;
            this.translationKey = chatType.comp_792().comp_788();
            this.parameters = chatType.comp_792().comp_789();
            this.style = chatType.comp_792().comp_790();
            this.narration = chatType.comp_794();
            return this;
        }

        public ChatTypeTemplate.Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        public ChatTypeTemplate.Builder style(Style style) {
            this.style = SpongeAdventure.asVanilla(style);
            return this;
        }

        private void addParameter(class_7463.class_7464 parameter) {
            if (this.parameters.contains(parameter)) {
                // empty if block
            }
            this.parameters.add(parameter);
        }

        public ChatTypeTemplate.Builder addSender() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<class_7463.class_7464>();
            }
            this.addParameter(class_7463.class_7464.field_39220);
            return this;
        }

        public ChatTypeTemplate.Builder addContent() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<class_7463.class_7464>();
            }
            this.addParameter(class_7463.class_7464.field_39222);
            return this;
        }

        public ChatTypeTemplate.Builder addTarget() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<class_7463.class_7464>();
            }
            this.addParameter(class_7463.class_7464.field_39221);
            return this;
        }

        @Override
        public Function<ChatTypeTemplate, ChatType> valueExtractor() {
            return ChatTypeTemplate::type;
        }

        public ChatTypeTemplate.Builder reset() {
            this.key = null;
            this.pack = DataPacks.CHAT_TYPE;
            this.translationKey = null;
            this.style = class_2583.field_24360;
            this.parameters = null;
            this.narration = class_7463.method_43831((String)"chat.type.text.narrate");
            return this;
        }

        public ChatTypeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
            class_2556 chatType = SpongeChatTypeTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611());
            this.fromValue((ChatType)chatType);
            return this;
        }

        @Override
        protected ChatTypeTemplate build0() {
            Objects.requireNonNull(this.translationKey, "name");
            Objects.requireNonNull(this.parameters, "parameter");
            Objects.requireNonNull(this.style, "style");
            class_2556 chatType = new class_2556(new class_7463(this.translationKey, this.parameters, this.style), this.narration);
            return new SpongeChatTypeTemplate(this.key, chatType, (DataPack<ChatTypeTemplate>)this.pack);
        }
    }
}

