/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.adventure.ResolveOperation;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.adventure.ComponentBridge;

public abstract class SpongeResolveOperation
implements ResolveOperation {
    private static final Logger LOGGER = LogManager.getLogger();

    public abstract Component resolve(Component var1, CommandCause var2, @Nullable Entity var3);

    public static SpongeResolveOperation newCustomTranslations() {
        return new SpongeResolveOperation(){

            @Override
            public Component resolve(Component input, CommandCause senderContext, @Nullable Entity viewer) {
                Locale targetLocale = viewer instanceof ServerPlayer ? ((ServerPlayer)viewer).locale() : Locale.getDefault();
                return GlobalTranslator.render((Component)input, (Locale)targetLocale);
            }
        };
    }

    public static SpongeResolveOperation newContextualComponents() {
        return new SpongeResolveOperation(){

            @Override
            public Component resolve(Component input, CommandCause senderContext, @Nullable Entity viewer) {
                try {
                    return SpongeAdventure.asAdventure((class_2561)class_2564.method_10881((class_2168)((class_2168)senderContext), (class_2561)((ComponentBridge)input).bridge$asVanillaComponent(), (class_1297)((class_1297)viewer), (int)0));
                }
                catch (CommandSyntaxException ex) {
                    LOGGER.error("Failed to resolve component {} due to a parsing error", (Object)input, (Object)ex);
                    return input;
                }
            }
        };
    }
}

