/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record LaunchConfig(String args, String additionalPluginsDirectory, String librariesDirectory, boolean autoDownloadLibraries, boolean checkLibraryHashes) {
    public static final LaunchConfig DEFAULT = new LaunchConfig("--nogui", "${MODS_DIR}/plugins", "${BASE_DIR}/libraries", true, true);

    public Properties toProperties() {
        Properties props = new Properties();
        props.put("args", this.args);
        props.put("additional-plugins-directory", this.additionalPluginsDirectory);
        props.put("libraries-directory", this.librariesDirectory);
        props.put("auto-download-libraries", Boolean.toString(this.autoDownloadLibraries));
        props.put("check-library-hashes", Boolean.toString(this.checkLibraryHashes));
        return props;
    }

    public LaunchConfig withProperties(Properties props) {
        return new LaunchConfig(LaunchConfig.getString(props, "args", this.args), LaunchConfig.getString(props, "additional-plugins-directory", this.additionalPluginsDirectory), LaunchConfig.getString(props, "libraries-directory", this.librariesDirectory), LaunchConfig.getBoolean(props, "auto-download-libraries", this.autoDownloadLibraries), LaunchConfig.getBoolean(props, "check-library-hashes", this.checkLibraryHashes));
    }

    public LaunchConfig withAdditionalPluginsDirectory(String additionalPluginsDirectory) {
        return new LaunchConfig(this.args, additionalPluginsDirectory, this.librariesDirectory, this.autoDownloadLibraries, this.checkLibraryHashes);
    }

    private static String getString(Properties props, String key, String defaultValue) {
        Object value = props.get(key);
        return value == null ? defaultValue : value.toString();
    }

    private static boolean getBoolean(Properties props, String key, boolean defaultValue) {
        Object value = props.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value.toString());
    }

    public static LaunchConfig load(Path baseDir, boolean convertLegacy) throws IOException {
        Path configDir = baseDir.resolve("config/sponge");
        Path launchConfigFile = configDir.resolve("launch.properties");
        if (Files.exists(launchConfigFile, new LinkOption[0])) {
            Properties props = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(launchConfigFile);){
                props.load(reader);
            }
            return DEFAULT.withProperties(props);
        }
        LaunchConfig launchConfig = DEFAULT;
        Path launcherConfigFile = baseDir.resolve("launcher.conf");
        if (convertLegacy) {
            Matcher matcher;
            Path commonConfigFile = configDir.resolve("sponge.conf");
            if (Files.exists(commonConfigFile, new LinkOption[0]) && (matcher = Pattern.compile("plugins-dir=\"(.*)\"").matcher(Files.readString(commonConfigFile))).find()) {
                launchConfig = launchConfig.withAdditionalPluginsDirectory(LaunchConfig.convertLegacyPath(matcher.group(1)));
            }
            if (Files.exists(launcherConfigFile, new LinkOption[0])) {
                Properties props = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(launcherConfigFile);){
                    props.load(reader);
                }
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    Object object = entry.getValue();
                    if (!(object instanceof String)) continue;
                    String value = (String)object;
                    entry.setValue(value.replace("\"", "").replace("BASE_DIRECTORY", "BASE_DIR"));
                }
                launchConfig = launchConfig.withProperties(props);
            }
        }
        Files.createDirectories(configDir, new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(launchConfigFile, new OpenOption[0]);){
            launchConfig.toProperties().store(writer, "Sponge launch configuration");
        }
        if (convertLegacy) {
            Files.deleteIfExists(launcherConfigFile);
        }
        return launchConfig;
    }

    public static String convertLegacyPath(String value) {
        return value.replace("${CANONICAL_GAME_DIR}", "${BASE_DIR}").replace("${CANONICAL_MODS_DIR}", "${MODS_DIR}").replace("${CANONICAL_CONFIG_DIR}", "${CONFIG_DIR}");
    }
}

