/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TokenReplacement {
    private static final Pattern TOKEN_MATCH = Pattern.compile("\\$\\{([^}]+)}");
    private final Map<String, String> tokens = new HashMap<String, String>();

    public void register(String token, Path replacement) {
        this.register(token, replacement.toAbsolutePath().toString().replace("\\", "\\\\"));
    }

    public void register(String token, String replacement) {
        this.tokens.put(token.toLowerCase(Locale.ROOT), replacement);
    }

    public String replace(String input) {
        Matcher matcher = TOKEN_MATCH.matcher(input);
        if (!matcher.find()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        do {
            String token;
            String replacement;
            if ((replacement = this.tokens.get(token = matcher.group(1).toLowerCase(Locale.ROOT))) == null) {
                throw new IllegalArgumentException("Unknown token: " + token);
            }
            matcher.appendReplacement(result, replacement);
        } while (matcher.find());
        matcher.appendTail(result);
        return result.toString();
    }
}

