/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.builtin.StandardInheritable;
import org.spongepowered.plugin.metadata.builtin.StandardPluginMetadata;

public class PluginMetadataFixer {
    private static final Set<String> invalidPluginIds = new HashSet<String>();

    public static MetadataContainer fixPluginIds(MetadataContainer container) {
        boolean modified = false;
        ArrayList<StandardPluginMetadata> metadata = new ArrayList<StandardPluginMetadata>();
        for (PluginMetadata plugin : container.metadata()) {
            String id = plugin.id();
            if (id.indexOf(45) >= 0) {
                String newId = id.replace('-', '_');
                if (invalidPluginIds.add(id)) {
                    AppLaunch.pluginPlatform().logger().warn("The dash character (-) is no longer supported in plugin ids.\nPlugin {} will be loaded as {}. If you are the developer of this plugin, please change the id.", (Object)id, (Object)newId);
                }
                StandardPluginMetadata.Builder pluginBuilder = ((StandardPluginMetadata.Builder)StandardPluginMetadata.builder().from((StandardInheritable)((StandardPluginMetadata)plugin))).id(newId).entrypoint(plugin.entrypoint());
                plugin.name().ifPresent(arg_0 -> ((StandardPluginMetadata.Builder)pluginBuilder).name(arg_0));
                plugin.description().ifPresent(arg_0 -> ((StandardPluginMetadata.Builder)pluginBuilder).description(arg_0));
                metadata.add((StandardPluginMetadata)pluginBuilder.build());
                modified = true;
                continue;
            }
            metadata.add((StandardPluginMetadata)plugin);
        }
        if (!modified) {
            return container;
        }
        MetadataContainer.Builder builder = container.toBuilder();
        builder.metadata(metadata);
        try {
            return builder.build();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }
}

